/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.network.payloads;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import sfiomn.legendarysurvivaloverhaul.LegendarySurvivalOverhaul;
import sfiomn.legendarysurvivaloverhaul.api.bodydamage.BodyDamageUtil;
import sfiomn.legendarysurvivaloverhaul.api.bodydamage.BodyPartEnum;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonHealingConsumable;
import sfiomn.legendarysurvivaloverhaul.api.data.manager.BodyDamageDataManager;
import sfiomn.legendarysurvivaloverhaul.common.integration.supplementaries.SupplementariesUtil;
import sfiomn.legendarysurvivaloverhaul.registry.MobEffectRegistry;
import sfiomn.legendarysurvivaloverhaul.registry.SoundRegistry;

public record BodyPartHealingTimeMessage(CompoundTag compound) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"legendarysurvivaloverhaul", (String)"body_part_healing_time");
    public static final CustomPacketPayload.Type<BodyPartHealingTimeMessage> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, BodyPartHealingTimeMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.COMPOUND_TAG, BodyPartHealingTimeMessage::compound, BodyPartHealingTimeMessage::new);

    public BodyPartHealingTimeMessage(BodyPartEnum bodyPart, InteractionHand hand, boolean consumeItem, boolean applyEffect) {
        this(BodyPartHealingTimeMessage.createPayload(bodyPart, hand, consumeItem, applyEffect));
    }

    private static CompoundTag createPayload(BodyPartEnum bodyPart, InteractionHand hand, boolean consumeItem, boolean applyEffect) {
        CompoundTag bodyPartHealNbt = new CompoundTag();
        bodyPartHealNbt.putString("bodyPartEnum", bodyPart.name());
        bodyPartHealNbt.putBoolean("mainHand", hand == InteractionHand.MAIN_HAND);
        bodyPartHealNbt.putBoolean("consumeItem", consumeItem);
        bodyPartHealNbt.putBoolean("applyEffect", applyEffect);
        return bodyPartHealNbt;
    }

    public static void handle(BodyPartHealingTimeMessage pkt, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player patt0$temp = ctx.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                BodyPartHealingTimeMessage.applyHealingItemOnServer(serverPlayer, pkt.compound());
            }
        });
    }

    public static void applyHealingItemOnServer(ServerPlayer player, CompoundTag nbt) {
        ItemStack itemStackInBasket;
        BodyPartEnum bodyPartEnum = BodyPartEnum.valueOf(nbt.getString("bodyPartEnum"));
        InteractionHand hand = nbt.getBoolean("mainHand") ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        boolean shouldConsume = nbt.getBoolean("consumeItem");
        boolean shouldApplyEffect = nbt.getBoolean("applyEffect");
        ItemStack usedItemStack = player.getItemInHand(hand);
        if (LegendarySurvivalOverhaul.supplementariesLoaded && (itemStackInBasket = SupplementariesUtil.getSelectedItemInLunchBasket(player.getItemInHand(hand))) != ItemStack.EMPTY) {
            usedItemStack = itemStackInBasket;
        }
        ResourceLocation itemStackRegistryName = BuiltInRegistries.ITEM.getKey((Object)usedItemStack.getItem());
        JsonHealingConsumable jhc = BodyDamageDataManager.getHealingItem(itemStackRegistryName);
        player.serverLevel().playSound(null, (Entity)player, (SoundEvent)SoundRegistry.HEAL_BODY_PART.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        if (shouldConsume && !player.isCreative()) {
            usedItemStack.shrink(1);
        }
        if (jhc != null) {
            if (shouldApplyEffect) {
                player.addEffect(new MobEffectInstance(MobEffectRegistry.RECOVERY, jhc.recoveryEffectDuration, jhc.recoveryEffectAmplifier, false, true, true));
            }
            BodyDamageUtil.applyHealingTimeBodyPart((Player)player, bodyPartEnum, jhc.healingValue, jhc.healingTime);
        }
    }

    public static void sendToServer(BodyPartEnum bodyPart, InteractionHand hand, boolean consumeItem, boolean applyEffect) {
        PacketDistributor.sendToServer((CustomPacketPayload)new BodyPartHealingTimeMessage(bodyPart, hand, consumeItem, applyEffect), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

