/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.network.payloads;

import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonThirstBlock;
import sfiomn.legendarysurvivaloverhaul.api.thirst.ThirstUtil;

public record DrinkBlockFluidMessage() implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"legendarysurvivaloverhaul", (String)"drink_block_fluid");
    public static final CustomPacketPayload.Type<DrinkBlockFluidMessage> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, DrinkBlockFluidMessage> STREAM_CODEC = StreamCodec.unit((Object)new DrinkBlockFluidMessage());

    public static void handle(DrinkBlockFluidMessage pkt, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            if (ctx.player() != null) {
                DrinkBlockFluidMessage.DrinkWaterOnServer(ctx.player());
            }
        });
    }

    public static void DrinkWaterOnServer(Player player) {
        JsonThirstBlock jsonFluidThirst = ThirstUtil.getFluidThirstLookedAt(player, player.blockInteractionRange() / 2.0);
        if (jsonFluidThirst == null) {
            return;
        }
        ThirstUtil.takeDrink(player, jsonFluidThirst.hydration, jsonFluidThirst.saturation, jsonFluidThirst.effects);
    }

    public static void sendToServer() {
        PacketDistributor.sendToServer((CustomPacketPayload)new DrinkBlockFluidMessage(), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

