/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.network.payloads;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonTemperatureBlock;
import sfiomn.legendarysurvivaloverhaul.common.listeners.TemperatureBlockListener;

public record SyncTemperatureBlocksPayload(Map<ResourceLocation, List<JsonTemperatureBlock>> temperatureBlocks) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"legendarysurvivaloverhaul", (String)"sync_temperature_blocks");
    public static final CustomPacketPayload.Type<SyncTemperatureBlocksPayload> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncTemperatureBlocksPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)ResourceLocation.STREAM_CODEC, (StreamCodec)ByteBufCodecs.fromCodecTrusted(JsonTemperatureBlock.LIST_CODEC)), SyncTemperatureBlocksPayload::temperatureBlocks, SyncTemperatureBlocksPayload::new);

    public static void handle(SyncTemperatureBlocksPayload pkt, IPayloadContext ctx) {
        if (ctx.flow() != PacketFlow.CLIENTBOUND) {
            return;
        }
        ctx.enqueueWork(() -> TemperatureBlockListener.acceptServerTemperatureBlocks(pkt.temperatureBlocks()));
    }

    public static void sendToServer(Map<ResourceLocation, List<JsonTemperatureBlock>> data) {
        PacketDistributor.sendToServer((CustomPacketPayload)new SyncTemperatureBlocksPayload(data), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendToPlayer(ServerPlayer player, Map<ResourceLocation, List<JsonTemperatureBlock>> data) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncTemperatureBlocksPayload(data), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendToAll(Map<ResourceLocation, List<JsonTemperatureBlock>> data) {
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SyncTemperatureBlocksPayload(data), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

