/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.network.payloads;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonThirstBlock;
import sfiomn.legendarysurvivaloverhaul.common.listeners.ThirstBlockListener;

public record SyncThirstBlocksPayload(Map<ResourceLocation, List<JsonThirstBlock>> thirstBlocks) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"legendarysurvivaloverhaul", (String)"sync_thirst_blocks");
    public static final CustomPacketPayload.Type<SyncThirstBlocksPayload> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncThirstBlocksPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)ResourceLocation.STREAM_CODEC, (StreamCodec)ByteBufCodecs.fromCodecTrusted(JsonThirstBlock.LIST_CODEC)), SyncThirstBlocksPayload::thirstBlocks, SyncThirstBlocksPayload::new);

    public static void handle(SyncThirstBlocksPayload pkt, IPayloadContext ctx) {
        if (ctx.flow() != PacketFlow.CLIENTBOUND) {
            return;
        }
        ctx.enqueueWork(() -> ThirstBlockListener.acceptServerThirstBlocks(pkt.thirstBlocks()));
    }

    public static void sendToServer(Map<ResourceLocation, List<JsonThirstBlock>> data) {
        PacketDistributor.sendToServer((CustomPacketPayload)new SyncThirstBlocksPayload(data), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendToPlayer(ServerPlayer player, Map<ResourceLocation, List<JsonThirstBlock>> data) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncThirstBlocksPayload(data), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendToAll(Map<ResourceLocation, List<JsonThirstBlock>> data) {
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SyncThirstBlocksPayload(data), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

