/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.util;

import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.event.ItemAttributeModifierEvent;
import sfiomn.legendarysurvivaloverhaul.util.ItemUtil;

public class AttributeBuilder {
    protected final Holder<Attribute> attribute;
    protected final ResourceLocation descriptionId;

    public AttributeBuilder(Holder<Attribute> attribute, ResourceLocation descriptionId) {
        this.attribute = attribute;
        this.descriptionId = descriptionId;
    }

    public void addModifier(ItemAttributeModifierEvent event, UUID uuid, double value) {
        if (uuid == null || this.attribute == null || this.descriptionId == null) {
            return;
        }
        try {
            EquipmentSlot slot = ItemUtil.getEquippableSlot(event.getItemStack());
            if (slot == null) {
                return;
            }
            ResourceLocation modifierId = ResourceLocation.fromNamespaceAndPath((String)this.descriptionId.getNamespace(), (String)(this.descriptionId.getPath() + "_" + uuid.toString().substring(0, 8)));
            event.addModifier(this.attribute, new AttributeModifier(modifierId, value, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)slot));
        }
        catch (Exception e) {
            System.err.println("Error adding attribute modifier: " + e.getMessage());
        }
    }

    public void addModifier(Player player, UUID uuid, double value) {
        AttributeInstance instance = player.getAttribute(this.attribute);
        if (instance != null) {
            if (instance.getModifier(this.descriptionId) != null) {
                instance.removeModifier(this.descriptionId);
            }
            instance.addPermanentModifier(new AttributeModifier(this.descriptionId, value, AttributeModifier.Operation.ADD_VALUE));
        }
    }

    public AttributeInstance getAttribute(Player player) {
        return player.getAttribute(this.attribute);
    }
}

