/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.util;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import sfiomn.legendarysurvivaloverhaul.common.integration.curios.CuriosUtil;
import sfiomn.legendarysurvivaloverhaul.config.Config;
import sfiomn.legendarysurvivaloverhaul.util.EnumUtil;

public class ItemUtil {
    private ItemUtil() {
    }

    public static boolean canBeEquippedInSlot(ItemStack stack, EquipmentSlot slot) {
        Item item = stack.getItem();
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            return armorItem.getEquipmentSlot() == slot;
        }
        if (stack.getItem() instanceof ShieldItem) {
            return slot == EquipmentSlot.OFFHAND;
        }
        if (CuriosUtil.isCuriosItem(stack)) {
            return false;
        }
        return slot == EquipmentSlot.MAINHAND;
    }

    public static EquipmentSlot getEquippableSlot(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            return armorItem.getEquipmentSlot();
        }
        if (stack.getItem() instanceof ShieldItem) {
            return EquipmentSlot.OFFHAND;
        }
        return EquipmentSlot.MAINHAND;
    }

    public static String compassLocation(Entity entity) {
        return switch (Config.Baked.compassInfoMode) {
            default -> throw new MatchException(null, null);
            case EnumUtil.CompassInfo.FULL -> "XYZ: " + entity.blockPosition().getX() + " / " + entity.blockPosition().getY() + " / " + entity.blockPosition().getZ();
            case EnumUtil.CompassInfo.HORIZONTAL -> "XZ: " + entity.blockPosition().getX() + " / " + entity.blockPosition().getZ();
            case EnumUtil.CompassInfo.NONE -> "";
        };
    }
}

