/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.util.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;
import sfiomn.legendarysurvivaloverhaul.LegendarySurvivalOverhaul;
import sfiomn.legendarysurvivaloverhaul.api.bodydamage.BodyDamageUtil;
import sfiomn.legendarysurvivaloverhaul.api.bodydamage.BodyPartEnum;
import sfiomn.legendarysurvivaloverhaul.api.bodydamage.DamageDistributionEnum;
import sfiomn.legendarysurvivaloverhaul.api.bodydamage.IBodyDamageUtil;
import sfiomn.legendarysurvivaloverhaul.api.bodydamage.MalusBodyPartEnum;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonHealingConsumable;
import sfiomn.legendarysurvivaloverhaul.api.data.manager.BodyDamageDataManager;
import sfiomn.legendarysurvivaloverhaul.api.health.HealthUtil;
import sfiomn.legendarysurvivaloverhaul.client.ClientHooks;
import sfiomn.legendarysurvivaloverhaul.common.attachments.bodydamage.BodyDamageAttachment;
import sfiomn.legendarysurvivaloverhaul.config.Config;
import sfiomn.legendarysurvivaloverhaul.registry.AttributeRegistry;
import sfiomn.legendarysurvivaloverhaul.registry.MobEffectRegistry;
import sfiomn.legendarysurvivaloverhaul.registry.SoundRegistry;
import sfiomn.legendarysurvivaloverhaul.util.AttachmentUtil;
import sfiomn.legendarysurvivaloverhaul.util.AttributeBuilder;

public class BodyDamageUtilInternal
implements IBodyDamageUtil {
    public static final UUID BROKEN_HEART_ATTRIBUTE_UUID = UUID.fromString("2e3cede5-3c18-45c2-8a46-31b89fb9c027");
    public static final AttributeBuilder BODY_RESISTANCE = new AttributeBuilder((Holder<Attribute>)AttributeRegistry.BODY_RESISTANCE, ResourceLocation.fromNamespaceAndPath((String)"legendarysurvivaloverhaul", (String)"body_resistance"));
    public static final AttributeBuilder HEAD_RESISTANCE = new AttributeBuilder((Holder<Attribute>)AttributeRegistry.HEAD_RESISTANCE, ResourceLocation.fromNamespaceAndPath((String)"legendarysurvivaloverhaul", (String)"head_temperature"));
    public static final AttributeBuilder CHEST_RESISTANCE = new AttributeBuilder((Holder<Attribute>)AttributeRegistry.CHEST_RESISTANCE, ResourceLocation.fromNamespaceAndPath((String)"legendarysurvivaloverhaul", (String)"chest_temperature"));
    public static final AttributeBuilder RIGHT_ARM_RESISTANCE = new AttributeBuilder((Holder<Attribute>)AttributeRegistry.RIGHT_ARM_RESISTANCE, ResourceLocation.fromNamespaceAndPath((String)"legendarysurvivaloverhaul", (String)"right_arm_resistance"));
    public static final AttributeBuilder LEFT_ARM_RESISTANCE = new AttributeBuilder((Holder<Attribute>)AttributeRegistry.LEFT_ARM_RESISTANCE, ResourceLocation.fromNamespaceAndPath((String)"legendarysurvivaloverhaul", (String)"left_arm_resistance"));
    public static final AttributeBuilder LEGS_RESISTANCE = new AttributeBuilder((Holder<Attribute>)AttributeRegistry.LEGS_RESISTANCE, ResourceLocation.fromNamespaceAndPath((String)"legendarysurvivaloverhaul", (String)"legs_resistance"));
    public static final AttributeBuilder FEET_RESISTANCE = new AttributeBuilder((Holder<Attribute>)AttributeRegistry.FEET_RESISTANCE, ResourceLocation.fromNamespaceAndPath((String)"legendarysurvivaloverhaul", (String)"feet_resistance"));
    public static final Map<BodyPartEnum, AttributeBuilder> bodyPartResistanceAttribute = new HashMap<BodyPartEnum, AttributeBuilder>();
    public static final Map<EquipmentSlot, UUID> equipmentSlotBodyResistanceUuid = new HashMap<EquipmentSlot, UUID>();
    private static final List<Holder<MobEffect>> firstAidSuppliesBoostingEffects = new ArrayList<Holder<MobEffect>>();
    private static final List<Holder<MobEffect>> passiveLimbRegenerationEffects = new ArrayList<Holder<MobEffect>>();
    private static final Map<MalusBodyPartEnum, Map<Float, Pair<MobEffect, Integer>>> bodyPartMalusEffects = new HashMap<MalusBodyPartEnum, Map<Float, Pair<MobEffect, Integer>>>();

    public static void initMalusConfig() {
        for (MalusBodyPartEnum malus : MalusBodyPartEnum.values()) {
            HashMap<Float, Pair> malusEffects = new HashMap<Float, Pair>();
            if (malus.effects.size() != malus.amplifiers.size() || malus.effects.size() != malus.thresholds.size()) {
                LegendarySurvivalOverhaul.LOGGER.debug("{} effects, amplifiers and thresholds elements number doesn't match. The last elements won't be used.", (Object)malus.name());
            }
            for (int i = 0; i < malus.effects.size(); ++i) {
                float malusThreshold;
                int malusAmplifier;
                MobEffect malusEffect = BuiltInRegistries.MOB_EFFECT.getOptional(ResourceLocation.parse((String)malus.effects.get(i))).orElse(null);
                if (malusEffect == null) {
                    LegendarySurvivalOverhaul.LOGGER.debug("Unknown effect {} for {}", (Object)malus.effects.get(i), (Object)malus.name());
                    continue;
                }
                try {
                    malusAmplifier = Math.abs(malus.amplifiers.get(i));
                }
                catch (IndexOutOfBoundsException e) {
                    LegendarySurvivalOverhaul.LOGGER.debug("No amplifier defined for effect {} in {}", (Object)malus.effects.get(i), (Object)malus.name());
                    continue;
                }
                try {
                    malusThreshold = (float)Mth.clamp((double)malus.thresholds.get(i), (double)0.0, (double)1.0);
                }
                catch (IndexOutOfBoundsException e) {
                    LegendarySurvivalOverhaul.LOGGER.debug("No threshold defined for effect {} in {}", (Object)malus.thresholds.get(i), (Object)malus.name());
                    continue;
                }
                malusEffects.put(Float.valueOf(malusThreshold), Pair.of((Object)malusEffect, (Object)malusAmplifier));
            }
            bodyPartMalusEffects.put(malus, malusEffects);
        }
    }

    public static void initLimbEffects() {
        for (String string : Config.Baked.firstAidSuppliesBoostedOnEffects) {
            MobEffect boostingEffect;
            if (ResourceLocation.tryParse((String)string) == null) {
                LegendarySurvivalOverhaul.LOGGER.info("First Aid Supplies boosting effect : not valid effect registry name : {}", (Object)string);
            }
            if ((boostingEffect = (MobEffect)BuiltInRegistries.MOB_EFFECT.getOptional(ResourceLocation.parse((String)string)).orElse(null)) == null) {
                LegendarySurvivalOverhaul.LOGGER.info("Unknown effect {}", (Object)string);
                continue;
            }
            firstAidSuppliesBoostingEffects.add((Holder<MobEffect>)Holder.direct((Object)boostingEffect));
        }
        for (String string : Config.Baked.passiveLimbRegenerationEffects) {
            MobEffect regenerationEffect;
            if (ResourceLocation.tryParse((String)string) == null) {
                LegendarySurvivalOverhaul.LOGGER.info("Limb Regeneration Effect : not valid effect registry name : {}", (Object)string);
            }
            if ((regenerationEffect = (MobEffect)BuiltInRegistries.MOB_EFFECT.getOptional(ResourceLocation.parse((String)string)).orElse(null)) == null) {
                LegendarySurvivalOverhaul.LOGGER.info("Unknown effect {}", (Object)string);
                continue;
            }
            passiveLimbRegenerationEffects.add((Holder<MobEffect>)Holder.direct((Object)regenerationEffect));
        }
    }

    @Override
    public void applyConsumableHealing(Player player, ItemStack itemStack, boolean itemAlreadyConsumed) {
        ResourceLocation itemRegistryName = BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem());
        JsonHealingConsumable jsonConsumableHeal = BodyDamageDataManager.getHealingItem(itemRegistryName);
        if (jsonConsumableHeal == null) {
            return;
        }
        if (Config.Baked.localizedBodyDamageEnabled && jsonConsumableHeal.healingCharges > 0) {
            if (player.level().isClientSide && Minecraft.getInstance().screen == null) {
                ClientHooks.openBodyHealthScreen(player, player.getUsedItemHand(), itemAlreadyConsumed, jsonConsumableHeal.healingCharges, jsonConsumableHeal.healingValue, jsonConsumableHeal.healingTime);
            }
        } else {
            if (Config.Baked.localizedBodyDamageEnabled) {
                for (BodyPartEnum bodyPart : BodyPartEnum.values()) {
                    BodyDamageUtil.applyHealingTimeBodyPart(player, bodyPart, jsonConsumableHeal.healingValue, jsonConsumableHeal.healingTime);
                }
            }
            if (jsonConsumableHeal.recoveryEffectDuration > 0) {
                player.addEffect(new MobEffectInstance(MobEffectRegistry.RECOVERY, jsonConsumableHeal.recoveryEffectDuration, jsonConsumableHeal.recoveryEffectAmplifier, false, true, true));
            }
            player.level().playSound(null, (Entity)player, (SoundEvent)SoundRegistry.HEAL_BODY_PART.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            if (!itemAlreadyConsumed) {
                itemStack.shrink(1);
            }
        }
    }

    @Override
    public MobEffectInstance getPlayerPassiveLimbRegenerationEffect(Player player) {
        MobEffectInstance passiveLimbRegenerationEffect = null;
        for (Holder<MobEffect> effect : passiveLimbRegenerationEffects) {
            MobEffectInstance regenerationEffect = player.getEffect(effect);
            if (regenerationEffect == null || passiveLimbRegenerationEffect != null && regenerationEffect.getAmplifier() <= passiveLimbRegenerationEffect.getAmplifier()) continue;
            passiveLimbRegenerationEffect = regenerationEffect;
        }
        return passiveLimbRegenerationEffect;
    }

    @Override
    public boolean hasPlayerFirstAidSuppliesBoostingEffect(Player player) {
        for (Holder<MobEffect> effect : firstAidSuppliesBoostingEffects) {
            if (!player.hasEffect(effect)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Pair<MobEffect, Integer>> getEffects(MalusBodyPartEnum bodyPart, float healthRatio) {
        ArrayList<Pair<MobEffect, Integer>> effects = new ArrayList<Pair<MobEffect, Integer>>();
        if (bodyPart == null) {
            return effects;
        }
        for (Map.Entry<Float, Pair<MobEffect, Integer>> effect : bodyPartMalusEffects.get((Object)bodyPart).entrySet()) {
            if (!(healthRatio <= effect.getKey().floatValue())) continue;
            effects.add(effect.getValue());
        }
        return effects;
    }

    @Override
    public void applyHealingTimeBodyPart(Player player, BodyPartEnum bodyPartEnum, float healingValue, int healingTime) {
        if (!Config.Baked.localizedBodyDamageEnabled || bodyPartEnum == null) {
            return;
        }
        BodyDamageAttachment capability = AttachmentUtil.getBodyDamageAttachment(player);
        int remainingHealingTicks = capability.getRemainingHealingTicks(bodyPartEnum);
        float healingPerTicks = capability.getHealingPerTicks(bodyPartEnum);
        float healingValuePerTick = (healingValue + (float)remainingHealingTicks * healingPerTicks) / (float)(healingTime + remainingHealingTicks);
        capability.applyHealingTime(bodyPartEnum, healingTime + remainingHealingTicks, healingValuePerTick);
    }

    @Override
    public void healBodyPart(Player player, BodyPartEnum bodyPartEnum, float healingValue) {
        if (!Config.Baked.localizedBodyDamageEnabled) {
            return;
        }
        BodyDamageAttachment capability = AttachmentUtil.getBodyDamageAttachment(player);
        capability.heal(bodyPartEnum, healingValue);
    }

    @Override
    public void hurtBodyPart(Player player, BodyPartEnum bodyPartEnum, float damageValue) {
        if (!Config.Baked.localizedBodyDamageEnabled || bodyPartEnum == null) {
            return;
        }
        BodyDamageAttachment capability = AttachmentUtil.getBodyDamageAttachment(player);
        double bodyResistance = BODY_RESISTANCE.getAttribute(player).getValue();
        double limbResistance = bodyPartResistanceAttribute.get((Object)bodyPartEnum).getAttribute(player).getValue();
        float remainingDamage = Math.max(0.0f, (damageValue *= (float)(1.0 - bodyResistance - limbResistance)) - (capability.getBodyPartMaxHealth(bodyPartEnum) - capability.getBodyPartDamage(bodyPartEnum)));
        capability.hurt(bodyPartEnum, damageValue - remainingDamage);
        if (remainingDamage > 0.0f && !bodyPartEnum.getNeighbours().isEmpty()) {
            remainingDamage /= (float)(1.0 - bodyResistance - limbResistance);
            List<BodyPartEnum> damageableBodyParts = bodyPartEnum.getNeighbours().stream().filter(bodyPart -> capability.getBodyPartHealthRatio((BodyPartEnum)((Object)bodyPart)) > 0.0f).collect(Collectors.toList());
            if (!damageableBodyParts.isEmpty()) {
                BodyPartEnum bodyPart2 = DamageDistributionEnum.ONE_OF.getBodyParts(player, damageableBodyParts).get(0);
                limbResistance = bodyPartResistanceAttribute.get((Object)bodyPart2).getAttribute(player).getValue();
                capability.hurt(bodyPart2, remainingDamage * (float)(1.0 - bodyResistance - limbResistance));
            }
        }
    }

    @Override
    public void balancedHurtBodyParts(Player player, List<BodyPartEnum> bodyParts, float damageValue) {
        if (!Config.Baked.localizedBodyDamageEnabled || bodyParts.isEmpty()) {
            return;
        }
        Collections.shuffle(bodyParts);
        for (BodyPartEnum bodyPart : bodyParts) {
            this.hurtBodyPart(player, bodyPart, damageValue / (float)bodyParts.size());
        }
    }

    @Override
    public void randomHurtBodyParts(Player player, List<BodyPartEnum> bodyParts, float damageValue) {
        if (!Config.Baked.localizedBodyDamageEnabled || bodyParts.isEmpty()) {
            return;
        }
        int bodyPartIndex = bodyParts.size() == 1 ? 0 : player.getRandom().nextInt(bodyParts.size() - 1);
        this.hurtBodyPart(player, bodyParts.get(bodyPartIndex), damageValue);
    }

    @Override
    public float getHealthRatio(Player player, BodyPartEnum bodyPartEnum) {
        if (!Config.Baked.localizedBodyDamageEnabled || bodyPartEnum == null) {
            return 0.0f;
        }
        BodyDamageAttachment capability = AttachmentUtil.getBodyDamageAttachment(player);
        return capability.getBodyPartHealthRatio(bodyPartEnum);
    }

    @Override
    public float getTotalRemainingHealing(Player player, BodyPartEnum bodyPartEnum) {
        if (!Config.Baked.localizedBodyDamageEnabled || bodyPartEnum == null) {
            return 0.0f;
        }
        BodyDamageAttachment capability = AttachmentUtil.getBodyDamageAttachment(player);
        return (float)capability.getRemainingHealingTicks(bodyPartEnum) * capability.getHealingPerTicks(bodyPartEnum);
    }

    @Override
    public float getMaxHealth(Player player, BodyPartEnum bodyPartEnum) {
        if (!Config.Baked.localizedBodyDamageEnabled || bodyPartEnum == null) {
            return 0.0f;
        }
        BodyDamageAttachment capability = AttachmentUtil.getBodyDamageAttachment(player);
        return capability.getBodyPartMaxHealth(bodyPartEnum);
    }

    @Override
    public void updatePlayerBrokenHeartAttribute(Player player) {
        int expectedBrokenHearts = 0;
        if (Config.Baked.localizedBodyDamageEnabled && Config.Baked.healthOverhaulEnabled) {
            BodyDamageAttachment capability = AttachmentUtil.getBodyDamageAttachment(player);
            expectedBrokenHearts = capability.getExpectedBrokenHearts();
        }
        HealthUtil.updateBrokenHearts(player, BROKEN_HEART_ATTRIBUTE_UUID, expectedBrokenHearts);
    }

    static {
        bodyPartResistanceAttribute.put(BodyPartEnum.HEAD, HEAD_RESISTANCE);
        bodyPartResistanceAttribute.put(BodyPartEnum.CHEST, CHEST_RESISTANCE);
        bodyPartResistanceAttribute.put(BodyPartEnum.RIGHT_ARM, RIGHT_ARM_RESISTANCE);
        bodyPartResistanceAttribute.put(BodyPartEnum.LEFT_ARM, LEFT_ARM_RESISTANCE);
        bodyPartResistanceAttribute.put(BodyPartEnum.RIGHT_LEG, LEGS_RESISTANCE);
        bodyPartResistanceAttribute.put(BodyPartEnum.LEFT_LEG, LEGS_RESISTANCE);
        bodyPartResistanceAttribute.put(BodyPartEnum.RIGHT_FOOT, FEET_RESISTANCE);
        bodyPartResistanceAttribute.put(BodyPartEnum.LEFT_FOOT, FEET_RESISTANCE);
        equipmentSlotBodyResistanceUuid.put(EquipmentSlot.HEAD, UUID.fromString("e1d9eda1-f904-4ddd-8a9f-720fa592117e"));
        equipmentSlotBodyResistanceUuid.put(EquipmentSlot.CHEST, UUID.fromString("0b743835-b4aa-4c08-aa13-f3646730a749"));
        equipmentSlotBodyResistanceUuid.put(EquipmentSlot.MAINHAND, UUID.fromString("c18151f4-cb03-4df9-994d-e4decbb60b6e"));
        equipmentSlotBodyResistanceUuid.put(EquipmentSlot.OFFHAND, UUID.fromString("0fba64c7-8863-4a17-9458-7bbce1518bf0"));
        equipmentSlotBodyResistanceUuid.put(EquipmentSlot.LEGS, UUID.fromString("e024cc3d-cd24-4bcf-b7a8-f2272e44ac2d"));
        equipmentSlotBodyResistanceUuid.put(EquipmentSlot.FEET, UUID.fromString("53523212-2ebc-4f6b-9044-7f9a1fa96852"));
    }
}

