/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.integration.terrafirmacraft;

import net.dries007.tfc.common.capabilities.heat.HeatCapability;
import net.minecraft.world.item.ItemStack;
import sfiomn.legendarysurvivaloverhaul.LegendarySurvivalOverhaul;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonTemperatureResistance;
import sfiomn.legendarysurvivaloverhaul.api.temperature.AttributeModifierBase;
import sfiomn.legendarysurvivaloverhaul.config.Config;
import sfiomn.legendarysurvivaloverhaul.util.MathUtil;

public class TerraFirmaCraftHeatItemModifier
extends AttributeModifierBase {
    @Override
    public JsonTemperatureResistance getItemAttributes(ItemStack stack) {
        JsonTemperatureResistance config = new JsonTemperatureResistance();
        if (!LegendarySurvivalOverhaul.terraFirmaCraftLoaded) {
            return config;
        }
        if (Config.Baked.tfcItemHeatMultiplier == 0.0) {
            return config;
        }
        try {
            config.temperature = MathUtil.round(TerraFirmaCraftHeatItemModifier.getUncaughtTemperature(stack), 1);
            return config;
        }
        catch (Exception e) {
            LegendarySurvivalOverhaul.LOGGER.error("An error has occurred with TerraFirmaCraft compatibility, disabling integration", (Throwable)e);
            LegendarySurvivalOverhaul.terraFirmaCraftLoaded = false;
            return config;
        }
    }

    private static float getUncaughtTemperature(ItemStack stack) {
        return (float)((double)HeatCapability.getTemperature((ItemStack)stack) * Config.Baked.tfcItemHeatMultiplier);
    }
}

