/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.data.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import sfiomn.legendarysurvivaloverhaul.registry.RecipeRegistry;

public class SewingRecipeBuilder {
    private final RecipeCategory category;
    private final Ingredient base;
    private final Ingredient addition;
    private final ItemStack result;
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();
    private final RecipeSerializer<?> type;

    public SewingRecipeBuilder(RecipeSerializer<?> type, RecipeCategory category, Ingredient base, Ingredient addition, ItemStack result) {
        this.category = category;
        this.type = type;
        this.base = base;
        this.addition = addition;
        this.result = result;
    }

    public static SewingRecipeBuilder sewingRecipe(Ingredient base, Ingredient addition, ItemStack result, RecipeCategory category) {
        return new SewingRecipeBuilder((RecipeSerializer)RecipeRegistry.SEWING_SERIALIZER.get(), category, base, addition, result);
    }

    public SewingRecipeBuilder unlockedBy(String name, CriterionTriggerInstance advancement) {
        this.advancement.m_138386_(name, advancement);
        return this;
    }

    public void save(Consumer<FinishedRecipe> consumer, String id) {
        this.save(consumer, new ResourceLocation(id));
    }

    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        this.ensureValid(id);
        this.advancement.m_138396_(RecipeBuilder.f_236353_).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
        consumer.accept(new Result(id, this.type, this.base, this.addition, this.result, this.advancement, id.m_246208_("recipes/" + this.category.m_247710_() + "/")));
    }

    private void ensureValid(ResourceLocation id) {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + id);
        }
    }

    public record Result(ResourceLocation id, RecipeSerializer<?> type, Ingredient base, Ingredient addition, ItemStack result, Advancement.Builder advancement, ResourceLocation advancementId) implements FinishedRecipe
    {
        public void m_7917_(@NotNull JsonObject json) {
            json.add("base", this.base.m_43942_());
            json.add("addition", this.addition.m_43942_());
            ResourceLocation resultRegistryName = ForgeRegistries.ITEMS.getKey((Object)this.result.m_41720_());
            if (resultRegistryName != null) {
                JsonObject jsonobject = new JsonObject();
                jsonobject.addProperty("item", resultRegistryName.toString());
                if (this.result.m_41782_() && this.result.m_41783_() != null) {
                    jsonobject.addProperty("type", "forge:partial_nbt");
                    jsonobject.addProperty("nbt", this.result.m_41783_().toString());
                }
                json.add("result", (JsonElement)jsonobject);
            }
        }

        @NotNull
        public ResourceLocation m_6445_() {
            return this.id;
        }

        @NotNull
        public RecipeSerializer<?> m_6637_() {
            return this.type;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

