/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.network.packets;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonTemperatureBiomeOverride;
import sfiomn.legendarysurvivaloverhaul.common.listeners.TemperatureBiomeListener;
import sfiomn.legendarysurvivaloverhaul.network.NetworkHandler;

public class SyncTemperatureBiomesPacket {
    private final Map<ResourceLocation, JsonTemperatureBiomeOverride> temperatureBiomes;
    private final int size;

    public SyncTemperatureBiomesPacket(Map<ResourceLocation, JsonTemperatureBiomeOverride> temperatureBiomes) {
        this.temperatureBiomes = Map.copyOf(temperatureBiomes);
        this.size = temperatureBiomes.size();
    }

    public static void encode(SyncTemperatureBiomesPacket message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.size);
        for (Map.Entry<ResourceLocation, JsonTemperatureBiomeOverride> e : message.temperatureBiomes.entrySet()) {
            buffer.m_130085_(e.getKey());
            DataResult r = JsonTemperatureBiomeOverride.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)e.getValue());
            r.result().ifPresent(j -> buffer.m_130079_((CompoundTag)j));
        }
    }

    public static SyncTemperatureBiomesPacket decode(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        HashMap<ResourceLocation, JsonTemperatureBiomeOverride> temperatureBiomes = new HashMap<ResourceLocation, JsonTemperatureBiomeOverride>();
        for (int i = 0; i < size; ++i) {
            ResourceLocation key = buffer.m_130281_();
            CompoundTag tag = buffer.m_130260_();
            if (tag == null) continue;
            DataResult r = JsonTemperatureBiomeOverride.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)tag);
            r.result().ifPresent(t -> temperatureBiomes.put(key, (JsonTemperatureBiomeOverride)t));
        }
        return new SyncTemperatureBiomesPacket(temperatureBiomes);
    }

    public static void handle(SyncTemperatureBiomesPacket message, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> SyncTemperatureBiomesPacket.syncTemperatureBiomes(message.temperatureBiomes)));
        supplier.get().setPacketHandled(true);
    }

    public static DistExecutor.SafeRunnable syncTemperatureBiomes(final Map<ResourceLocation, JsonTemperatureBiomeOverride> temperatureBiomes) {
        return new DistExecutor.SafeRunnable(){
            private static final long serialVersionUID = 1L;

            public void run() {
                TemperatureBiomeListener.acceptServerTemperatureBiomes(temperatureBiomes);
            }
        };
    }

    public static void sendTo(PacketDistributor.PacketTarget packetDistributor, Map<ResourceLocation, JsonTemperatureBiomeOverride> temperatureBiomes) {
        NetworkHandler.INSTANCE.send(packetDistributor, (Object)new SyncTemperatureBiomesPacket(temperatureBiomes));
    }
}

