/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.network.packets;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonTemperatureBlock;
import sfiomn.legendarysurvivaloverhaul.common.listeners.TemperatureBlockListener;
import sfiomn.legendarysurvivaloverhaul.network.NetworkHandler;

public class SyncTemperatureBlocksPacket {
    private final Map<ResourceLocation, List<JsonTemperatureBlock>> temperatureBlocks;
    private final int size;

    public SyncTemperatureBlocksPacket(Map<ResourceLocation, List<JsonTemperatureBlock>> temperatureBlocks) {
        this.temperatureBlocks = Map.copyOf(temperatureBlocks);
        this.size = temperatureBlocks.size();
    }

    public static void encode(SyncTemperatureBlocksPacket message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.size);
        for (Map.Entry<ResourceLocation, List<JsonTemperatureBlock>> e : message.temperatureBlocks.entrySet()) {
            buffer.m_130085_(e.getKey());
            buffer.writeInt(e.getValue().size());
            DataResult r = JsonTemperatureBlock.LIST_CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, e.getValue());
            r.result().ifPresent(j -> ((ListTag)j).forEach(k -> buffer.m_130079_((CompoundTag)k)));
        }
    }

    public static SyncTemperatureBlocksPacket decode(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        HashMap<ResourceLocation, List<JsonTemperatureBlock>> temperatureBlocks = new HashMap<ResourceLocation, List<JsonTemperatureBlock>>();
        for (int i = 0; i < size; ++i) {
            ResourceLocation key = buffer.m_130281_();
            int jtbSize = buffer.readInt();
            ArrayList jtbList = new ArrayList();
            for (int j = 0; j < jtbSize; ++j) {
                CompoundTag tag = buffer.m_130260_();
                if (tag == null) continue;
                DataResult r = JsonTemperatureBlock.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)tag);
                r.result().ifPresent(jtbList::add);
            }
            temperatureBlocks.put(key, jtbList);
        }
        return new SyncTemperatureBlocksPacket(temperatureBlocks);
    }

    public static void handle(SyncTemperatureBlocksPacket message, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> SyncTemperatureBlocksPacket.syncTemperatureBlocks(message.temperatureBlocks)));
        supplier.get().setPacketHandled(true);
    }

    public static DistExecutor.SafeRunnable syncTemperatureBlocks(final Map<ResourceLocation, List<JsonTemperatureBlock>> temperatureBlocks) {
        return new DistExecutor.SafeRunnable(){
            private static final long serialVersionUID = 1L;

            public void run() {
                TemperatureBlockListener.acceptServerTemperatureBlocks(temperatureBlocks);
            }
        };
    }

    public static void sendTo(PacketDistributor.PacketTarget packetDistributor, Map<ResourceLocation, List<JsonTemperatureBlock>> temperatureBlocks) {
        NetworkHandler.INSTANCE.send(packetDistributor, (Object)new SyncTemperatureBlocksPacket(temperatureBlocks));
    }
}

