/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.network.packets;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonTemperatureFuelItem;
import sfiomn.legendarysurvivaloverhaul.common.listeners.TemperatureFuelItemListener;
import sfiomn.legendarysurvivaloverhaul.network.NetworkHandler;

public class SyncTemperatureFuelItemsPacket {
    private final Map<ResourceLocation, JsonTemperatureFuelItem> temperatureFuelItems;
    private final int size;

    public SyncTemperatureFuelItemsPacket(Map<ResourceLocation, JsonTemperatureFuelItem> temperatureFuelItems) {
        this.temperatureFuelItems = Map.copyOf(temperatureFuelItems);
        this.size = temperatureFuelItems.size();
    }

    public static void encode(SyncTemperatureFuelItemsPacket message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.size);
        for (Map.Entry<ResourceLocation, JsonTemperatureFuelItem> e : message.temperatureFuelItems.entrySet()) {
            buffer.m_130085_(e.getKey());
            DataResult r = JsonTemperatureFuelItem.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)e.getValue());
            r.result().ifPresent(j -> buffer.m_130079_((CompoundTag)j));
        }
    }

    public static SyncTemperatureFuelItemsPacket decode(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        HashMap<ResourceLocation, JsonTemperatureFuelItem> temperatureFuelItems = new HashMap<ResourceLocation, JsonTemperatureFuelItem>();
        for (int i = 0; i < size; ++i) {
            ResourceLocation key = buffer.m_130281_();
            CompoundTag tag = buffer.m_130260_();
            if (tag == null) continue;
            DataResult r = JsonTemperatureFuelItem.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)tag);
            r.result().ifPresent(t -> temperatureFuelItems.put(key, (JsonTemperatureFuelItem)t));
        }
        return new SyncTemperatureFuelItemsPacket(temperatureFuelItems);
    }

    public static void handle(SyncTemperatureFuelItemsPacket message, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> SyncTemperatureFuelItemsPacket.syncTemperatureFuelItems(message.temperatureFuelItems)));
        supplier.get().setPacketHandled(true);
    }

    public static DistExecutor.SafeRunnable syncTemperatureFuelItems(final Map<ResourceLocation, JsonTemperatureFuelItem> temperatureFuelItems) {
        return new DistExecutor.SafeRunnable(){
            private static final long serialVersionUID = 1L;

            public void run() {
                TemperatureFuelItemListener.acceptServerTemperatureFuelItems(temperatureFuelItems);
            }
        };
    }

    public static void sendTo(PacketDistributor.PacketTarget packetDistributor, Map<ResourceLocation, JsonTemperatureFuelItem> temperatureFuelItems) {
        NetworkHandler.INSTANCE.send(packetDistributor, (Object)new SyncTemperatureFuelItemsPacket(temperatureFuelItems));
    }
}

