/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gaia.config.GaiaConfig;
import gaia.entity.Anubis;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;

public class AnubisModel
extends EntityModel<Anubis>
implements HeadedModel,
ArmedModel {
    private final ModelPart root;
    private final ModelPart bodytop;
    private final ModelPart head;
    private final ModelPart headeyes;
    private final ModelPart hair1;
    private final ModelPart hair2;
    private final ModelPart chest;
    private final ModelPart tail;
    private final ModelPart leftarm;
    private final ModelPart rightarm;
    private final ModelPart leftleg;
    private final ModelPart rightleg;

    public AnubisModel(ModelPart root) {
        this.root = root.getChild("anubis");
        ModelPart bodybottom = this.root.getChild("bodybottom");
        this.bodytop = bodybottom.getChild("bodymiddle").getChild("bodytop");
        ModelPart neck = this.bodytop.getChild("neck");
        this.head = neck.getChild("head");
        this.headeyes = this.head.getChild("headeyes");
        this.hair1 = neck.getChild("hair1");
        this.hair2 = this.hair1.getChild("hair2");
        this.chest = this.bodytop.getChild("bodytop_female").getChild("chest");
        this.leftarm = this.bodytop.getChild("leftarm");
        this.rightarm = this.bodytop.getChild("rightarm");
        this.tail = bodybottom.getChild("tail");
        this.leftleg = this.root.getChild("leftleg");
        this.rightleg = this.root.getChild("rightleg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition anubis = partdefinition.addOrReplaceChild("anubis", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition bodybottom = anubis.addOrReplaceChild("bodybottom", CubeListBuilder.create().texOffs(0, 30).addBox(-3.0f, -1.5f, -1.0f, 6.0f, 3.0f, 3.0f).texOffs(76, 12).addBox(-3.5f, -2.0f, -1.5f, 7.0f, 4.0f, 4.0f), PartPose.offsetAndRotation((float)0.0f, (float)-13.5f, (float)-1.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition bodymiddle = bodybottom.addOrReplaceChild("bodymiddle", CubeListBuilder.create().texOffs(0, 25).addBox(-0.5f, -2.0f, -1.6f, 1.0f, 2.0f, 0.0f), PartPose.offsetAndRotation((float)0.0f, (float)-1.5f, (float)1.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition bodymiddle_female = bodymiddle.addOrReplaceChild("bodymiddle_female", CubeListBuilder.create().texOffs(0, 25).addBox(-2.0f, 5.5f, -1.5f, 4.0f, 3.0f, 2.0f), PartPose.offset((float)0.0f, (float)-8.0f, (float)0.0f));
        PartDefinition bodymiddle_male = bodymiddle.addOrReplaceChild("bodymiddle_male", CubeListBuilder.create().texOffs(0, 59).addBox(-2.5f, 5.5f, -1.5f, 5.0f, 3.0f, 2.0f), PartPose.offset((float)0.0f, (float)-8.0f, (float)0.0f));
        PartDefinition bodytop = bodymiddle.addOrReplaceChild("bodytop", CubeListBuilder.create().texOffs(36, 50).addBox(-5.0f, -6.0f, -3.0f, 10.0f, 2.0f, 4.0f), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)0.5f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition neck = bodytop.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(0, 12).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)-6.0f, (float)-1.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -6.0f, -3.0f, 6.0f, 6.0f, 6.0f).texOffs(36, 0).addBox(-3.5f, -6.5f, -3.5f, 7.0f, 9.0f, 7.0f).texOffs(36, 39).addBox(-1.0f, -8.0f, -4.6f, 2.0f, 3.0f, 1.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition headeyes = head.addOrReplaceChild("headeyes", CubeListBuilder.create().texOffs(24, 0).addBox(-3.0f, -6.0f, -3.1f, 6.0f, 6.0f, 0.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightear = head.addOrReplaceChild("rightear", CubeListBuilder.create().texOffs(36, 43).addBox(-4.5f, -10.0f, -1.5f, 3.0f, 4.0f, 3.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftear = head.addOrReplaceChild("leftear", CubeListBuilder.create().texOffs(36, 43).mirror().addBox(1.5f, -10.0f, -1.5f, 3.0f, 4.0f, 3.0f).mirror(false), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition hair1 = neck.addOrReplaceChild("hair1", CubeListBuilder.create().texOffs(36, 16).addBox(-4.0f, -6.0f, 1.0f, 8.0f, 8.0f, 3.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition hair2 = hair1.addOrReplaceChild("hair2", CubeListBuilder.create().texOffs(36, 27).addBox(-4.5f, -1.0f, 1.5f, 9.0f, 9.0f, 3.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition bodytop_female = bodytop.addOrReplaceChild("bodytop_female", CubeListBuilder.create().texOffs(0, 16).addBox(-2.5f, 0.0f, -1.5f, 5.0f, 6.0f, 3.0f), PartPose.offset((float)0.0f, (float)-6.0f, (float)-1.0f));
        PartDefinition chest = bodytop_female.addOrReplaceChild("chest", CubeListBuilder.create().texOffs(0, 36).addBox(-2.3f, 0.0f, -2.0f, 2.0f, 2.0f, 2.0f).texOffs(0, 36).mirror().addBox(0.3f, 0.0f, -2.0f, 2.0f, 2.0f, 2.0f).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)0.5f, (float)-1.5f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition bodytop_male = bodytop.addOrReplaceChild("bodytop_male", CubeListBuilder.create().texOffs(0, 50).addBox(-3.0f, 0.0f, -1.5f, 6.0f, 6.0f, 3.0f), PartPose.offset((float)0.0f, (float)-6.0f, (float)-1.0f));
        PartDefinition rightarm = bodytop.addOrReplaceChild("rightarm", CubeListBuilder.create().texOffs(16, 12).addBox(-2.0f, -1.0f, -1.0f, 2.0f, 8.0f, 2.0f), PartPose.offsetAndRotation((float)-2.5f, (float)-4.5f, (float)-1.0f, (float)0.0873f, (float)0.0f, (float)0.1745f));
        PartDefinition rightarmlower = rightarm.addOrReplaceChild("rightarmlower", CubeListBuilder.create().texOffs(64, 0).addBox(-1.5f, -3.0f, -2.5f, 2.0f, 8.0f, 3.0f), PartPose.offset((float)-1.0f, (float)5.0f, (float)1.0f));
        PartDefinition rightarmhand = rightarmlower.addOrReplaceChild("rightarmhand", CubeListBuilder.create().texOffs(64, 11).addBox(0.0f, -1.5f, -2.0f, 2.0f, 4.0f, 4.0f), PartPose.offset((float)-0.5f, (float)4.0f, (float)-1.0f));
        PartDefinition leftarm = bodytop.addOrReplaceChild("leftarm", CubeListBuilder.create().texOffs(16, 12).addBox(0.0f, -1.0f, -1.0f, 2.0f, 8.0f, 2.0f), PartPose.offsetAndRotation((float)2.5f, (float)-4.5f, (float)-1.0f, (float)0.0873f, (float)0.0f, (float)-0.1745f));
        PartDefinition leftarmlower = leftarm.addOrReplaceChild("leftarmlower", CubeListBuilder.create().texOffs(64, 0).addBox(-0.5f, -3.0f, -2.5f, 2.0f, 8.0f, 3.0f), PartPose.offset((float)1.0f, (float)5.0f, (float)1.0f));
        PartDefinition leftarmhand = leftarmlower.addOrReplaceChild("leftarmhand", CubeListBuilder.create().texOffs(64, 11).mirror().addBox(-2.0f, -1.5f, -2.0f, 2.0f, 4.0f, 4.0f).mirror(false), PartPose.offset((float)0.5f, (float)4.0f, (float)-1.0f));
        PartDefinition tail = bodybottom.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(76, 0).addBox(-1.0f, -0.5f, -1.0f, 2.0f, 10.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)-1.5f, (float)2.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition rightleg = anubis.addOrReplaceChild("rightleg", CubeListBuilder.create().texOffs(24, 12).addBox(-1.5f, -1.0f, -1.5f, 3.0f, 7.0f, 3.0f), PartPose.offset((float)-2.0f, (float)-13.0f, (float)0.0f));
        PartDefinition rightleglower = rightleg.addOrReplaceChild("rightleglower", CubeListBuilder.create().texOffs(24, 22).addBox(-1.505f, 1.0f, 0.0f, 3.0f, 7.0f, 3.0f).texOffs(76, 20).addBox(-2.0f, 0.0f, -0.5f, 4.0f, 6.0f, 4.0f), PartPose.offset((float)0.0f, (float)5.0f, (float)-1.5f));
        PartDefinition rightfoot = rightleglower.addOrReplaceChild("rightfoot", CubeListBuilder.create().texOffs(76, 30).addBox(-2.0f, 11.0f, -3.5f, 4.0f, 2.0f, 4.0f), PartPose.offset((float)0.0f, (float)-5.0f, (float)1.5f));
        PartDefinition leftleg = anubis.addOrReplaceChild("leftleg", CubeListBuilder.create().texOffs(24, 12).mirror().addBox(-1.5f, -1.0f, -1.5f, 3.0f, 7.0f, 3.0f).mirror(false), PartPose.offset((float)2.0f, (float)-13.0f, (float)0.0f));
        PartDefinition leftleglower = leftleg.addOrReplaceChild("leftleglower", CubeListBuilder.create().texOffs(24, 22).mirror().addBox(-1.495f, 1.0f, 0.0f, 3.0f, 7.0f, 3.0f).mirror(false).texOffs(76, 20).mirror().addBox(-2.0f, 0.0f, -0.5f, 4.0f, 6.0f, 4.0f).mirror(false), PartPose.offset((float)0.0f, (float)5.0f, (float)-1.5f));
        PartDefinition leftfoot = leftleglower.addOrReplaceChild("leftfoot", CubeListBuilder.create().texOffs(76, 30).addBox(-2.0f, 11.0f, -3.5f, 4.0f, 2.0f, 4.0f), PartPose.offset((float)0.0f, (float)-5.0f, (float)1.5f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void prepareMobModel(Anubis anubis, float limbSwing, float limbSwingAmount, float partialTick) {
        super.prepareMobModel((Entity)anubis, limbSwing, limbSwingAmount, partialTick);
        this.chest.visible = (Boolean)GaiaConfig.CLIENT.genderNeutral.get() == false && !anubis.isBaby();
    }

    public void setupAnim(Anubis entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.headeyes.visible = ageInTicks % 60.0f == 0.0f && limbSwingAmount <= 0.1f;
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.hair1.yRot = this.head.yRot;
        this.hair1.xRot = this.head.xRot;
        this.hair2.xRot = this.head.xRot * 0.75f;
        if (entityIn.isMale()) {
            this.rightarm.x = -3.0f;
            this.leftarm.x = 3.0f;
        }
        if (entityIn.getAnimationState() == 0) {
            this.rightarm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.8f * limbSwingAmount * 0.5f;
            this.leftarm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.8f * limbSwingAmount * 0.5f;
            this.rightarm.zRot = 0.0f;
            this.leftarm.zRot = 0.0f;
            if (this.attackTime > 0.0f) {
                this.holdingMelee();
            }
            this.rightarm.zRot += Mth.cos((float)(ageInTicks * 0.09f)) * 0.025f + 0.025f + 0.1745329f;
            this.rightarm.xRot += Mth.sin((float)(ageInTicks * 0.067f)) * 0.025f;
            this.leftarm.zRot -= Mth.cos((float)(ageInTicks * 0.09f)) * 0.025f + 0.025f + 0.1745329f;
            this.leftarm.xRot -= Mth.sin((float)(ageInTicks * 0.067f)) * 0.025f;
        }
        if (entityIn.getAnimationState() == 1) {
            this.animationThrow();
        }
        if (entityIn.getAnimationState() == 2) {
            this.animationCast();
        }
        this.tail.yRot = Mth.cos((float)(ageInTicks * 7.0f * ((float)Math.PI / 180))) * 0.08726646f;
        this.rightleg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.5f * limbSwingAmount;
        this.leftleg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.5f * limbSwingAmount;
        this.rightleg.yRot = 0.0f;
        this.leftleg.yRot = 0.0f;
        this.rightleg.zRot = 0.0f;
        this.leftleg.zRot = 0.0f;
        if (this.riding) {
            this.rightarm.xRot -= 0.62831855f;
            this.leftarm.xRot -= 0.62831855f;
            this.rightleg.xRot = -1.4137167f;
            this.rightleg.yRot = 0.31415927f;
            this.rightleg.zRot = 0.07853982f;
            this.leftleg.xRot = -1.4137167f;
            this.leftleg.yRot = -0.31415927f;
            this.leftleg.zRot = -0.07853982f;
        }
    }

    public void holdingMelee() {
        float f6 = 1.0f - this.attackTime;
        f6 *= f6;
        f6 *= f6;
        f6 = 1.0f - f6;
        float f7 = Mth.sin((float)(f6 * (float)Math.PI));
        float f8 = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -(this.head.xRot - 0.7f) * 0.75f;
        this.rightarm.xRot = (float)((double)this.rightarm.xRot - ((double)f7 * 1.2 + (double)f8));
        this.rightarm.xRot += this.bodytop.yRot * 2.0f;
        this.rightarm.zRot = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -0.4f;
    }

    private void animationThrow() {
        this.rightarm.xRot = -1.0472f;
    }

    private void animationCast() {
        this.rightarm.xRot = -1.0472f;
        this.leftarm.xRot = -1.0472f;
        this.rightarm.zRot = -0.261799f;
        this.leftarm.zRot = 0.261799f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int unused) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay);
    }

    public ModelPart getHead() {
        return this.head;
    }

    private ModelPart getArm(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.leftarm : this.rightarm;
    }

    public void translateToHand(HumanoidArm arm, PoseStack poseStack) {
        poseStack.translate(-0.0625, 0.5, 0.0);
        this.getArm(arm).translateAndRotate(poseStack);
    }
}

