/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gaia.config.GaiaConfig;
import gaia.entity.Banshee;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;

public class BansheeModel
extends EntityModel<Banshee>
implements HeadedModel,
ArmedModel {
    private final ModelPart root;
    private final ModelPart bodytop;
    private final ModelPart head;
    private final ModelPart hair1;
    private final ModelPart hair2;
    private final ModelPart hair3;
    private final ModelPart hair4;
    private final ModelPart headeyes;
    private final ModelPart chest;
    private final ModelPart leftarm;
    private final ModelPart rightarm;
    private final ModelPart leftarmlower;
    private final ModelPart rightarmlower;
    private final ModelPart skirt1;
    private final ModelPart skirt2;
    private final ModelPart skirt3;
    private final ModelPart skirt4;

    public BansheeModel(ModelPart root) {
        this.root = root.getChild("banshee");
        ModelPart bodybottom = this.root.getChild("bodybottom");
        this.bodytop = bodybottom.getChild("bodymiddle").getChild("bodytop");
        ModelPart neck = this.bodytop.getChild("neck");
        this.head = neck.getChild("head");
        this.hair1 = this.head.getChild("hair1");
        this.hair2 = this.hair1.getChild("hair2");
        this.hair3 = this.hair2.getChild("hair3");
        this.hair4 = this.hair3.getChild("hair4");
        this.headeyes = this.head.getChild("headeyes");
        this.chest = this.bodytop.getChild("chest");
        this.leftarm = this.bodytop.getChild("leftarm");
        this.rightarm = this.bodytop.getChild("rightarm");
        this.skirt1 = bodybottom.getChild("skirt1");
        this.skirt2 = this.skirt1.getChild("skirt2");
        this.skirt3 = this.skirt2.getChild("skirt3");
        this.skirt4 = this.skirt3.getChild("skirt4");
        this.leftarmlower = this.leftarm.getChild("leftarmlower");
        this.rightarmlower = this.rightarm.getChild("rightarmlower");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition banshee = partdefinition.addOrReplaceChild("banshee", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition bodybottom = banshee.addOrReplaceChild("bodybottom", CubeListBuilder.create().texOffs(0, 30).addBox(-3.0f, -1.5f, -1.5f, 6.0f, 3.0f, 3.0f), PartPose.offset((float)0.0f, (float)-13.5f, (float)0.0f));
        PartDefinition bodymiddle = bodybottom.addOrReplaceChild("bodymiddle", CubeListBuilder.create().texOffs(0, 25).addBox(-2.0f, -2.5f, -2.0f, 4.0f, 3.0f, 2.0f).texOffs(0, 25).addBox(-0.5f, -2.0f, -2.1f, 1.0f, 2.0f, 0.0f), PartPose.offset((float)0.0f, (float)-1.5f, (float)1.0f));
        PartDefinition bodytop = bodymiddle.addOrReplaceChild("bodytop", CubeListBuilder.create().texOffs(0, 16).addBox(-2.5f, -6.0f, -2.5f, 5.0f, 6.0f, 3.0f), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition neck = bodytop.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(0, 12).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.offset((float)0.0f, (float)-6.0f, (float)-1.0f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -6.0f, -3.0f, 6.0f, 6.0f, 6.0f).texOffs(36, 0).addBox(-3.5f, -6.5f, -3.5f, 7.0f, 7.0f, 7.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition headeyes = head.addOrReplaceChild("headeyes", CubeListBuilder.create().texOffs(24, 0).addBox(-2.9f, -6.0f, -2.905f, 6.0f, 6.0f, 0.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)-0.1f));
        PartDefinition hair1 = head.addOrReplaceChild("hair1", CubeListBuilder.create().texOffs(36, 14).addBox(-4.0f, -3.5f, 0.0f, 8.0f, 7.0f, 2.0f), PartPose.offset((float)0.0f, (float)-3.0f, (float)2.0f));
        PartDefinition hair2 = hair1.addOrReplaceChild("hair2", CubeListBuilder.create().texOffs(36, 23).addBox(-5.0f, -5.0f, -0.4f, 10.0f, 10.0f, 4.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)2.0f));
        PartDefinition hair3 = hair2.addOrReplaceChild("hair3", CubeListBuilder.create().texOffs(36, 37).addBox(-6.0f, -6.0f, -1.0f, 12.0f, 12.0f, 6.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)4.0f));
        PartDefinition hair4 = hair3.addOrReplaceChild("hair4", CubeListBuilder.create().texOffs(6, 41).addBox(-4.0f, -4.0f, -0.5f, 8.0f, 8.0f, 14.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition chest = bodytop.addOrReplaceChild("chest", CubeListBuilder.create().texOffs(0, 36).addBox(-2.3f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f).texOffs(0, 36).mirror().addBox(0.3f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-4.25f, (float)-2.5f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition rightarm = bodytop.addOrReplaceChild("rightarm", CubeListBuilder.create().texOffs(16, 12).addBox(-2.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f).texOffs(72, 0).addBox(-2.5f, 1.0f, -1.5f, 3.0f, 4.0f, 3.0f), PartPose.offset((float)-2.5f, (float)-4.5f, (float)-1.0f));
        PartDefinition rightarmlower = rightarm.addOrReplaceChild("rightarmlower", CubeListBuilder.create().texOffs(16, 20).addBox(-1.005f, 0.0f, -2.5f, 2.0f, 6.0f, 2.0f).texOffs(72, 7).addBox(-1.505f, 0.0f, -3.0f, 3.0f, 6.0f, 3.0f), PartPose.offset((float)-1.0f, (float)5.0f, (float)1.5f));
        PartDefinition leftarm = bodytop.addOrReplaceChild("leftarm", CubeListBuilder.create().texOffs(16, 12).mirror().addBox(0.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f).mirror(false).texOffs(72, 0).mirror().addBox(-0.5f, 1.0f, -1.5f, 3.0f, 4.0f, 3.0f).mirror(false), PartPose.offset((float)2.5f, (float)-4.5f, (float)-1.0f));
        PartDefinition leftarmlower = leftarm.addOrReplaceChild("leftarmlower", CubeListBuilder.create().texOffs(16, 20).mirror().addBox(-0.995f, 0.0f, -2.5f, 2.0f, 6.0f, 2.0f).mirror(false).texOffs(72, 7).mirror().addBox(-1.495f, 0.0f, -3.0f, 3.0f, 6.0f, 3.0f).mirror(false), PartPose.offset((float)1.0f, (float)5.0f, (float)1.5f));
        PartDefinition skirt1 = bodybottom.addOrReplaceChild("skirt1", CubeListBuilder.create().texOffs(84, 0).addBox(-3.5f, 0.0f, -3.0f, 7.0f, 2.0f, 6.0f), PartPose.offset((float)0.0f, (float)-0.5f, (float)0.0f));
        PartDefinition skirt2 = skirt1.addOrReplaceChild("skirt2", CubeListBuilder.create().texOffs(84, 8).addBox(-4.0f, 0.0f, -0.5f, 8.0f, 4.0f, 7.0f), PartPose.offset((float)0.0f, (float)2.0f, (float)-3.0f));
        PartDefinition skirt3 = skirt2.addOrReplaceChild("skirt3", CubeListBuilder.create().texOffs(84, 19).addBox(-4.5f, 0.0f, -0.5f, 9.0f, 5.0f, 8.0f), PartPose.offset((float)0.0f, (float)4.0f, (float)-0.5f));
        PartDefinition skirt4 = skirt3.addOrReplaceChild("skirt4", CubeListBuilder.create().texOffs(84, 32).addBox(-5.0f, 0.0f, -0.5f, 10.0f, 6.0f, 9.0f), PartPose.offset((float)0.0f, (float)5.0f, (float)-0.5f));
        PartDefinition rightleg = banshee.addOrReplaceChild("rightleg", CubeListBuilder.create().texOffs(24, 12).addBox(-1.5f, -1.0f, -1.5f, 3.0f, 14.0f, 3.0f), PartPose.offset((float)-2.0f, (float)-13.0f, (float)0.0f));
        PartDefinition leftleg = banshee.addOrReplaceChild("leftleg", CubeListBuilder.create().texOffs(24, 12).mirror().addBox(-1.5f, -1.0f, -1.5f, 3.0f, 14.0f, 3.0f).mirror(false), PartPose.offset((float)2.0f, (float)-13.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void prepareMobModel(Banshee banshee, float limbSwing, float limbSwingAmount, float partialTick) {
        super.prepareMobModel((Entity)banshee, limbSwing, limbSwingAmount, partialTick);
        this.chest.visible = (Boolean)GaiaConfig.CLIENT.genderNeutral.get() == false && !banshee.isBaby();
    }

    public void setupAnim(Banshee banshee, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.headeyes.visible = ageInTicks % 60.0f == 0.0f && limbSwingAmount <= 0.1f;
        this.root.y = 24.0f - Mth.cos((float)(ageInTicks * 0.18f)) * 0.9f;
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.hair1.zRot = 0.2617994f;
        this.hair2.zRot = 0.2617994f;
        this.hair3.zRot = 0.2617994f;
        this.hair4.zRot += 0.0034906585f;
        this.rightarm.zRot = 0.0f;
        this.rightarm.xRot = 0.0f;
        this.leftarm.zRot = 0.0f;
        this.leftarm.xRot = 0.0f;
        if (this.attackTime > 0.0f) {
            this.holdingMelee();
        }
        this.rightarm.zRot = Mth.cos((float)(ageInTicks * 7.0f * ((float)Math.PI / 180))) * 0.17453292f;
        this.leftarm.zRot = Mth.cos((float)(ageInTicks * 7.0f * ((float)Math.PI / 180))) * -0.17453292f;
        this.rightarm.zRot += 0.2617994f;
        this.leftarm.zRot -= 0.2617994f;
        this.rightarm.xRot += Mth.sin((float)(ageInTicks * 0.067f)) * 0.05f;
        this.leftarm.xRot -= Mth.sin((float)(ageInTicks * 0.067f)) * 0.05f;
        this.rightarmlower.xRot = -0.2617994f;
        this.leftarmlower.xRot = -0.2617994f;
        this.skirt1.xRot = 0.08726646f;
        this.skirt2.xRot = 0.17453292f;
        this.skirt3.xRot = 0.2617994f;
        this.skirt4.xRot = 0.34906584f;
        this.skirt1.zRot = Mth.cos((float)(ageInTicks * 7.0f * ((float)Math.PI / 180))) * ((float)Math.PI / 180);
        this.skirt2.zRot = Mth.cos((float)(ageInTicks * 7.0f * ((float)Math.PI / 180))) * ((float)Math.PI / 90);
        this.skirt3.zRot = Mth.cos((float)(ageInTicks * 7.0f * ((float)Math.PI / 180))) * 0.05235988f;
        this.skirt4.zRot = Mth.cos((float)(ageInTicks * 7.0f * ((float)Math.PI / 180))) * 0.06981317f;
    }

    public void holdingMelee() {
        float f6 = 1.0f - this.attackTime;
        f6 *= f6;
        f6 *= f6;
        f6 = 1.0f - f6;
        float f7 = Mth.sin((float)(f6 * (float)Math.PI));
        float f8 = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -(this.head.xRot - 0.7f) * 0.75f;
        this.rightarm.xRot -= (float)((double)this.rightarm.xRot - ((double)f7 * 1.2 + (double)f8));
        this.rightarm.yRot += this.bodytop.yRot * 2.0f;
        this.rightarm.zRot = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -0.4f;
        this.leftarm.xRot -= (float)((double)this.leftarm.xRot - ((double)f7 * 1.2 + (double)f8));
        this.leftarm.yRot += this.bodytop.yRot * 2.0f;
        this.leftarm.zRot -= Mth.sin((float)(this.attackTime * (float)Math.PI)) * -0.4f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int unused) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay);
    }

    public ModelPart getHead() {
        return this.head;
    }

    private ModelPart getArm(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.leftarm : this.rightarm;
    }

    public void translateToHand(HumanoidArm arm, PoseStack poseStack) {
        poseStack.translate(0.0, 0.5, 0.0);
        this.getArm(arm).translateAndRotate(poseStack);
    }
}

