/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gaia.entity.BoneKnight;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.neoforged.neoforge.common.ItemAbilities;

public class BoneKnightModel
extends EntityModel<BoneKnight>
implements HeadedModel,
ArmedModel {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart rightarm;
    private final ModelPart shield;
    private final ModelPart leftarm;
    private final ModelPart rightleg;
    private final ModelPart leftleg;
    public boolean shielded;

    public BoneKnightModel(ModelPart root) {
        this.root = root.getChild("bone_knight");
        this.head = this.root.getChild("head");
        this.body = this.root.getChild("body");
        this.rightarm = this.root.getChild("rightarm");
        this.shield = this.rightarm.getChild("shield");
        this.leftarm = this.root.getChild("leftarm");
        this.rightleg = this.root.getChild("rightleg");
        this.leftleg = this.root.getChild("leftleg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition bone_knight = partdefinition.addOrReplaceChild("bone_knight", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition head = bone_knight.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.offset((float)0.0f, (float)-24.0f, (float)0.0f));
        PartDefinition body = bone_knight.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f), PartPose.offset((float)0.0f, (float)-24.0f, (float)0.0f));
        PartDefinition chest = body.addOrReplaceChild("chest", CubeListBuilder.create().texOffs(40, 12).addBox(-4.0f, 0.0f, 0.0f, 8.0f, 4.0f, 4.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-2.0f, (float)-0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition chestlower_r1 = chest.addOrReplaceChild("chestlower_r1", CubeListBuilder.create().texOffs(40, 20).addBox(-3.0f, 0.0f, 0.0f, 6.0f, 4.0f, 4.0f), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)0.0f, (float)0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition waist = body.addOrReplaceChild("waist", CubeListBuilder.create().texOffs(0, 32).addBox(-4.5f, 10.0f, -2.5f, 9.0f, 8.0f, 5.0f).texOffs(0, 45).addBox(-5.0f, 12.0f, -2.0f, 10.0f, 6.0f, 5.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightarm = bone_knight.addOrReplaceChild("rightarm", CubeListBuilder.create().texOffs(24, 16).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f).texOffs(40, 28).addBox(-1.5f, 4.5f, -1.5f, 3.0f, 6.0f, 3.0f).texOffs(40, 0).addBox(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(-1.0f)), PartPose.offset((float)-5.0f, (float)-22.0f, (float)0.0f));
        PartDefinition shield = rightarm.addOrReplaceChild("shield", CubeListBuilder.create().texOffs(88, 0).mirror().addBox(-3.0f, -1.5f, -6.0f, 1.0f, 22.0f, 12.0f).mirror(false).texOffs(88, 0).mirror().addBox(-2.5f, 8.5f, -1.5f, 3.0f, 1.0f, 3.0f).mirror(false), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftarm = bone_knight.addOrReplaceChild("leftarm", CubeListBuilder.create().texOffs(24, 16).mirror().addBox(-1.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f).mirror(false).texOffs(40, 28).mirror().addBox(-1.5f, 4.5f, -1.5f, 3.0f, 6.0f, 3.0f).mirror(false).texOffs(40, 0).mirror().addBox(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(-1.0f)).mirror(false), PartPose.offset((float)5.0f, (float)-22.0f, (float)0.0f));
        PartDefinition rightleg = bone_knight.addOrReplaceChild("rightleg", CubeListBuilder.create().texOffs(32, 16).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 12.0f, 2.0f).texOffs(40, 37).addBox(-1.5f, 6.0f, -1.5f, 3.0f, 6.0f, 3.0f), PartPose.offset((float)-2.0f, (float)-12.0f, (float)0.0f));
        PartDefinition leftleg = bone_knight.addOrReplaceChild("leftleg", CubeListBuilder.create().texOffs(32, 16).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 12.0f, 2.0f).texOffs(40, 37).mirror().addBox(-1.5f, 6.0f, -1.5f, 3.0f, 6.0f, 3.0f).mirror(false), PartPose.offset((float)2.0f, (float)-12.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void prepareMobModel(BoneKnight boneKnight, float limbSwing, float limbSwingAmount, float partialTick) {
        super.prepareMobModel((Entity)boneKnight, limbSwing, limbSwingAmount, partialTick);
        this.shielded = boneKnight.getMainHandItem().canPerformAction(ItemAbilities.SHIELD_BLOCK);
    }

    public void setupAnim(BoneKnight boneKnight, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.shield.visible = false;
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.leftarm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.8f * limbSwingAmount * 0.5f;
        this.rightarm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.8f * limbSwingAmount * 0.5f;
        this.leftarm.zRot = 0.0f;
        this.rightarm.zRot = 0.0f;
        if (this.attackTime > 0.0f) {
            this.holdingMelee();
        }
        if (this.shielded) {
            this.rightarm.xRot = this.rightarm.xRot * 0.5f - 0.9424779f;
            this.rightarm.yRot = -0.5235988f;
        } else {
            this.rightarm.yRot = 0.0f;
        }
        this.leftarm.zRot += Mth.cos((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f + 0.0872665f;
        this.leftarm.xRot += Mth.sin((float)(ageInTicks * 0.067f)) * 0.05f;
        this.rightarm.zRot -= Mth.cos((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f + 0.0872665f;
        this.rightarm.xRot -= Mth.sin((float)(ageInTicks * 0.067f)) * 0.05f;
        this.rightleg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.5f * limbSwingAmount;
        this.leftleg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.5f * limbSwingAmount;
        this.rightleg.yRot = 0.0f;
        this.leftleg.yRot = 0.0f;
        this.rightleg.zRot = 0.0f;
        this.leftleg.zRot = 0.0f;
        if (this.riding) {
            this.leftarm.xRot -= 0.62831855f;
            this.rightarm.xRot -= 0.62831855f;
            this.rightleg.xRot = -1.4137167f;
            this.rightleg.yRot = 0.31415927f;
            this.rightleg.zRot = 0.07853982f;
            this.leftleg.xRot = -1.4137167f;
            this.leftleg.yRot = -0.31415927f;
            this.leftleg.zRot = -0.07853982f;
        }
    }

    public void holdingMelee() {
        float f6 = 1.0f - this.attackTime;
        f6 *= f6;
        f6 *= f6;
        f6 = 1.0f - f6;
        float f7 = Mth.sin((float)(f6 * (float)Math.PI));
        float f8 = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -(this.head.xRot - 0.7f) * 0.75f;
        this.leftarm.xRot = (float)((double)this.leftarm.xRot - ((double)f7 * 1.2 + (double)f8));
        this.leftarm.xRot += this.body.yRot * 2.0f;
        this.leftarm.zRot = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -0.4f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int unused) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay);
    }

    public ModelPart getHead() {
        return this.head;
    }

    private ModelPart getArm(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.leftarm : this.rightarm;
    }

    public void translateToHand(HumanoidArm arm, PoseStack poseStack) {
        poseStack.translate(0.0, 1.5, 0.0);
        this.getArm(arm).translateAndRotate(poseStack);
    }
}

