/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gaia.entity.Creep;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class CreepModel
extends EntityModel<Creep> {
    private final ModelPart root;
    private final ModelPart body1;
    private final ModelPart head1;
    private final ModelPart head2;
    private final ModelPart head3;
    private final ModelPart smallhead1;
    private final ModelPart smallhead2;
    private final ModelPart smallhead3;
    private final ModelPart leg1;
    private final ModelPart leg2;
    private final ModelPart leg3;
    private final ModelPart leg4;
    private final ModelPart leg5;
    private final ModelPart leg6;

    public CreepModel(ModelPart root) {
        this.root = root.getChild("creep");
        this.body1 = this.root.getChild("body1");
        ModelPart body2 = this.body1.getChild("body2");
        this.head1 = body2.getChild("head1");
        this.head2 = body2.getChild("head2");
        this.head3 = body2.getChild("head3");
        this.smallhead1 = body2.getChild("smallhead1");
        this.smallhead2 = body2.getChild("smallhead2");
        this.smallhead3 = body2.getChild("smallhead3");
        this.leg1 = this.root.getChild("leg1");
        this.leg2 = this.root.getChild("leg2");
        this.leg3 = this.root.getChild("leg3");
        this.leg4 = this.root.getChild("leg4");
        this.leg5 = this.root.getChild("leg5");
        this.leg6 = this.root.getChild("leg6");
    }

    public static LayerDefinition createBodyLayer(CubeDeformation deformation) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition creep = partdefinition.addOrReplaceChild("creep", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body1 = creep.addOrReplaceChild("body1", CubeListBuilder.create().texOffs(32, 0).addBox(-3.0f, -6.0f, -3.0f, 6.0f, 6.0f, 6.0f, deformation), PartPose.offset((float)0.0f, (float)-6.0f, (float)0.0f));
        PartDefinition body2 = body1.addOrReplaceChild("body2", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-6.0f, (float)0.0f));
        PartDefinition body2_r1 = body2.addOrReplaceChild("body2_r1", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, deformation), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)0.0f, (float)1.5708f, (float)-0.3491f, (float)0.0f));
        PartDefinition head1 = body2.addOrReplaceChild("head1", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -10.0f, 8.0f, 8.0f, 8.0f, deformation), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)0.0f, (float)-0.6109f, (float)-0.7854f, (float)-0.0873f));
        PartDefinition head2 = body2.addOrReplaceChild("head2", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -10.0f, 8.0f, 8.0f, 8.0f, deformation), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)0.0f, (float)-0.2618f, (float)0.7854f, (float)0.0873f));
        PartDefinition head3 = body2.addOrReplaceChild("head3", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -10.0f, 8.0f, 8.0f, 8.0f, deformation), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)0.0f, (float)-0.4363f, (float)3.1416f, (float)0.0f));
        PartDefinition smallhead1 = body2.addOrReplaceChild("smallhead1", CubeListBuilder.create().texOffs(0, 16).addBox(-3.0f, -3.0f, -9.0f, 6.0f, 6.0f, 6.0f, deformation), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)0.0f, (float)-0.2618f, (float)-2.0944f, (float)0.0873f));
        PartDefinition smallhead2 = body2.addOrReplaceChild("smallhead2", CubeListBuilder.create().texOffs(0, 16).addBox(-3.0f, -3.0f, -9.0f, 6.0f, 6.0f, 6.0f, deformation), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)0.0f, (float)-0.1745f, (float)2.0944f, (float)-0.0873f));
        PartDefinition smallhead3 = body2.addOrReplaceChild("smallhead3", CubeListBuilder.create().texOffs(0, 16).addBox(-3.0f, -3.0f, -9.0f, 6.0f, 6.0f, 6.0f, deformation), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)0.0f, (float)0.0873f, (float)0.0f, (float)0.0873f));
        PartDefinition leg1 = creep.addOrReplaceChild("leg1", CubeListBuilder.create().texOffs(32, 12).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, deformation), PartPose.offsetAndRotation((float)2.5f, (float)-6.0f, (float)-4.0f, (float)0.0f, (float)-0.2618f, (float)0.0f));
        PartDefinition leg2 = creep.addOrReplaceChild("leg2", CubeListBuilder.create().texOffs(32, 12).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, deformation), PartPose.offsetAndRotation((float)-2.5f, (float)-6.0f, (float)-4.0f, (float)0.0f, (float)0.2618f, (float)0.0f));
        PartDefinition leg3 = creep.addOrReplaceChild("leg3", CubeListBuilder.create().texOffs(32, 12).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, deformation), PartPose.offsetAndRotation((float)-5.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition leg4 = creep.addOrReplaceChild("leg4", CubeListBuilder.create().texOffs(48, 12).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, deformation), PartPose.offsetAndRotation((float)-2.5f, (float)-6.0f, (float)4.0f, (float)0.0f, (float)-0.2618f, (float)0.0f));
        PartDefinition leg5 = creep.addOrReplaceChild("leg5", CubeListBuilder.create().texOffs(48, 12).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, deformation), PartPose.offsetAndRotation((float)2.5f, (float)-6.0f, (float)4.0f, (float)0.0f, (float)0.2618f, (float)0.0f));
        PartDefinition leg6 = creep.addOrReplaceChild("leg6", CubeListBuilder.create().texOffs(32, 12).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, deformation), PartPose.offsetAndRotation((float)5.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(Creep entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head1.xRot = Mth.cos((float)(ageInTicks * 0.8f + (float)Math.PI)) * 0.4f * limbSwingAmount * 0.5f;
        this.head2.xRot = this.head1.xRot - 0.2617994f;
        this.head3.xRot = this.head1.xRot - 0.4363323f;
        this.head1.xRot -= 0.6108652f;
        this.smallhead1.xRot = Mth.cos((float)(ageInTicks * 1.2f + (float)Math.PI)) * 0.6f * limbSwingAmount * 0.5f;
        this.smallhead2.xRot = this.smallhead1.xRot - 0.1745329f;
        this.smallhead3.xRot = this.smallhead1.xRot + 0.0872665f;
        this.smallhead1.xRot -= 0.2617994f;
        this.body1.yRot = netHeadYaw / 57.295776f;
        this.body1.xRot = headPitch / 57.295776f;
        this.leg1.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leg2.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.leg3.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leg4.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.leg5.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leg6.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int unused) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay);
    }
}

