/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gaia.entity.Deathword;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class DeathwordModel
extends EntityModel<Deathword> {
    private final ModelPart root;
    private final ModelPart rightcover;
    private final ModelPart leftcover;
    private final ModelPart rightpage;
    private final ModelPart leftpage;
    private final ModelPart rightpagemiddle;
    private final ModelPart leftpagemiddle;

    public DeathwordModel(ModelPart root) {
        this.root = root.getChild("deathword");
        ModelPart binder = this.root.getChild("binder");
        this.rightcover = binder.getChild("rightcover");
        this.leftcover = binder.getChild("leftcover");
        ModelPart binderinside = binder.getChild("binderinside");
        this.rightpage = binderinside.getChild("rightpage");
        this.rightpagemiddle = this.rightpage.getChild("rightpagemiddle");
        this.leftpage = binderinside.getChild("leftpage");
        this.leftpagemiddle = this.leftpage.getChild("leftpagemiddle");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition deathword = partdefinition.addOrReplaceChild("deathword", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition binder = deathword.addOrReplaceChild("binder", CubeListBuilder.create().texOffs(34, 0).addBox(-1.0f, -5.0f, 0.0f, 2.0f, 10.0f, 0.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightcover = binder.addOrReplaceChild("rightcover", CubeListBuilder.create().texOffs(0, 10).addBox(-6.0f, -5.0f, 0.0f, 6.0f, 10.0f, 0.0f), PartPose.offsetAndRotation((float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition leftcover = binder.addOrReplaceChild("leftcover", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, -5.0f, 0.0f, 6.0f, 10.0f, 0.0f), PartPose.offsetAndRotation((float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition binderinside = binder.addOrReplaceChild("binderinside", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightpage = binderinside.addOrReplaceChild("rightpage", CubeListBuilder.create().texOffs(12, 9).addBox(-5.0f, -4.0f, 0.0f, 5.0f, 8.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-1.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition rightpagemiddle = rightpage.addOrReplaceChild("rightpagemiddle", CubeListBuilder.create().texOffs(24, 8).addBox(0.0f, -4.0f, 0.0f, 5.0f, 8.0f, 0.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.7453f, (float)0.0f));
        PartDefinition leftpage = binderinside.addOrReplaceChild("leftpage", CubeListBuilder.create().texOffs(12, 0).addBox(0.0f, -4.0f, 0.0f, 5.0f, 8.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-1.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition leftpagemiddle = leftpage.addOrReplaceChild("leftpagemiddle", CubeListBuilder.create().texOffs(24, 0).addBox(0.0f, -4.0f, 0.0f, 5.0f, 8.0f, 0.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.3963f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(Deathword entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float floatSpeed = 0.2f;
        float floatRange = 3.0f;
        this.root.y = 18.0f - Mth.cos((float)((ageInTicks + 1.5f) * floatSpeed)) * floatRange;
        this.root.x = 0.06981317f;
        float swingSpeed = 0.4f;
        float angleRange = 0.8f;
        this.rightcover.yRot = Mth.cos((float)(ageInTicks * swingSpeed + (float)Math.PI)) * angleRange * 0.5f;
        this.rightcover.yRot -= 0.5235988f;
        this.leftcover.yRot = Mth.cos((float)(ageInTicks * swingSpeed)) * angleRange * 0.5f;
        this.leftcover.yRot += 0.5235988f;
        this.rightpage.yRot = this.rightcover.yRot;
        this.leftpage.yRot = this.leftcover.yRot;
        float swingSpeed2 = 0.4f;
        float angleRange2 = 0.4f;
        this.rightpagemiddle.yRot = Mth.cos((float)(ageInTicks * swingSpeed2 + (float)Math.PI)) * angleRange2 * 0.5f;
        this.rightpagemiddle.yRot -= 3.6651914f;
        this.leftpagemiddle.yRot = Mth.cos((float)(ageInTicks * swingSpeed2)) * angleRange2 * 0.5f;
        this.leftpagemiddle.yRot -= -0.5235988f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int unused) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay);
    }
}

