/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gaia.entity.EnderEye;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class EnderEyeModel
extends EntityModel<EnderEye> {
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart eyelid1;
    private final ModelPart eyelid2;
    private final ModelPart tail1;
    private final ModelPart leftwing;
    private final ModelPart rightwing;

    public EnderEyeModel(ModelPart root) {
        this.root = root.getChild("ender_eye");
        this.body = this.root.getChild("body");
        this.eyelid1 = this.body.getChild("eyelid1");
        this.eyelid2 = this.body.getChild("eyelid2");
        this.tail1 = this.eyelid2.getChild("tail1");
        this.leftwing = this.body.getChild("leftwing");
        this.rightwing = this.body.getChild("rightwing");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition ender_eye = partdefinition.addOrReplaceChild("ender_eye", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)15.0f, (float)0.0f));
        PartDefinition body = ender_eye.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -3.0f, 8.0f, 8.0f, 6.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.5f));
        PartDefinition eyelid1 = body.addOrReplaceChild("eyelid1", CubeListBuilder.create().texOffs(0, 14).addBox(-5.0f, -5.0f, -9.0f, 10.0f, 5.0f, 10.0f), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)3.5f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition eyelid2 = body.addOrReplaceChild("eyelid2", CubeListBuilder.create().texOffs(0, 29).addBox(-5.0f, 0.0f, -10.0f, 10.0f, 5.0f, 10.0f), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)4.5f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition tail1 = eyelid2.addOrReplaceChild("tail1", CubeListBuilder.create().texOffs(0, 44).addBox(-1.5f, 0.0f, 0.0f, 3.0f, 3.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)5.0f, (float)-3.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition tail2 = tail1.addOrReplaceChild("tail2", CubeListBuilder.create().texOffs(0, 50).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)1.5f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition tail3 = tail2.addOrReplaceChild("tail3", CubeListBuilder.create().texOffs(0, 56).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 4.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)0.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition rightwing = body.addOrReplaceChild("rightwing", CubeListBuilder.create().texOffs(98, 38).addBox(0.0f, 0.0f, -3.0f, 0.0f, 16.0f, 10.0f), PartPose.offsetAndRotation((float)-2.0f, (float)0.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)1.5708f));
        PartDefinition leftwing = body.addOrReplaceChild("leftwing", CubeListBuilder.create().texOffs(98, 38).mirror().addBox(0.0f, 0.0f, -3.0f, 0.0f, 16.0f, 10.0f).mirror(false), PartPose.offsetAndRotation((float)2.0f, (float)0.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)-1.5708f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void setupAnim(EnderEye enderEye, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float floatSpeed = 0.5f;
        float floatRange = 3.0f;
        this.root.y = 15.0f - Mth.cos((float)((ageInTicks + 1.5f) * floatSpeed)) * floatRange;
        this.body.yRot = netHeadYaw / 57.295776f;
        float swingSpeed = 0.5f;
        float angleRange = 0.2f;
        this.eyelid1.xRot = Mth.cos((float)(ageInTicks * swingSpeed + (float)Math.PI)) * angleRange * 0.5f;
        this.eyelid2.xRot = Mth.cos((float)(ageInTicks * swingSpeed)) * angleRange * 0.5f;
        this.eyelid2.xRot = 0.34906584f;
        float swingSpeed2 = 0.5f;
        float angleRange2 = 1.0f;
        float wingDefaultAngleZ = 1.570796f;
        this.leftwing.zRot = Mth.cos((float)(ageInTicks * swingSpeed2 + (float)Math.PI)) * angleRange2 * 0.5f;
        this.leftwing.zRot += wingDefaultAngleZ;
        this.rightwing.zRot = Mth.cos((float)(ageInTicks * swingSpeed2)) * angleRange2 * 0.5f;
        this.rightwing.zRot -= wingDefaultAngleZ;
        float tailDefaultAngleX = 0.7853982f;
        this.tail1.xRot = Mth.cos((float)(ageInTicks * 7.0f * ((float)Math.PI / 180))) * 0.08726646f;
        this.tail1.xRot += tailDefaultAngleX;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int unused) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay);
    }
}

