/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gaia.entity.FleshLich;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;

public class FleshLichModel
extends EntityModel<FleshLich>
implements HeadedModel,
ArmedModel {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart headlower;
    private final ModelPart body;
    private final ModelPart waist1;
    private final ModelPart rightarm;
    private final ModelPart leftarm;
    private final ModelPart rightleg;
    private final ModelPart leftleg;

    public FleshLichModel(ModelPart root) {
        this.root = root.getChild("flesh_lich");
        this.body = this.root.getChild("body");
        this.head = this.body.getChild("head");
        this.headlower = this.head.getChild("headlower");
        this.waist1 = this.body.getChild("waist1");
        this.rightarm = this.body.getChild("rightarm");
        this.leftarm = this.body.getChild("leftarm");
        this.rightleg = this.root.getChild("rightleg");
        this.leftleg = this.root.getChild("leftleg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition flesh_lich = partdefinition.addOrReplaceChild("flesh_lich", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = flesh_lich.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 14).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f).texOffs(56, 22).addBox(-2.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f), PartPose.offset((float)0.0f, (float)-24.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 6.0f, 8.0f).texOffs(56, 0).addBox(-4.0f, -2.0f, -4.0f, 8.0f, 2.0f, 8.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition headlower = head.addOrReplaceChild("headlower", CubeListBuilder.create().texOffs(56, 10).addBox(-4.0f, 0.0f, -8.0f, 8.0f, 4.0f, 8.0f), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)4.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition rightarm = body.addOrReplaceChild("rightarm", CubeListBuilder.create().texOffs(24, 14).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f).texOffs(56, 54).mirror().addBox(-3.5f, -3.0f, -2.5f, 5.0f, 5.0f, 5.0f).mirror(false), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        PartDefinition leftarm = body.addOrReplaceChild("leftarm", CubeListBuilder.create().texOffs(24, 14).mirror().addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f).mirror(false).texOffs(56, 30).mirror().addBox(-2.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f).mirror(false).texOffs(56, 42).mirror().addBox(-1.5f, -0.5f, -2.5f, 5.0f, 7.0f, 5.0f).mirror(false), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        PartDefinition banner = body.addOrReplaceChild("banner", CubeListBuilder.create().texOffs(91, 30).addBox(-3.0f, 0.0f, -1.25f, 6.0f, 12.0f, 1.0f), PartPose.offset((float)0.0f, (float)10.0f, (float)-1.0f));
        PartDefinition waist1 = body.addOrReplaceChild("waist1", CubeListBuilder.create().texOffs(88, 0).addBox(-4.5f, 10.0f, -2.5f, 9.0f, 4.0f, 5.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition waist2 = waist1.addOrReplaceChild("waist2", CubeListBuilder.create().texOffs(88, 9).addBox(-5.0f, 0.0f, -4.5f, 10.0f, 4.0f, 5.0f), PartPose.offset((float)0.0f, (float)14.0f, (float)2.5f));
        PartDefinition waist3 = waist2.addOrReplaceChild("waist3", CubeListBuilder.create().texOffs(88, 18).addBox(-5.5f, 0.0f, -4.5f, 11.0f, 4.0f, 5.0f), PartPose.offset((float)0.0f, (float)4.0f, (float)0.5f));
        PartDefinition rightleg = flesh_lich.addOrReplaceChild("rightleg", CubeListBuilder.create().texOffs(40, 14).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offset((float)-2.0f, (float)-12.0f, (float)0.0f));
        PartDefinition leftleg = flesh_lich.addOrReplaceChild("leftleg", CubeListBuilder.create().texOffs(40, 14).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f).mirror(false), PartPose.offset((float)2.0f, (float)-12.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void setupAnim(FleshLich fleshLich, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.headlower.xRot = 0.08726646f;
        if (fleshLich.getAnimationState() == 0) {
            this.rightarm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.8f * limbSwingAmount * 0.5f;
            this.leftarm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.8f * limbSwingAmount * 0.5f;
            this.rightarm.zRot = 0.0f;
            this.leftarm.zRot = 0.0f;
            if (this.attackTime > 0.0f) {
                this.holdingMelee();
            }
            this.rightarm.zRot += Mth.cos((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
            this.rightarm.xRot += Mth.sin((float)(ageInTicks * 0.067f)) * 0.05f;
            this.leftarm.zRot -= Mth.cos((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
            this.leftarm.xRot -= Mth.sin((float)(ageInTicks * 0.067f)) * 0.05f;
        }
        if (fleshLich.getAnimationState() == 1) {
            this.animationThrow();
        }
        this.rightleg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.5f * limbSwingAmount;
        this.leftleg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.5f * limbSwingAmount;
        this.rightleg.yRot = 0.0f;
        this.leftleg.yRot = 0.0f;
        this.rightleg.zRot = 0.0f;
        this.leftleg.zRot = 0.0f;
        this.waist1.xRot = 0.08726646f;
        if (this.riding) {
            this.rightarm.xRot -= 0.62831855f;
            this.leftarm.xRot -= 0.62831855f;
            this.rightleg.xRot = -1.4137167f;
            this.rightleg.yRot = 0.31415927f;
            this.rightleg.zRot = 0.07853982f;
            this.leftleg.xRot = -1.4137167f;
            this.leftleg.yRot = -0.31415927f;
            this.leftleg.zRot = -0.07853982f;
        }
    }

    public void holdingMelee() {
        float f6 = 1.0f - this.attackTime;
        f6 *= f6;
        f6 *= f6;
        f6 = 1.0f - f6;
        float f7 = Mth.sin((float)(f6 * (float)Math.PI));
        float f8 = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -(this.head.xRot - 0.7f) * 0.75f;
        this.rightarm.xRot = (float)((double)this.rightarm.xRot - ((double)f7 * 1.2 + (double)f8));
        this.rightarm.xRot += this.body.yRot * 2.0f;
        this.rightarm.zRot = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -0.4f;
    }

    private void animationThrow() {
        this.rightarm.xRot = -1.0472f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int unused) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay);
    }

    public ModelPart getHead() {
        return this.head;
    }

    private ModelPart getArm(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.leftarm : this.rightarm;
    }

    public void translateToHand(HumanoidArm arm, PoseStack poseStack) {
        this.getArm(arm).translateAndRotate(poseStack);
    }
}

