/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gaia.entity.GelatinousSlime;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;

public class GelatinousSlimeModel
extends EntityModel<GelatinousSlime>
implements HeadedModel,
ArmedModel {
    private final ModelPart root;
    private final ModelPart bodyupper;
    private final ModelPart head;
    private final ModelPart leftarm;
    private final ModelPart rightarm;
    private final ModelPart bodylower;
    private final ModelPart leftleg;

    public GelatinousSlimeModel(ModelPart root) {
        this.root = root.getChild("gelatinous_slime");
        this.bodyupper = this.root.getChild("bodyupper");
        this.head = this.bodyupper.getChild("head");
        this.rightarm = this.bodyupper.getChild("rightarm");
        this.leftarm = this.root.getChild("invisiblearm");
        this.bodylower = this.bodyupper.getChild("bodylower");
        this.leftleg = this.root.getChild("leftleg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition gelatinous_slime = partdefinition.addOrReplaceChild("gelatinous_slime", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition bodyupper = gelatinous_slime.addOrReplaceChild("bodyupper", CubeListBuilder.create().texOffs(16, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 8.0f, 4.0f), PartPose.offsetAndRotation((float)-6.0f, (float)-21.0f, (float)-4.0f, (float)0.6109f, (float)-0.3491f, (float)0.0f));
        bodyupper.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -7.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)0.0f, (float)-0.4363f, (float)0.4363f, (float)0.0f));
        bodyupper.addOrReplaceChild("rightarm", CubeListBuilder.create().texOffs(40, 16).addBox(-2.0f, -1.0f, -1.0f, 2.0f, 12.0f, 2.0f), PartPose.offsetAndRotation((float)-4.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.5236f));
        PartDefinition leftarm = bodyupper.addOrReplaceChild("leftarm", CubeListBuilder.create().texOffs(40, 16).addBox(0.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f), PartPose.offsetAndRotation((float)4.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.6981f));
        leftarm.addOrReplaceChild("leftarmlower", CubeListBuilder.create().texOffs(40, 22).addBox(-2.0f, 0.0f, -1.005f, 2.0f, 6.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)5.0f, (float)0.0f, (float)3.1416f, (float)0.0f, (float)2.3562f));
        PartDefinition bodylower = bodyupper.addOrReplaceChild("bodylower", CubeListBuilder.create().texOffs(16, 28).addBox(-4.0f, 0.0f, -4.0f, 8.0f, 4.0f, 4.0f), PartPose.offsetAndRotation((float)0.0f, (float)8.0f, (float)2.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        bodylower.addOrReplaceChild("rightleg", CubeListBuilder.create().texOffs(0, 16).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f), PartPose.offsetAndRotation((float)-2.0f, (float)4.0f, (float)-2.0f, (float)0.4363f, (float)0.0f, (float)-0.5236f));
        gelatinous_slime.addOrReplaceChild("invisiblearm", CubeListBuilder.create().texOffs(0, 114).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 12.0f, 2.0f), PartPose.offsetAndRotation((float)2.0f, (float)-20.0f, (float)8.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition leftleg = gelatinous_slime.addOrReplaceChild("leftleg", CubeListBuilder.create().texOffs(0, 16).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f), PartPose.offsetAndRotation((float)4.0f, (float)-12.0f, (float)0.0f, (float)-0.7854f, (float)-0.4363f, (float)0.5236f));
        leftleg.addOrReplaceChild("leftleglower", CubeListBuilder.create().texOffs(0, 22).addBox(-1.095f, 0.0f, 0.0f, 2.0f, 6.0f, 2.0f), PartPose.offsetAndRotation((float)0.1f, (float)6.0f, (float)-1.0f, (float)1.0472f, (float)0.0f, (float)0.0f));
        PartDefinition mainbody1 = gelatinous_slime.addOrReplaceChild("mainbody1", CubeListBuilder.create().texOffs(64, 0).addBox(-16.0f, -16.0f, -16.0f, 32.0f, 32.0f, 32.0f).texOffs(64, 0).addBox(-18.0f, -11.0f, 4.0f, 2.0f, 2.0f, 2.0f).texOffs(64, 4).addBox(16.0f, -3.0f, -6.0f, 3.0f, 3.0f, 3.0f).texOffs(64, 4).addBox(-19.0f, -8.0f, -2.0f, 3.0f, 3.0f, 3.0f), PartPose.offset((float)0.0f, (float)-16.0f, (float)0.0f));
        mainbody1.addOrReplaceChild("mainbody2", CubeListBuilder.create().texOffs(64, 64).addBox(-12.0f, -12.0f, -12.0f, 24.0f, 24.0f, 24.0f).texOffs(160, 64).addBox(-12.0f, -12.0f, -12.0f, 24.0f, 24.0f, 24.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        mainbody1.addOrReplaceChild("slimesoutheast", CubeListBuilder.create().texOffs(76, 0).addBox(14.0f, 12.0f, -18.0f, 4.0f, 4.0f, 4.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        mainbody1.addOrReplaceChild("slimenortheast", CubeListBuilder.create().texOffs(76, 0).addBox(14.0f, 12.0f, 14.0f, 4.0f, 4.0f, 4.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        mainbody1.addOrReplaceChild("slimenorthwest", CubeListBuilder.create().texOffs(76, 0).addBox(-18.0f, 12.0f, 14.0f, 4.0f, 4.0f, 4.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        mainbody1.addOrReplaceChild("slimesouthwest", CubeListBuilder.create().texOffs(76, 0).addBox(-18.0f, 12.0f, -18.0f, 4.0f, 4.0f, 4.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)256, (int)128);
    }

    public void setupAnim(GelatinousSlime entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float floatSpeed = 0.2f;
        float floatRange = 0.2f;
        this.root.y = 24.0f - Mth.cos((float)((ageInTicks + 1.5f) * floatSpeed)) * floatRange;
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        float rightarmDefaultAngleZ = 1.047198f;
        this.rightarm.zRot = Mth.cos((float)(ageInTicks * 7.0f * ((float)Math.PI / 180))) * ((float)Math.PI / 90);
        this.rightarm.zRot += rightarmDefaultAngleZ;
        float bodyupperDefaultAngleX = 0.6108652f;
        this.bodyupper.xRot = Mth.cos((float)(ageInTicks * 7.0f * ((float)Math.PI / 180))) * ((float)Math.PI / 90);
        this.bodyupper.xRot += bodyupperDefaultAngleX;
        float bodylowerDefaultAngleX = 1.047198f;
        this.bodylower.xRot = Mth.cos((float)(ageInTicks * 7.0f * ((float)Math.PI / 180))) * ((float)Math.PI / 90);
        this.bodylower.xRot += bodylowerDefaultAngleX;
        float leftlegDefaultAngleX = 0.7853982f;
        this.leftleg.xRot = Mth.cos((float)(ageInTicks * 7.0f * ((float)Math.PI / 180))) * ((float)Math.PI / 90);
        this.leftleg.xRot -= leftlegDefaultAngleX;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int unused) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay);
    }

    public ModelPart getHead() {
        return this.head;
    }

    private ModelPart getArm(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.leftarm : this.rightarm;
    }

    public void translateToHand(HumanoidArm arm, PoseStack poseStack) {
        poseStack.translate(0.0f, 1.0f, 0.0f);
        this.getArm(arm).translateAndRotate(poseStack);
    }
}

