/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gaia.entity.Gryphon;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class GryphonModel
extends EntityModel<Gryphon>
implements HeadedModel {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart backleftleg1;
    private final ModelPart backrightleg1;
    private final ModelPart leftwing;
    private final ModelPart rightwing;
    private final ModelPart frontleftleg1;
    private final ModelPart frontrightleg1;
    private final ModelPart tail1;
    private final ModelPart tail2;
    private final ModelPart tail3;

    public GryphonModel(ModelPart root) {
        this.root = root.getChild("gryphon");
        ModelPart body2 = this.root.getChild("body2");
        ModelPart body1 = body2.getChild("body1");
        ModelPart neck1 = body1.getChild("neck2").getChild("neck1");
        this.head = neck1.getChild("head");
        this.leftwing = body1.getChild("leftwing");
        this.rightwing = body1.getChild("rightwing");
        this.frontleftleg1 = body1.getChild("frontleftleg1");
        this.frontrightleg1 = body1.getChild("frontrightleg1");
        this.backleftleg1 = body2.getChild("backleftleg1");
        this.backrightleg1 = body2.getChild("backrightleg1");
        this.tail1 = body2.getChild("tail1");
        this.tail2 = this.tail1.getChild("tail2");
        this.tail3 = this.tail2.getChild("tail3");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition gryphon = partdefinition.addOrReplaceChild("gryphon", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body2 = gryphon.addOrReplaceChild("body2", CubeListBuilder.create().texOffs(56, 19).addBox(-3.0f, 1.0f, -8.0f, 6.0f, 12.0f, 8.0f), PartPose.offsetAndRotation((float)0.0f, (float)-16.0f, (float)-4.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition body1 = body2.addOrReplaceChild("body1", CubeListBuilder.create().texOffs(56, 0).addBox(-4.0f, -9.0f, 0.0f, 8.0f, 9.0f, 10.0f), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)-9.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition neck2 = body1.addOrReplaceChild("neck2", CubeListBuilder.create().texOffs(28, 12).addBox(-3.5f, -8.0f, 0.0f, 7.0f, 8.0f, 7.0f), PartPose.offsetAndRotation((float)0.0f, (float)-9.0f, (float)1.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition neck1 = neck2.addOrReplaceChild("neck1", CubeListBuilder.create().texOffs(28, 0).addBox(-3.0f, -6.0f, 0.0f, 6.0f, 6.0f, 6.0f), PartPose.offsetAndRotation((float)0.0f, (float)-8.0f, (float)0.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition head = neck1.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, -3.0f, -4.0f, 5.0f, 5.0f, 6.0f).texOffs(0, 13).addBox(-1.5f, -1.0f, -8.0f, 3.0f, 3.0f, 4.0f).texOffs(0, 20).addBox(-1.0f, -0.5f, -8.5f, 2.0f, 3.0f, 1.0f).texOffs(0, 11).addBox(-2.5f, -2.0f, -5.0f, 5.0f, 1.0f, 1.0f), PartPose.offset((float)0.0f, (float)-6.0f, (float)3.0f));
        PartDefinition rightheadear = head.addOrReplaceChild("rightheadear", CubeListBuilder.create().texOffs(0, 24).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 6.0f), PartPose.offsetAndRotation((float)-2.0f, (float)-2.5f, (float)1.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition leftheadear = head.addOrReplaceChild("leftheadear", CubeListBuilder.create().texOffs(0, 24).mirror().addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 6.0f).mirror(false), PartPose.offsetAndRotation((float)2.0f, (float)-2.5f, (float)1.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition rightwing = body1.addOrReplaceChild("rightwing", CubeListBuilder.create().texOffs(108, 38).addBox(0.0f, 0.0f, 0.0f, 0.0f, 16.0f, 10.0f), PartPose.offsetAndRotation((float)-4.0f, (float)-8.0f, (float)9.0f, (float)0.0f, (float)0.0f, (float)0.2618f));
        PartDefinition leftwing = body1.addOrReplaceChild("leftwing", CubeListBuilder.create().texOffs(108, 38).addBox(0.0f, 0.0f, 0.0f, 0.0f, 16.0f, 10.0f), PartPose.offsetAndRotation((float)4.0f, (float)-8.0f, (float)9.0f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        PartDefinition frontrightleg1 = body1.addOrReplaceChild("frontrightleg1", CubeListBuilder.create().texOffs(92, 0).addBox(-3.0f, -1.5f, -1.5f, 3.0f, 8.0f, 3.0f), PartPose.offsetAndRotation((float)-3.0f, (float)-6.5f, (float)4.5f, (float)-1.0472f, (float)0.0f, (float)0.0f));
        PartDefinition frontrightleg2 = frontrightleg1.addOrReplaceChild("frontrightleg2", CubeListBuilder.create().texOffs(92, 11).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 8.0f, 3.0f), PartPose.offsetAndRotation((float)-1.5f, (float)5.5f, (float)0.5f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition frontrightclaw = frontrightleg2.addOrReplaceChild("frontrightclaw", CubeListBuilder.create().texOffs(92, 22).addBox(-2.0f, 0.0f, -3.5f, 4.0f, 1.0f, 4.0f), PartPose.offsetAndRotation((float)0.0f, (float)7.0f, (float)0.5f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition frontleftleg1 = body1.addOrReplaceChild("frontleftleg1", CubeListBuilder.create().texOffs(92, 0).mirror().addBox(0.0f, -1.5f, -1.5f, 3.0f, 8.0f, 3.0f).mirror(false), PartPose.offsetAndRotation((float)3.0f, (float)-6.5f, (float)4.6f, (float)-1.0472f, (float)0.0f, (float)0.0f));
        PartDefinition frontleftleg2 = frontleftleg1.addOrReplaceChild("frontleftleg2", CubeListBuilder.create().texOffs(92, 11).mirror().addBox(-1.0f, -1.0f, -1.0f, 2.0f, 8.0f, 3.0f).mirror(false), PartPose.offsetAndRotation((float)1.5f, (float)5.5f, (float)0.5f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition frontleftclaw = frontleftleg2.addOrReplaceChild("frontleftclaw", CubeListBuilder.create().texOffs(92, 22).mirror().addBox(-2.0f, 0.0f, -3.5f, 4.0f, 1.0f, 4.0f).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)7.0f, (float)0.5f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition backleftleg1 = body2.addOrReplaceChild("backleftleg1", CubeListBuilder.create().texOffs(108, 0).mirror().addBox(-1.5f, 0.0f, -3.0f, 3.0f, 8.0f, 6.0f).mirror(false), PartPose.offsetAndRotation((float)3.0f, (float)11.0f, (float)0.0f, (float)-2.0944f, (float)0.0f, (float)0.0f));
        PartDefinition backleftleg2 = backleftleg1.addOrReplaceChild("backleftleg2", CubeListBuilder.create().texOffs(108, 14).mirror().addBox(-1.0f, -3.0f, 0.0f, 2.0f, 3.0f, 6.0f).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)8.0f, (float)-3.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition backleftleg3 = backleftleg2.addOrReplaceChild("backleftleg3", CubeListBuilder.create().texOffs(108, 23).mirror().addBox(-1.0f, 0.0f, -3.0f, 2.0f, 6.0f, 3.0f).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)6.0f, (float)1.0472f, (float)0.0f, (float)0.0f));
        PartDefinition backleftfoot = backleftleg3.addOrReplaceChild("backleftfoot", CubeListBuilder.create().texOffs(108, 32).mirror().addBox(-1.5f, -0.5f, -2.5f, 3.0f, 2.0f, 3.0f).mirror(false), PartPose.offset((float)0.0f, (float)5.5f, (float)-2.5f));
        PartDefinition backrightleg1 = body2.addOrReplaceChild("backrightleg1", CubeListBuilder.create().texOffs(108, 0).addBox(-1.5f, 0.0f, -3.0f, 3.0f, 8.0f, 6.0f), PartPose.offsetAndRotation((float)-3.0f, (float)11.0f, (float)0.0f, (float)-2.0944f, (float)0.0f, (float)0.0f));
        PartDefinition backrightleg2 = backrightleg1.addOrReplaceChild("backrightleg2", CubeListBuilder.create().texOffs(108, 14).addBox(-1.0f, -3.0f, 0.0f, 2.0f, 3.0f, 6.0f), PartPose.offsetAndRotation((float)0.0f, (float)8.0f, (float)-3.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition backrightleg3 = backrightleg2.addOrReplaceChild("backrightleg3", CubeListBuilder.create().texOffs(108, 23).addBox(-1.0f, 0.0f, -3.0f, 2.0f, 6.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)6.0f, (float)1.0472f, (float)0.0f, (float)0.0f));
        PartDefinition backrightfoot = backrightleg3.addOrReplaceChild("backrightfoot", CubeListBuilder.create().texOffs(108, 32).addBox(-1.5f, -0.5f, -2.5f, 3.0f, 2.0f, 3.0f), PartPose.offset((float)0.0f, (float)5.5f, (float)-2.5f));
        PartDefinition tail1 = body2.addOrReplaceChild("tail1", CubeListBuilder.create().texOffs(56, 39).addBox(-1.0f, 0.0f, 0.0f, 2.0f, 2.0f, 6.0f), PartPose.offsetAndRotation((float)0.0f, (float)13.0f, (float)0.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition tail2 = tail1.addOrReplaceChild("tail2", CubeListBuilder.create().texOffs(56, 47).addBox(-0.5f, -0.5f, 0.0f, 1.0f, 1.0f, 6.0f), PartPose.offset((float)0.0f, (float)1.0f, (float)6.0f));
        PartDefinition tail3 = tail2.addOrReplaceChild("tail3", CubeListBuilder.create().texOffs(56, 54).addBox(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 3.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)6.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void setupAnim(Gryphon entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        if (this.attackTime > 0.0f) {
            this.holdingMelee();
        }
        float baseFrontRot = -1.0471976f;
        this.frontrightleg1.xRot = baseFrontRot + Mth.cos((float)(limbSwing * 0.6662f)) * 0.8f * limbSwingAmount;
        this.frontleftleg1.xRot = baseFrontRot + Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.8f * limbSwingAmount;
        this.rightwing.yRot = Mth.cos((float)(ageInTicks * 0.6662f + (float)Math.PI)) * 1.0f * limbSwingAmount * 0.5f;
        this.leftwing.yRot = Mth.cos((float)(ageInTicks * 0.6662f)) * 1.0f * limbSwingAmount * 0.5f;
        this.rightwing.yRot -= 0.1745329f;
        this.leftwing.yRot += 0.1745329f;
        this.tail1.yRot = Mth.cos((float)(ageInTicks * 7.0f * ((float)Math.PI / 180))) * 0.08726646f;
        this.tail2.yRot = Mth.cos((float)(ageInTicks * 7.0f * ((float)Math.PI / 180))) * 0.12217305f;
        this.tail1.xRot = -1.0471976f;
        this.tail2.xRot = 0.5235988f;
        this.tail3.xRot = 0.5235988f;
        float baseBackRot = -1.9198622f;
        this.backrightleg1.xRot = baseBackRot - Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.8f * limbSwingAmount;
        this.backleftleg1.xRot = baseBackRot - Mth.cos((float)(limbSwing * 0.6662f)) * 0.8f * limbSwingAmount;
    }

    public void holdingMelee() {
        float f6 = 1.0f - this.attackTime;
        f6 *= f6;
        f6 *= f6;
        f6 = 1.0f - f6;
        float f7 = Mth.sin((float)(f6 * (float)Math.PI));
        float f8 = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -(this.head.xRot - 0.7f) * 0.75f;
        this.head.xRot -= (float)((double)this.head.xRot - ((double)f7 * 1.2 + (double)f8));
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int unused) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay);
    }

    public ModelPart getHead() {
        return this.head;
    }
}

