/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gaia.config.GaiaConfig;
import gaia.entity.Harpy;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.phys.Vec3;

public class HarpyModel
extends EntityModel<Harpy>
implements HeadedModel,
ArmedModel {
    private final ModelPart root;
    private final ModelPart bodytop;
    private final ModelPart head;
    private final ModelPart headeyes;
    private final ModelPart chest;
    private final ModelPart tail;
    private final ModelPart leftarm;
    private final ModelPart rightarm;
    private final ModelPart leftleg;
    private final ModelPart rightleg;

    public HarpyModel(ModelPart root) {
        this.root = root.getChild("harpy");
        ModelPart bodybottom = this.root.getChild("bodybottom");
        this.bodytop = bodybottom.getChild("bodymiddle").getChild("bodytop");
        ModelPart neck = this.bodytop.getChild("neck");
        this.head = neck.getChild("head");
        this.headeyes = this.head.getChild("headeyes");
        this.chest = this.bodytop.getChild("chest");
        this.leftarm = this.bodytop.getChild("leftarm");
        this.rightarm = this.bodytop.getChild("rightarm");
        this.tail = bodybottom.getChild("tail");
        this.leftleg = this.root.getChild("leftleg");
        this.rightleg = this.root.getChild("rightleg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition harpy = partdefinition.addOrReplaceChild("harpy", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition bodybottom = harpy.addOrReplaceChild("bodybottom", CubeListBuilder.create().texOffs(0, 30).addBox(-3.0f, -1.5f, -1.5f, 6.0f, 3.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)-13.5f, (float)-0.5f, (float)1.0472f, (float)0.0f, (float)0.0f));
        PartDefinition bodymid = bodybottom.addOrReplaceChild("bodymiddle", CubeListBuilder.create().texOffs(0, 25).addBox(-2.0f, -2.5f, -1.5f, 4.0f, 3.0f, 2.0f).texOffs(0, 25).addBox(-0.5f, -2.0f, -1.6f, 1.0f, 2.0f, 0.0f), PartPose.offsetAndRotation((float)0.0f, (float)-1.5f, (float)0.5f, (float)-0.6109f, (float)0.0f, (float)0.0f));
        PartDefinition bodytop = bodymid.addOrReplaceChild("bodytop", CubeListBuilder.create().texOffs(0, 16).addBox(-2.5f, -6.0f, -2.5f, 5.0f, 6.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)0.5f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition neck = bodytop.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(0, 12).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)-6.0f, (float)-1.1f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -6.0f, -3.0f, 6.0f, 6.0f, 6.0f).texOffs(36, 0).addBox(-3.5f, -6.5f, -3.5f, 7.0f, 7.0f, 7.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.1f));
        PartDefinition hair = head.addOrReplaceChild("hair", CubeListBuilder.create().texOffs(36, 14).addBox(-2.0f, -2.5f, -1.0f, 5.0f, 5.0f, 5.0f), PartPose.offset((float)-0.5f, (float)-5.5f, (float)3.0f));
        PartDefinition hairahoge = head.addOrReplaceChild("hairahoge", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-6.0f, (float)-2.0f));
        PartDefinition hairahoge_r1 = hairahoge.addOrReplaceChild("hairahoge_r1", CubeListBuilder.create().texOffs(36, 24).addBox(0.0f, -33.5f, 0.0f, 4.0f, 4.0f, 4.0f), PartPose.offsetAndRotation((float)0.0f, (float)29.5f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition rightfeather = head.addOrReplaceChild("rightfeather", CubeListBuilder.create(), PartPose.offset((float)3.5f, (float)-4.0f, (float)-1.5f));
        PartDefinition rightfeather_r1 = rightfeather.addOrReplaceChild("rightfeather_r1", CubeListBuilder.create().texOffs(36, 32).addBox(0.0f, -1.0f, -1.0f, 1.0f, 6.0f, 8.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3491f, (float)-0.2618f));
        PartDefinition leftfeather = head.addOrReplaceChild("leftfeather", CubeListBuilder.create(), PartPose.offset((float)-3.5f, (float)-4.0f, (float)-1.5f));
        PartDefinition leftfeather_r1 = leftfeather.addOrReplaceChild("leftfeather_r1", CubeListBuilder.create().texOffs(36, 32).addBox(-1.0f, -1.0f, -1.0f, 1.0f, 6.0f, 8.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3491f, (float)0.2618f));
        PartDefinition headeyes = head.addOrReplaceChild("headeyes", CubeListBuilder.create().texOffs(24, 0).addBox(-3.0f, -29.0f, -3.6f, 6.0f, 6.0f, 0.0f), PartPose.offset((float)0.0f, (float)23.0f, (float)0.5f));
        PartDefinition chest = bodytop.addOrReplaceChild("chest", CubeListBuilder.create().texOffs(0, 36).mirror().addBox(0.2f, 0.0f, -2.0f, 2.0f, 2.0f, 2.0f).mirror(false).texOffs(0, 36).addBox(-2.2f, 0.0f, -2.0f, 2.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)-5.55f, (float)-2.5f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition rightarm = bodytop.addOrReplaceChild("rightarm", CubeListBuilder.create().texOffs(16, 12).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f), PartPose.offsetAndRotation((float)-3.5f, (float)-4.5f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.5236f));
        PartDefinition rightarmlower = rightarm.addOrReplaceChild("rightarmlower", CubeListBuilder.create().texOffs(16, 20).addBox(-1.005f, 0.0f, -2.0f, 2.0f, 6.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)5.0f, (float)1.0f, (float)-1.0472f, (float)0.0f, (float)0.0f));
        PartDefinition rightwing_r1 = rightarmlower.addOrReplaceChild("rightwing_r1", CubeListBuilder.create().texOffs(64, 16).addBox(-0.5f, 0.0f, 0.0f, 1.0f, 8.0f, 12.0f), PartPose.offsetAndRotation((float)0.5f, (float)6.0f, (float)-2.0f, (float)1.2217f, (float)0.0f, (float)0.0f));
        PartDefinition rightwinglower = rightarmlower.addOrReplaceChild("rightwinglower", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)5.0f, (float)0.0f));
        PartDefinition rightwinglower_r1 = rightwinglower.addOrReplaceChild("rightwinglower_r1", CubeListBuilder.create().texOffs(64, 0).addBox(-0.5f, 0.0f, 0.0f, 1.0f, 6.0f, 10.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition leftarm = bodytop.addOrReplaceChild("leftarm", CubeListBuilder.create().texOffs(16, 12).addBox(-1.0f, -1.0f, -0.5f, 2.0f, 6.0f, 2.0f), PartPose.offsetAndRotation((float)3.5f, (float)-4.5f, (float)-1.5f, (float)0.0f, (float)0.0f, (float)-0.5236f));
        PartDefinition leftarmlower = leftarm.addOrReplaceChild("leftarmlower", CubeListBuilder.create().texOffs(16, 20).addBox(-0.995f, 0.0f, -2.0f, 2.0f, 6.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)5.0f, (float)1.5f, (float)-1.0036f, (float)0.0f, (float)0.0f));
        PartDefinition leftwing_r1 = leftarmlower.addOrReplaceChild("leftwing_r1", CubeListBuilder.create().texOffs(64, 16).addBox(-0.5f, 0.0f, 0.0f, 1.0f, 8.0f, 12.0f), PartPose.offsetAndRotation((float)-0.5f, (float)6.0f, (float)-2.0f, (float)1.2217f, (float)0.0f, (float)0.0f));
        PartDefinition leftwinglower = leftarmlower.addOrReplaceChild("leftwinglower", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)5.0f, (float)0.0f));
        PartDefinition leftwinglower_r1 = leftwinglower.addOrReplaceChild("leftwinglower_r1", CubeListBuilder.create().texOffs(64, 0).addBox(-0.5f, 0.0f, 0.0f, 1.0f, 6.0f, 10.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition tail = bodybottom.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(90, 0).addBox(-1.5f, 0.0f, -0.5f, 3.0f, 10.0f, 1.0f), PartPose.offset((float)0.0f, (float)-1.5f, (float)1.5f));
        PartDefinition rightleg = harpy.addOrReplaceChild("rightleg", CubeListBuilder.create().texOffs(24, 12).addBox(-1.5f, -1.5f, -1.5f, 3.0f, 6.0f, 3.0f), PartPose.offsetAndRotation((float)-2.5f, (float)-13.0f, (float)0.5f, (float)-0.5236f, (float)-0.0873f, (float)0.0f));
        PartDefinition rightleglower = rightleg.addOrReplaceChild("rightleglower", CubeListBuilder.create().texOffs(90, 11).addBox(-1.0f, 0.0f, 0.0f, 2.0f, 4.0f, 2.0f).texOffs(90, 17).addBox(-0.5f, 4.0f, 0.5f, 1.0f, 3.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)4.5f, (float)-1.0f, (float)1.0472f, (float)0.0f, (float)0.0f));
        PartDefinition righttalon = rightleglower.addOrReplaceChild("righttalon", CubeListBuilder.create().texOffs(90, 24).addBox(-1.0f, 0.0f, -3.0f, 2.0f, 1.0f, 4.0f), PartPose.offsetAndRotation((float)0.0f, (float)7.0f, (float)0.5f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition righttalonlower = righttalon.addOrReplaceChild("righttalonlower", CubeListBuilder.create().texOffs(90, 29).addBox(-1.5f, 0.0f, -3.0f, 3.0f, 1.0f, 5.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-3.0f, (float)-1.0472f, (float)0.0f, (float)0.0f));
        PartDefinition leftleg = harpy.addOrReplaceChild("leftleg", CubeListBuilder.create().texOffs(24, 12).addBox(-1.5f, -1.5f, -1.5f, 3.0f, 6.0f, 3.0f), PartPose.offsetAndRotation((float)2.5f, (float)-13.0f, (float)0.5f, (float)-0.5236f, (float)0.0873f, (float)0.0f));
        PartDefinition leftleglower = leftleg.addOrReplaceChild("leftleglower", CubeListBuilder.create().texOffs(90, 11).addBox(-1.0f, 0.0f, 0.0f, 2.0f, 4.0f, 2.0f).texOffs(90, 17).addBox(-0.5f, 4.0f, 0.55f, 1.0f, 3.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)4.5f, (float)-1.0f, (float)1.0472f, (float)0.0f, (float)0.0f));
        PartDefinition lefttalon = leftleglower.addOrReplaceChild("lefttalon", CubeListBuilder.create().texOffs(90, 24).addBox(-1.0f, 0.0f, -3.0f, 2.0f, 1.0f, 4.0f), PartPose.offsetAndRotation((float)0.0f, (float)7.0f, (float)0.5f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition lefttalonlower = lefttalon.addOrReplaceChild("lefttalonlower", CubeListBuilder.create().texOffs(90, 29).addBox(-1.5f, 0.0f, -3.0f, 3.0f, 1.0f, 5.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-3.0f, (float)-1.0472f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void prepareMobModel(Harpy harpy, float limbSwing, float limbSwingAmount, float partialTick) {
        super.prepareMobModel((Entity)harpy, limbSwing, limbSwingAmount, partialTick);
        this.chest.visible = (Boolean)GaiaConfig.CLIENT.genderNeutral.get() == false && !harpy.isBaby();
    }

    public void setupAnim(Harpy harpy, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.headeyes.visible = ageInTicks % 60.0f == 0.0f && limbSwingAmount <= 0.1f;
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f + 0.0872665f;
        this.rightarm.yRot = Mth.cos((float)(ageInTicks * 0.6662f + (float)Math.PI)) * 1.0f * limbSwingAmount * 0.5f - 0.1745329f;
        this.leftarm.yRot = Mth.cos((float)(ageInTicks * 0.6662f)) * 1.0f * limbSwingAmount * 0.5f + 0.1745329f;
        this.rightarm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.8f * limbSwingAmount * 0.5f + 0.6108652f;
        this.leftarm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.8f * limbSwingAmount * 0.5f + 0.6108652f;
        this.rightarm.zRot = 0.0f;
        this.leftarm.zRot = 0.0f;
        this.rightarm.zRot += Mth.cos((float)(ageInTicks * 0.09f)) * 0.025f + 0.025f + 0.3490659f;
        this.rightarm.xRot += Mth.sin((float)(ageInTicks * 0.067f)) * 0.025f;
        this.leftarm.zRot -= Mth.cos((float)(ageInTicks * 0.09f)) * 0.025f + 0.025f + 0.3490659f;
        this.leftarm.xRot -= Mth.sin((float)(ageInTicks * 0.067f)) * 0.025f;
        if (harpy.isFleeing()) {
            Vec3 movement = harpy.getDeltaMovement();
            if (movement.x * movement.x + movement.z * movement.z > 2.500000277905201E-7) {
                this.animationFlee();
            }
        }
        this.tail.yRot = Mth.cos((float)(ageInTicks * 7.0f * ((float)Math.PI / 180))) * 0.08726646f;
        this.rightleg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.8f * limbSwingAmount;
        this.leftleg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.8f * limbSwingAmount;
        this.rightleg.xRot -= 0.5235988f;
        this.leftleg.xRot -= 0.5235988f;
        this.rightleg.yRot = -0.0872665f;
        this.leftleg.yRot = 0.0872665f;
        this.rightleg.zRot = 0.0f;
        this.leftleg.zRot = 0.0f;
        if (this.riding) {
            this.rightarm.xRot -= 0.62831855f;
            this.leftarm.xRot -= 0.62831855f;
            this.rightleg.xRot = -1.4137167f;
            this.rightleg.yRot = 0.31415927f;
            this.rightleg.zRot = 0.07853982f;
            this.leftleg.xRot = -1.4137167f;
            this.leftleg.yRot = -0.31415927f;
            this.leftleg.zRot = -0.07853982f;
        }
    }

    public void holdingMelee() {
        float f6 = 1.0f - this.attackTime;
        f6 *= f6;
        f6 *= f6;
        f6 = 1.0f - f6;
        float f7 = Mth.sin((float)(f6 * (float)Math.PI));
        float f8 = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -(this.head.xRot - 0.7f) * 0.75f;
        this.rightarm.xRot -= (float)((double)this.rightarm.xRot - ((double)f7 * 1.2 + (double)f8));
        this.rightarm.yRot += this.bodytop.yRot * 2.0f;
        this.rightarm.zRot = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -0.4f;
        this.leftarm.xRot -= (float)((double)this.leftarm.xRot - ((double)f7 * 1.2 + (double)f8));
        this.leftarm.yRot += this.bodytop.yRot * 2.0f;
        this.leftarm.zRot -= Mth.sin((float)(this.attackTime * (float)Math.PI)) * -0.4f;
    }

    private void animationFlee() {
        this.rightarm.xRot += 1.0472f;
        this.leftarm.xRot += 1.0472f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int unused) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay);
    }

    public ModelPart getHead() {
        return this.head;
    }

    private ModelPart getArm(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.leftarm : this.rightarm;
    }

    public void translateToHand(HumanoidArm arm, PoseStack poseStack) {
        this.getArm(arm).translateAndRotate(poseStack);
    }
}

