/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gaia.config.GaiaConfig;
import gaia.entity.Matango;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;

public class MatangoModel
extends EntityModel<Matango>
implements HeadedModel,
ArmedModel {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart headeyes;
    private final ModelPart chest;
    private final ModelPart leftarm;
    private final ModelPart rightarm;
    private final ModelPart waist1;
    private final ModelPart leftleg;
    private final ModelPart rightleg;

    public MatangoModel(ModelPart root) {
        this.root = root.getChild("matango");
        ModelPart bodybottom = this.root.getChild("bodybottom");
        ModelPart bodytop = bodybottom.getChild("bodymiddle").getChild("bodytop");
        this.head = bodytop.getChild("neck").getChild("head");
        this.headeyes = this.head.getChild("headeyes");
        this.chest = bodytop.getChild("chest");
        this.leftarm = bodytop.getChild("leftarm");
        this.rightarm = bodytop.getChild("rightarm");
        this.waist1 = bodybottom.getChild("waist1");
        this.leftleg = this.root.getChild("leftleg");
        this.rightleg = this.root.getChild("rightleg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition matango = partdefinition.addOrReplaceChild("matango", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition bodybottom = matango.addOrReplaceChild("bodybottom", CubeListBuilder.create().texOffs(0, 30).addBox(-3.0f, -1.5f, -1.5f, 6.0f, 3.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)-13.5f, (float)0.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition bodymiddle = bodybottom.addOrReplaceChild("bodymiddle", CubeListBuilder.create().texOffs(0, 25).addBox(-2.0f, -2.5f, -1.5f, 4.0f, 3.0f, 2.0f).texOffs(0, 25).addBox(-0.5f, -2.0f, -1.6f, 1.0f, 2.0f, 0.0f), PartPose.offsetAndRotation((float)0.0f, (float)-1.5f, (float)0.5f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition bodytop = bodymiddle.addOrReplaceChild("bodytop", CubeListBuilder.create().texOffs(0, 16).addBox(-2.5f, -5.0f, -2.5f, 5.0f, 5.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)0.5f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition neck = bodytop.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(0, 12).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)-5.0f, (float)-1.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -6.0f, -3.0f, 6.0f, 6.0f, 6.0f).texOffs(36, 0).addBox(-3.5f, -6.5f, -3.5f, 7.0f, 7.0f, 7.0f).texOffs(24, 6).addBox(-3.0f, -6.0f, -3.6f, 6.0f, 6.0f, 0.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition headeyes = head.addOrReplaceChild("headeyes", CubeListBuilder.create().texOffs(24, 0).addBox(-3.0f, -6.0f, -3.1f, 6.0f, 6.0f, 0.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition headmushroom = head.addOrReplaceChild("headmushroom", CubeListBuilder.create().texOffs(36, 14).addBox(-4.0f, -6.0f, -4.0f, 8.0f, 6.0f, 8.0f).texOffs(36, 28).addBox(-7.0f, -4.5f, -2.9f, 6.0f, 6.0f, 6.0f).texOffs(36, 28).addBox(1.0f, -4.5f, -2.9f, 6.0f, 6.0f, 6.0f), PartPose.offset((float)0.0f, (float)-4.5f, (float)0.0f));
        PartDefinition righthair = head.addOrReplaceChild("righthair", CubeListBuilder.create().texOffs(36, 40).addBox(-1.5f, -1.5f, -1.5f, 3.0f, 14.0f, 3.0f).texOffs(36, 57).addBox(-1.0f, 9.5f, -1.0f, 2.0f, 2.0f, 2.0f).texOffs(48, 40).addBox(-2.0f, 11.5f, -2.0f, 4.0f, 2.0f, 4.0f), PartPose.offsetAndRotation((float)-3.0f, (float)-3.5f, (float)3.0f, (float)0.1745f, (float)0.0f, (float)0.2618f));
        PartDefinition lefthair = head.addOrReplaceChild("lefthair", CubeListBuilder.create().texOffs(36, 40).addBox(-1.5f, -1.6f, -1.5f, 3.0f, 14.0f, 3.0f).texOffs(36, 57).addBox(-1.0f, 9.4f, -1.0f, 2.0f, 2.0f, 2.0f).texOffs(48, 40).addBox(-2.0f, 11.4f, -2.0f, 4.0f, 2.0f, 4.0f), PartPose.offsetAndRotation((float)3.0f, (float)-3.4f, (float)3.0f, (float)0.1745f, (float)0.0f, (float)-0.2618f));
        PartDefinition chest = bodytop.addOrReplaceChild("chest", CubeListBuilder.create().texOffs(0, 36).addBox(-2.3f, 0.0f, -2.0f, 2.0f, 2.0f, 2.0f).texOffs(0, 36).mirror().addBox(0.3f, 0.0f, -2.0f, 2.0f, 2.0f, 2.0f).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-4.5f, (float)-2.5f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition rightarm = bodytop.addOrReplaceChild("rightarm", CubeListBuilder.create().texOffs(16, 12).addBox(-2.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f), PartPose.offsetAndRotation((float)-2.5f, (float)-3.5f, (float)-1.0f, (float)0.0873f, (float)0.0f, (float)0.1745f));
        PartDefinition rightarmlower = rightarm.addOrReplaceChild("rightarmlower", CubeListBuilder.create().texOffs(16, 18).addBox(-1.005f, 0.0f, -2.0f, 2.0f, 6.0f, 2.0f).texOffs(68, 0).addBox(-1.5f, -1.0f, -2.5f, 3.0f, 6.0f, 3.0f), PartPose.offset((float)-1.0f, (float)5.0f, (float)1.0f));
        PartDefinition leftarm = bodytop.addOrReplaceChild("leftarm", CubeListBuilder.create().texOffs(16, 12).mirror().addBox(0.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f).mirror(false), PartPose.offsetAndRotation((float)2.5f, (float)-3.5f, (float)-1.0f, (float)0.0873f, (float)0.0f, (float)-0.1745f));
        PartDefinition leftarmlower = leftarm.addOrReplaceChild("leftarmlower", CubeListBuilder.create().texOffs(16, 12).addBox(-0.995f, 0.0f, -2.0f, 2.0f, 6.0f, 2.0f).texOffs(68, 0).mirror().addBox(-1.5f, -1.0f, -2.5f, 3.0f, 6.0f, 3.0f).mirror(false), PartPose.offset((float)1.0f, (float)5.0f, (float)1.0f));
        PartDefinition waist1 = bodybottom.addOrReplaceChild("waist1", CubeListBuilder.create().texOffs(80, 14).addBox(-3.5f, 1.5f, -3.5f, 7.0f, 2.0f, 7.0f).texOffs(80, 23).addBox(-4.0f, 3.0f, -4.0f, 8.0f, 4.0f, 8.0f).texOffs(80, 0).addBox(-3.0f, 0.0f, -3.0f, 6.0f, 1.0f, 6.0f).texOffs(80, 7).addBox(-2.5f, 0.5f, -2.5f, 5.0f, 2.0f, 5.0f), PartPose.offset((float)0.0f, (float)-2.1f, (float)-0.5f));
        PartDefinition rightleg = matango.addOrReplaceChild("rightleg", CubeListBuilder.create().texOffs(24, 12).addBox(-1.5f, -1.0f, -1.5f, 3.0f, 7.0f, 3.0f), PartPose.offsetAndRotation((float)-2.0f, (float)-13.0f, (float)0.0f, (float)0.0f, (float)-0.0436f, (float)-0.0436f));
        PartDefinition rightleglower = rightleg.addOrReplaceChild("rightleglower", CubeListBuilder.create().texOffs(24, 19).addBox(-1.505f, 0.0f, 0.0f, 3.0f, 7.0f, 3.0f).texOffs(80, 35).addBox(-2.0f, 1.0f, -0.5f, 4.0f, 6.0f, 4.0f), PartPose.offset((float)0.0f, (float)6.0f, (float)-1.5f));
        PartDefinition leftleg = matango.addOrReplaceChild("leftleg", CubeListBuilder.create().texOffs(24, 12).addBox(-1.5f, -1.0f, -1.5f, 3.0f, 7.0f, 3.0f), PartPose.offsetAndRotation((float)2.0f, (float)-13.0f, (float)0.0f, (float)0.0f, (float)0.0436f, (float)0.0436f));
        PartDefinition leftleglower = leftleg.addOrReplaceChild("leftleglower", CubeListBuilder.create().texOffs(24, 19).addBox(-1.495f, 0.0f, 0.0f, 3.0f, 7.0f, 3.0f).texOffs(80, 35).addBox(-2.0f, 1.0f, -0.5f, 4.0f, 6.0f, 4.0f), PartPose.offset((float)0.0f, (float)6.0f, (float)-1.5f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void prepareMobModel(Matango matango, float limbSwing, float limbSwingAmount, float partialTick) {
        super.prepareMobModel((Entity)matango, limbSwing, limbSwingAmount, partialTick);
        this.chest.visible = (Boolean)GaiaConfig.CLIENT.genderNeutral.get() == false && !matango.isBaby();
    }

    public void setupAnim(Matango matango, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.headeyes.visible = ageInTicks % 60.0f == 0.0f && limbSwingAmount <= 0.1f;
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.rightarm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.8f * limbSwingAmount * 0.5f;
        this.leftarm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.8f * limbSwingAmount * 0.5f;
        this.rightarm.zRot = 0.0f;
        this.leftarm.zRot = 0.0f;
        this.rightarm.zRot += Mth.cos((float)(ageInTicks * 0.09f)) * 0.025f + 0.025f + 0.1745329f;
        this.rightarm.xRot += Mth.sin((float)(ageInTicks * 0.067f)) * 0.025f;
        this.leftarm.zRot -= Mth.cos((float)(ageInTicks * 0.09f)) * 0.025f + 0.025f + 0.1745329f;
        this.leftarm.xRot -= Mth.sin((float)(ageInTicks * 0.067f)) * 0.025f;
        this.waist1.yRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.5f / 2.0f * limbSwingAmount;
        this.rightleg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.5f * limbSwingAmount;
        this.leftleg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.5f * limbSwingAmount;
        this.rightleg.yRot = 0.0f;
        this.leftleg.yRot = 0.0f;
        this.rightleg.zRot = -0.0349066f;
        this.leftleg.zRot = 0.0349066f;
        if (this.riding) {
            this.rightarm.xRot -= 0.62831855f;
            this.leftarm.xRot -= 0.62831855f;
            this.rightleg.xRot = -1.4137167f;
            this.rightleg.yRot = 0.31415927f;
            this.rightleg.zRot = 0.07853982f;
            this.leftleg.xRot = -1.4137167f;
            this.leftleg.yRot = -0.31415927f;
            this.leftleg.zRot = -0.07853982f;
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int unused) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay);
    }

    public ModelPart getHead() {
        return this.head;
    }

    private ModelPart getArm(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.leftarm : this.rightarm;
    }

    public void translateToHand(HumanoidArm arm, PoseStack poseStack) {
        poseStack.translate(0.0, 0.5, 0.0);
        this.getArm(arm).translateAndRotate(poseStack);
    }
}

