/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gaia.config.GaiaConfig;
import gaia.entity.Mermaid;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;

public class MermaidModel
extends EntityModel<Mermaid>
implements HeadedModel,
ArmedModel {
    private final ModelPart root;
    private final ModelPart bodytop;
    private final ModelPart head;
    private final ModelPart headeyes;
    private final ModelPart chest;
    private final ModelPart rightarm;
    private final ModelPart leftarm;
    private final ModelPart hair1;
    private final ModelPart hair2;
    private final ModelPart[] fins = new ModelPart[6];
    private final ModelPart fintail;

    public MermaidModel(ModelPart root) {
        this.root = root.getChild("mermaid");
        ModelPart bodybottom = this.root.getChild("bodybottom");
        this.bodytop = bodybottom.getChild("bodymiddle").getChild("bodytop");
        ModelPart neck = this.bodytop.getChild("neck");
        this.head = neck.getChild("head");
        this.headeyes = this.head.getChild("headeyes");
        this.hair1 = neck.getChild("hair1");
        this.hair2 = this.hair1.getChild("hair2");
        this.chest = this.bodytop.getChild("chest");
        this.leftarm = this.bodytop.getChild("leftarm");
        this.rightarm = this.bodytop.getChild("rightarm");
        for (int i = 0; i < this.fins.length; ++i) {
            int index = i + 1;
            this.fins[i] = index == 1 ? this.root.getChild("fin" + index) : this.fins[i - 1].getChild("fin" + index);
        }
        this.fintail = this.fins[5].getChild("fintail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition mermaid = partdefinition.addOrReplaceChild("mermaid", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)27.0f, (float)0.0f));
        PartDefinition bodybottom = mermaid.addOrReplaceChild("bodybottom", CubeListBuilder.create().texOffs(0, 30).addBox(-3.0f, -1.5f, -1.5f, 6.0f, 3.0f, 3.0f).texOffs(68, 7).addBox(-4.0f, -1.5f, -2.5f, 8.0f, 8.0f, 5.0f), PartPose.offset((float)0.0f, (float)-13.5f, (float)0.5f));
        PartDefinition bodymiddle = bodybottom.addOrReplaceChild("bodymiddle", CubeListBuilder.create().texOffs(0, 25).addBox(-2.0f, -2.5f, -2.0f, 4.0f, 3.0f, 2.0f).texOffs(0, 25).addBox(-0.5f, -2.0f, -2.1f, 1.0f, 2.0f, 0.0f), PartPose.offset((float)0.0f, (float)-1.5f, (float)1.0f));
        PartDefinition bodytop = bodymiddle.addOrReplaceChild("bodytop", CubeListBuilder.create().texOffs(0, 16).addBox(-2.5f, -6.0f, -2.5f, 5.0f, 6.0f, 3.0f), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition neck = bodytop.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(0, 12).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.offset((float)0.0f, (float)-6.0f, (float)-1.0f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -6.0f, -3.0f, 6.0f, 6.0f, 6.0f).texOffs(36, 0).addBox(-3.5f, -6.5f, -3.5f, 7.0f, 7.0f, 7.0f).texOffs(36, 37).addBox(-1.5f, -6.0f, 3.6f, 3.0f, 3.0f, 1.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("finright", CubeListBuilder.create().texOffs(36, 36).addBox(0.0f, -4.0f, 0.0f, 0.0f, 5.0f, 5.0f), PartPose.offsetAndRotation((float)-3.0f, (float)-2.0f, (float)-3.0f, (float)0.0f, (float)-0.5236f, (float)0.0f));
        head.addOrReplaceChild("finleft", CubeListBuilder.create().texOffs(36, 36).addBox(0.0f, -4.0f, 0.0f, 0.0f, 5.0f, 5.0f), PartPose.offsetAndRotation((float)3.0f, (float)-2.0f, (float)-3.0f, (float)0.0f, (float)0.5236f, (float)0.0f));
        head.addOrReplaceChild("headeyes", CubeListBuilder.create().texOffs(24, 0).addBox(-3.0f, -6.0f, -3.1f, 6.0f, 6.0f, 0.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("headhelmet", CubeListBuilder.create().texOffs(36, 46).addBox(-4.0f, -6.0f, -3.0f, 8.0f, 8.0f, 8.0f), PartPose.offsetAndRotation((float)0.0f, (float)-4.5f, (float)-1.5f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition hair1 = neck.addOrReplaceChild("hair1", CubeListBuilder.create().texOffs(36, 14).addBox(-4.0f, -6.0f, 1.0f, 8.0f, 8.0f, 3.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        hair1.addOrReplaceChild("hair2", CubeListBuilder.create().texOffs(36, 25).addBox(-4.5f, -1.0f, 1.5f, 9.0f, 9.0f, 3.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        bodytop.addOrReplaceChild("chest", CubeListBuilder.create().texOffs(0, 36).addBox(-2.6f, 0.0f, -2.0f, 2.0f, 2.0f, 2.0f).texOffs(0, 36).mirror().addBox(0.0f, 0.0f, -2.0f, 2.0f, 2.0f, 2.0f).mirror(false), PartPose.offsetAndRotation((float)0.3f, (float)-5.5f, (float)-2.5f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition rightarm = bodytop.addOrReplaceChild("rightarm", CubeListBuilder.create().texOffs(16, 12).addBox(-2.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f), PartPose.offset((float)-2.5f, (float)-4.5f, (float)-0.5f));
        rightarm.addOrReplaceChild("rightpauldron_r1", CubeListBuilder.create().texOffs(68, 0).addBox(-3.0f, -1.5f, -2.0f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3491f));
        rightarm.addOrReplaceChild("rightarmlower", CubeListBuilder.create().texOffs(16, 20).addBox(-1.005f, 0.0f, -2.0f, 2.0f, 6.0f, 2.0f), PartPose.offset((float)-1.0f, (float)5.0f, (float)1.0f));
        PartDefinition leftarm = bodytop.addOrReplaceChild("leftarm", CubeListBuilder.create().texOffs(16, 12).addBox(0.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f), PartPose.offset((float)2.5f, (float)-4.5f, (float)-0.5f));
        leftarm.addOrReplaceChild("leftpauldron_r1", CubeListBuilder.create().texOffs(68, 0).mirror().addBox(-1.0f, -1.5f, -2.0f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.25f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3491f));
        leftarm.addOrReplaceChild("leftarmlower", CubeListBuilder.create().texOffs(16, 20).addBox(-0.995f, 0.0f, -2.0f, 2.0f, 6.0f, 2.0f), PartPose.offset((float)1.0f, (float)5.0f, (float)1.0f));
        PartDefinition fin1 = mermaid.addOrReplaceChild("fin1", CubeListBuilder.create().texOffs(100, 0).addBox(-3.5f, -1.0f, -2.0f, 7.0f, 4.0f, 4.0f), PartPose.offset((float)0.0f, (float)-13.0f, (float)0.5f));
        PartDefinition fin2 = fin1.addOrReplaceChild("fin2", CubeListBuilder.create().texOffs(100, 8).addBox(-3.0f, 0.0f, 0.0f, 6.0f, 4.0f, 4.0f), PartPose.offset((float)0.0f, (float)3.0f, (float)-2.0f));
        PartDefinition fin3 = fin2.addOrReplaceChild("fin3", CubeListBuilder.create().texOffs(100, 16).addBox(-2.5f, 0.0f, 0.0f, 5.0f, 4.0f, 4.0f), PartPose.offset((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition fin4 = fin3.addOrReplaceChild("fin4", CubeListBuilder.create().texOffs(100, 24).addBox(-2.0f, 0.0f, 0.5f, 4.0f, 4.0f, 3.0f), PartPose.offset((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition fin5 = fin4.addOrReplaceChild("fin5", CubeListBuilder.create().texOffs(100, 31).addBox(-1.5f, 0.0f, 0.0f, 3.0f, 3.0f, 3.0f), PartPose.offset((float)0.0f, (float)4.0f, (float)0.5f));
        PartDefinition fin6 = fin5.addOrReplaceChild("fin6", CubeListBuilder.create().texOffs(100, 37).addBox(-1.0f, 0.0f, 0.5f, 2.0f, 2.0f, 2.0f), PartPose.offset((float)0.0f, (float)3.0f, (float)0.0f));
        fin6.addOrReplaceChild("fintail", CubeListBuilder.create().texOffs(100, 41).addBox(-3.5f, -1.0f, 0.0f, 7.0f, 7.0f, 0.0f), PartPose.offset((float)0.0f, (float)2.0f, (float)1.5f));
        fin2.addOrReplaceChild("fin2right", CubeListBuilder.create().texOffs(120, 5).addBox(0.0f, 0.0f, -1.5f, 0.0f, 3.0f, 3.0f), PartPose.offsetAndRotation((float)3.0f, (float)2.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)-0.5236f));
        fin2.addOrReplaceChild("fin2left", CubeListBuilder.create().texOffs(120, 5).addBox(0.0f, 0.0f, -1.5f, 0.0f, 3.0f, 3.0f), PartPose.offsetAndRotation((float)-3.0f, (float)2.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.5236f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void prepareMobModel(Mermaid mermaid, float limbSwing, float limbSwingAmount, float partialTick) {
        super.prepareMobModel((Entity)mermaid, limbSwing, limbSwingAmount, partialTick);
        this.chest.visible = (Boolean)GaiaConfig.CLIENT.genderNeutral.get() == false && !mermaid.isBaby();
    }

    public void setupAnim(Mermaid mermaid, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.headeyes.visible = ageInTicks % 60.0f == 0.0f && limbSwingAmount <= 0.1f;
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.hair1.yRot = this.head.yRot;
        this.hair1.xRot = this.head.xRot;
        this.hair2.xRot = this.head.xRot * 0.75f;
        this.rightarm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.8f * limbSwingAmount * 0.5f;
        this.leftarm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.8f * limbSwingAmount * 0.5f;
        this.rightarm.zRot = 0.0f;
        this.leftarm.zRot = 0.0f;
        if (this.attackTime > 0.0f) {
            this.holdingMelee();
        }
        this.rightarm.zRot += Mth.cos((float)(ageInTicks * 0.09f)) * 0.025f + 0.025f + 0.1745329f;
        this.rightarm.xRot += Mth.sin((float)(ageInTicks * 0.067f)) * 0.025f;
        this.leftarm.zRot -= Mth.cos((float)(ageInTicks * 0.09f)) * 0.025f + 0.025f + 0.1745329f;
        this.leftarm.xRot -= Mth.sin((float)(ageInTicks * 0.067f)) * 0.025f;
        this.fins[0].xRot = -0.1308997f;
        this.fins[1].xRot = 0.3926991f;
        this.fins[2].xRot = 0.3926991f;
        this.fins[3].xRot = 0.785398f;
        this.fintail.xRot = 0.3926991f;
        float usedValue = mermaid.isInWater() ? ageInTicks : limbSwing;
        this.fins[0].zRot = -0.1f * Mth.cos((float)(usedValue * 0.3f));
        this.fins[1].zRot = -0.1f * Mth.cos((float)(usedValue * 0.3f));
        this.fins[2].zRot = -0.1f * Mth.cos((float)(usedValue * 0.3f));
        this.fins[3].zRot = -0.1f * Mth.cos((float)(usedValue * 0.3f));
        this.fins[4].zRot = -0.1f * Mth.cos((float)(usedValue * 0.3f));
        this.fins[5].zRot = -0.1f * Mth.cos((float)(usedValue * 0.3f));
        this.fintail.zRot = -0.2f * Mth.cos((float)(usedValue * 0.3f));
    }

    public void holdingMelee() {
        float f6 = 1.0f - this.attackTime;
        f6 *= f6;
        f6 *= f6;
        f6 = 1.0f - f6;
        float f7 = Mth.sin((float)(f6 * (float)Math.PI));
        float f8 = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -(this.head.xRot - 0.7f) * 0.75f;
        this.rightarm.xRot = (float)((double)this.rightarm.xRot - ((double)f7 * 1.2 + (double)f8));
        this.rightarm.xRot += this.bodytop.yRot * 2.0f;
        this.rightarm.zRot = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -0.4f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int unused) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay);
    }

    public ModelPart getHead() {
        return this.head;
    }

    private ModelPart getArm(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.leftarm : this.rightarm;
    }

    public void translateToHand(HumanoidArm arm, PoseStack poseStack) {
        poseStack.translate(0.0, 0.5, 0.0625);
        this.getArm(arm).translateAndRotate(poseStack);
    }
}

