/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gaia.entity.Minotaur;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;

public class MinotaurModel
extends EntityModel<Minotaur>
implements HeadedModel,
ArmedModel {
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart leftarm;
    private final ModelPart rightarm;
    private final ModelPart leftarmlower;
    private final ModelPart rightarmlower;
    private final ModelPart leftleg;
    private final ModelPart rightleg;
    private final ModelPart[] righthorn = new ModelPart[5];
    private final ModelPart[] lefthorn = new ModelPart[5];

    public MinotaurModel(ModelPart root) {
        this.root = root.getChild("minotaur");
        ModelPart body3 = this.root.getChild("body3");
        ModelPart body2 = body3.getChild("body2");
        this.body = body2.getChild("body");
        this.head = this.body.getChild("head");
        this.leftarm = this.body.getChild("leftarm");
        this.rightarm = this.body.getChild("rightarm");
        this.leftarmlower = this.leftarm.getChild("leftarmlower");
        this.rightarmlower = this.rightarm.getChild("rightarmlower");
        this.leftleg = this.root.getChild("leftleg");
        this.rightleg = this.root.getChild("rightleg");
        for (int i = 0; i < 5; ++i) {
            int index = i + 1;
            if (index == 1) {
                this.righthorn[i] = this.head.getChild("righthorn" + index);
                this.lefthorn[i] = this.head.getChild("lefthorn" + index);
                continue;
            }
            this.righthorn[i] = this.righthorn[i - 1].getChild("righthorn" + index);
            this.lefthorn[i] = this.lefthorn[i - 1].getChild("lefthorn" + index);
        }
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition minotaur = partdefinition.addOrReplaceChild("minotaur", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body3 = minotaur.addOrReplaceChild("body3", CubeListBuilder.create().texOffs(0, 54).addBox(-4.0f, 16.0f, -1.0f, 8.0f, 5.0f, 5.0f).texOffs(66, 0).addBox(-4.5f, 16.0f, -1.5f, 9.0f, 8.0f, 6.0f), PartPose.offset((float)0.0f, (float)-36.0f, (float)0.0f));
        PartDefinition body2 = body3.addOrReplaceChild("body2", CubeListBuilder.create().texOffs(0, 43).addBox(-5.0f, -5.0f, -6.0f, 10.0f, 5.0f, 6.0f), PartPose.offsetAndRotation((float)0.0f, (float)16.0f, (float)4.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition body = body2.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 26).addBox(-6.0f, -9.0f, -8.0f, 12.0f, 9.0f, 8.0f).texOffs(88, 34).addBox(-6.0f, -9.0f, -8.0f, 12.0f, 9.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.offsetAndRotation((float)0.0f, (float)-5.0f, (float)0.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition neck = body.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(0, 15).addBox(-5.0f, -5.0f, -5.0f, 10.0f, 5.0f, 5.0f), PartPose.offsetAndRotation((float)0.0f, (float)-9.0f, (float)0.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.5f, -7.0f, -4.0f, 7.0f, 7.0f, 8.0f).texOffs(30, 0).addBox(-3.0f, -6.0f, -6.0f, 6.0f, 2.0f, 2.0f).texOffs(30, 4).addBox(-2.5f, -4.0f, -9.0f, 5.0f, 4.0f, 5.0f), PartPose.offsetAndRotation((float)0.0f, (float)-8.0f, (float)-8.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition neck_back_r1 = head.addOrReplaceChild("neck_back_r1", CubeListBuilder.create().texOffs(96, 22).addBox(-3.0f, 0.0f, 0.0f, 6.0f, 6.0f, 6.0f), PartPose.offsetAndRotation((float)0.0f, (float)-7.0f, (float)4.0f, (float)-1.0472f, (float)0.0f, (float)0.0f));
        PartDefinition righthorn1 = head.addOrReplaceChild("righthorn1", CubeListBuilder.create().texOffs(50, 0).addBox(-3.0f, 0.5f, -1.5f, 4.0f, 3.0f, 3.0f), PartPose.offsetAndRotation((float)-3.5f, (float)-8.5f, (float)-2.0f, (float)0.0f, (float)-0.3491f, (float)0.0f));
        PartDefinition righthorn2 = righthorn1.addOrReplaceChild("righthorn2", CubeListBuilder.create().texOffs(50, 6).addBox(-2.0f, -1.5f, -1.5f, 2.0f, 3.0f, 3.0f), PartPose.offsetAndRotation((float)-3.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)-0.3491f, (float)0.3491f));
        PartDefinition righthorn3 = righthorn2.addOrReplaceChild("righthorn3", CubeListBuilder.create().texOffs(50, 12).addBox(-2.0f, -1.5f, -1.5f, 2.0f, 3.0f, 3.0f), PartPose.offsetAndRotation((float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3491f, (float)0.3491f));
        PartDefinition righthorn4 = righthorn3.addOrReplaceChild("righthorn4", CubeListBuilder.create().texOffs(50, 18).addBox(-2.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3491f, (float)0.3491f));
        PartDefinition righthorn5 = righthorn4.addOrReplaceChild("righthorn5", CubeListBuilder.create().texOffs(58, 18).addBox(-1.0f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f), PartPose.offsetAndRotation((float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1745f, (float)0.3491f));
        PartDefinition lefthorn1 = head.addOrReplaceChild("lefthorn1", CubeListBuilder.create().texOffs(50, 0).mirror().addBox(-1.0f, 0.5f, -1.5f, 4.0f, 3.0f, 3.0f).mirror(false), PartPose.offsetAndRotation((float)3.5f, (float)-8.5f, (float)-2.0f, (float)0.0f, (float)0.3491f, (float)0.0f));
        PartDefinition lefthorn2 = lefthorn1.addOrReplaceChild("lefthorn2", CubeListBuilder.create().texOffs(50, 6).addBox(0.0f, -1.5f, -1.5f, 2.0f, 3.0f, 3.0f), PartPose.offsetAndRotation((float)3.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.3491f, (float)-0.3491f));
        PartDefinition lefthorn3 = lefthorn2.addOrReplaceChild("lefthorn3", CubeListBuilder.create().texOffs(50, 12).addBox(0.0f, -1.5f, -1.5f, 2.0f, 3.0f, 3.0f), PartPose.offsetAndRotation((float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3491f, (float)-0.3491f));
        PartDefinition lefthorn4 = lefthorn3.addOrReplaceChild("lefthorn4", CubeListBuilder.create().texOffs(50, 18).addBox(0.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3491f, (float)-0.3491f));
        PartDefinition lefthorn5 = lefthorn4.addOrReplaceChild("lefthorn5", CubeListBuilder.create().texOffs(58, 18).addBox(0.0f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f), PartPose.offsetAndRotation((float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1745f, (float)-0.3491f));
        PartDefinition nosering = head.addOrReplaceChild("nosering", CubeListBuilder.create().texOffs(30, 13).addBox(-2.0f, -0.5f, -0.5f, 4.0f, 4.0f, 1.0f), PartPose.offset((float)0.0f, (float)-1.0f, (float)-9.5f));
        PartDefinition rightarm = body.addOrReplaceChild("rightarm", CubeListBuilder.create().texOffs(50, 23).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 10.0f, 4.0f), PartPose.offsetAndRotation((float)-7.0f, (float)-6.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition rightarmlower = rightarm.addOrReplaceChild("rightarmlower", CubeListBuilder.create().texOffs(50, 37).addBox(-2.005f, 0.0f, -4.0f, 4.0f, 8.0f, 4.0f).texOffs(50, 49).addBox(-2.005f, 0.0f, -4.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.offsetAndRotation((float)-1.0f, (float)8.0f, (float)2.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition rightarmlowerchain_r1 = rightarmlower.addOrReplaceChild("rightarmlowerchain_r1", CubeListBuilder.create().texOffs(30, 18).addBox(-0.5f, 0.0f, -2.0f, 1.0f, 4.0f, 4.0f), PartPose.offsetAndRotation((float)-2.5f, (float)4.0f, (float)-2.0f, (float)0.3491f, (float)0.0f, (float)0.2618f));
        PartDefinition leftarm = body.addOrReplaceChild("leftarm", CubeListBuilder.create().texOffs(50, 23).mirror().addBox(-1.0f, -2.0f, -2.0f, 4.0f, 10.0f, 4.0f).mirror(false).texOffs(96, 0).addBox(-2.0f, -2.5f, -3.0f, 6.0f, 6.0f, 6.0f).texOffs(96, 12).mirror().addBox(-1.5f, 3.0f, -2.5f, 5.0f, 5.0f, 5.0f).mirror(false), PartPose.offsetAndRotation((float)7.0f, (float)-6.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition leftarmlower = leftarm.addOrReplaceChild("leftarmlower", CubeListBuilder.create().texOffs(50, 37).mirror().addBox(-1.995f, 0.0f, -4.0f, 4.0f, 8.0f, 4.0f).mirror(false).texOffs(50, 49).mirror().addBox(-1.995f, 0.0f, -4.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.5f)).mirror(false), PartPose.offsetAndRotation((float)1.0f, (float)8.0f, (float)2.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition leftarmlowerchain_r1 = leftarmlower.addOrReplaceChild("leftarmlowerchain_r1", CubeListBuilder.create().texOffs(30, 18).addBox(-0.5f, 0.0f, -2.0f, 1.0f, 4.0f, 4.0f), PartPose.offsetAndRotation((float)2.5f, (float)4.0f, (float)-2.0f, (float)0.3491f, (float)0.0f, (float)-0.2618f));
        PartDefinition rightleg = minotaur.addOrReplaceChild("rightleg", CubeListBuilder.create().texOffs(66, 14).addBox(-2.0f, -1.0f, -2.0f, 4.0f, 9.0f, 4.0f), PartPose.offsetAndRotation((float)-4.0f, (float)-17.0f, (float)2.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition rightleglower = rightleg.addOrReplaceChild("rightleglower", CubeListBuilder.create().texOffs(66, 27).addBox(-1.5f, -3.0f, 0.0f, 3.0f, 3.0f, 6.0f), PartPose.offsetAndRotation((float)0.0f, (float)8.0f, (float)-2.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition rightleglowerfoot = rightleglower.addOrReplaceChild("rightleglowerfoot", CubeListBuilder.create().texOffs(66, 36).addBox(-1.5f, 0.0f, -3.0f, 3.0f, 8.0f, 3.0f, new CubeDeformation(0.25f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)6.0f, (float)0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition rightfoot = rightleglowerfoot.addOrReplaceChild("rightfoot", CubeListBuilder.create().texOffs(66, 51).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 3.0f, 4.0f), PartPose.offsetAndRotation((float)0.0f, (float)6.0f, (float)-3.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition rightfoothoof = rightfoot.addOrReplaceChild("rightfoothoof", CubeListBuilder.create().texOffs(66, 47).addBox(-1.0f, 0.0f, 0.0f, 2.0f, 2.0f, 2.0f), PartPose.offset((float)0.0f, (float)1.0f, (float)2.0f));
        PartDefinition leftleg = minotaur.addOrReplaceChild("leftleg", CubeListBuilder.create().texOffs(66, 14).mirror().addBox(-2.0f, -1.0f, -2.0f, 4.0f, 9.0f, 4.0f).mirror(false), PartPose.offsetAndRotation((float)4.0f, (float)-17.0f, (float)2.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition leftleglower = leftleg.addOrReplaceChild("leftleglower", CubeListBuilder.create().texOffs(66, 27).mirror().addBox(-1.5f, -3.0f, 0.0f, 3.0f, 3.0f, 6.0f).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)8.0f, (float)-2.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition leftleglowerfoot = leftleglower.addOrReplaceChild("leftleglowerfoot", CubeListBuilder.create().texOffs(66, 36).mirror().addBox(-1.5f, 0.0f, -3.0f, 3.0f, 8.0f, 3.0f, new CubeDeformation(0.25f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)6.0f, (float)0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition leftfoot = leftleglowerfoot.addOrReplaceChild("leftfoot", CubeListBuilder.create().texOffs(66, 51).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 3.0f, 4.0f).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)6.0f, (float)-3.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition leftfoothoof = leftfoot.addOrReplaceChild("leftfoothoof", CubeListBuilder.create().texOffs(66, 47).addBox(-1.0f, 15.0f, 0.0f, 2.0f, 2.0f, 2.0f), PartPose.offset((float)0.0f, (float)-14.0f, (float)2.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void setupAnim(Minotaur minotaur, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.righthorn[1].yRot = -0.5235988f;
        this.righthorn[1].zRot = 0.5235988f;
        this.righthorn[2].yRot = -0.5235988f;
        this.righthorn[2].zRot = 0.5235988f;
        this.righthorn[3].yRot = -0.5235988f;
        this.righthorn[3].zRot = 0.2617994f;
        this.righthorn[4].yRot = -0.5235988f;
        this.righthorn[4].zRot = 0.2617994f;
        this.lefthorn[1].yRot = 0.5235988f;
        this.lefthorn[1].zRot = -0.5235988f;
        this.lefthorn[2].yRot = 0.5235988f;
        this.lefthorn[2].zRot = -0.5235988f;
        this.lefthorn[3].yRot = 0.5235988f;
        this.lefthorn[3].zRot = -0.2617994f;
        this.lefthorn[4].yRot = 0.5235988f;
        this.lefthorn[4].zRot = -0.2617994f;
        float armDefaultAngleX = 0.261799f;
        if (minotaur.getAnimationState() == 0) {
            this.rightarm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.8f * limbSwingAmount * 0.5f;
            this.leftarm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.8f * limbSwingAmount * 0.5f;
            this.rightarm.zRot = 0.0f;
            this.leftarm.zRot = 0.0f;
            if (this.attackTime > 0.0f) {
                this.holdingMelee();
            }
            this.rightarm.zRot += Mth.cos((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f + 0.1745329f;
            this.rightarm.xRot += Mth.sin((float)(ageInTicks * 0.067f)) * 0.05f;
            this.leftarm.zRot -= Mth.cos((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f + 0.1745329f;
            this.leftarm.xRot -= Mth.sin((float)(ageInTicks * 0.067f)) * 0.05f;
            this.rightarm.xRot = armDefaultAngleX;
            this.leftarm.xRot = armDefaultAngleX;
            this.rightarmlower.xRot = -armDefaultAngleX;
            this.leftarmlower.xRot = -armDefaultAngleX;
        } else if (minotaur.getAnimationState() == 1) {
            this.animationBuff();
        }
        this.rightleg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.8f * limbSwingAmount;
        this.leftleg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.8f * limbSwingAmount;
        this.rightleg.xRot -= 0.4363323f;
        this.leftleg.xRot -= 0.4363323f;
    }

    public void holdingMelee() {
        float f6 = 1.0f - this.attackTime;
        f6 *= f6;
        f6 *= f6;
        f6 = 1.0f - f6;
        float f7 = Mth.sin((float)(f6 * (float)Math.PI));
        float f8 = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -(this.head.xRot - 0.7f) * 0.75f;
        this.rightarm.xRot = (float)((double)this.rightarm.xRot - ((double)f7 * 1.2 + (double)f8));
        this.rightarm.xRot += this.body.yRot * 2.0f;
        this.rightarm.zRot = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -0.4f;
    }

    private void animationBuff() {
        float armDefaultAngleX = 0.785398f;
        this.rightarm.xRot = 0.0f;
        this.leftarm.xRot = 0.0f;
        this.rightarm.zRot = armDefaultAngleX;
        this.leftarm.zRot = -armDefaultAngleX;
        this.rightarm.xRot = armDefaultAngleX;
        this.leftarm.xRot = armDefaultAngleX;
        this.rightarmlower.xRot = -armDefaultAngleX;
        this.leftarmlower.xRot = -armDefaultAngleX;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int unused) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay);
    }

    public ModelPart getHead() {
        return this.head;
    }

    private ModelPart getArm(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.leftarm : this.rightarm;
    }

    public void translateToHand(HumanoidArm arm, PoseStack poseStack) {
        poseStack.translate(0.0, 0.3125, 0.0);
        this.getArm(arm).translateAndRotate(poseStack);
    }
}

