/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gaia.entity.Naga;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;

public class NagaModel
extends EntityModel<Naga>
implements HeadedModel,
ArmedModel {
    private static final double CYCLES_PER_BLOCK = 0.1;
    private final float[][] undulationCycle = new float[][]{{5.0f, 0.0f, -11.25f, -45.0f, -22.5f, 0.0f, 22.5f, 45.0f}, {10.0f, 10.0f, 0.0f, -22.5f, -45.0f, -22.5f, 0.0f, 22.5f}, {5.0f, 20.0f, 11.25f, 0.0f, -22.5f, -45.0f, -22.5f, 0.0f}, {0.0f, 10.0f, 22.5f, 22.5f, 0.0f, -22.5f, -45.0f, -22.5f}, {-5.0f, 0.0f, 11.25f, 45.0f, 22.5f, 0.0f, -22.5f, -45.0f}, {-10.0f, -10.0f, 0.0f, 22.5f, 45.0f, 22.5f, 0.0f, -22.5f}, {-5.0f, -20.0f, -11.25f, 0.0f, 22.5f, 45.0f, 22.5f, 0.0f}, {0.0f, -10.0f, -22.5f, -22.5f, 0.0f, 22.5f, 45.0f, 22.5f}};
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart rightarm;
    private final ModelPart rightarmlower;
    private final ModelPart leftarm;
    private final ModelPart leftarmlower;
    private final ModelPart[] tails = new ModelPart[8];

    public NagaModel(ModelPart root) {
        this.root = root.getChild("naga");
        this.body = this.root.getChild("waist").getChild("body");
        this.head = this.body.getChild("head");
        this.rightarm = this.body.getChild("rightarm");
        this.rightarmlower = this.rightarm.getChild("rightarmlower");
        this.leftarm = this.body.getChild("leftarm");
        this.leftarmlower = this.leftarm.getChild("leftarmlower");
        for (int i = 0; i < this.tails.length; ++i) {
            int index = i + 1;
            this.tails[i] = index == 1 ? this.root.getChild("tail" + index) : this.tails[i - 1].getChild("tail" + index);
        }
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition naga = partdefinition.addOrReplaceChild("naga", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition waist = naga.addOrReplaceChild("waist", CubeListBuilder.create().texOffs(68, 0).addBox(-4.5f, -5.0f, 0.0f, 9.0f, 5.0f, 5.0f), PartPose.offsetAndRotation((float)0.0f, (float)-17.0f, (float)-2.5f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition body = waist.addOrReplaceChild("body", CubeListBuilder.create().texOffs(34, 44).addBox(-5.5f, -9.0f, -3.0f, 11.0f, 9.0f, 6.0f).texOffs(104, 39).addBox(0.0f, -14.0f, -3.0f, 0.0f, 13.0f, 12.0f), PartPose.offset((float)0.0f, (float)-5.0f, (float)2.5f));
        body.addOrReplaceChild("body_r1", CubeListBuilder.create().texOffs(34, 14).addBox(-4.5f, -4.0f, -2.0f, 9.0f, 4.0f, 4.0f), PartPose.offsetAndRotation((float)0.0f, (float)-8.0f, (float)0.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -3.0f, -5.0f, 6.0f, 5.0f, 7.0f).texOffs(0, 46).addBox(0.0f, -8.0f, -5.0f, 0.0f, 5.0f, 6.0f), PartPose.offsetAndRotation((float)0.0f, (float)-10.0f, (float)-1.5f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition headnose = head.addOrReplaceChild("headnose", CubeListBuilder.create().texOffs(0, 17).addBox(-2.0f, 0.0f, -5.0f, 4.0f, 3.0f, 5.0f), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)-5.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        headnose.addOrReplaceChild("headbrowleft_r1", CubeListBuilder.create().texOffs(0, 12).addBox(-1.0f, -0.5f, -0.5f, 2.0f, 2.0f, 3.0f), PartPose.offsetAndRotation((float)1.5f, (float)0.0f, (float)-1.5f, (float)0.0f, (float)0.5236f, (float)0.0f));
        headnose.addOrReplaceChild("headbrowright_r1", CubeListBuilder.create().texOffs(0, 12).addBox(-1.0f, -0.5f, -0.5f, 2.0f, 2.0f, 3.0f), PartPose.offsetAndRotation((float)-1.5f, (float)0.0f, (float)-1.5f, (float)0.0f, (float)-0.5236f, (float)0.0f));
        head.addOrReplaceChild("headjaw", CubeListBuilder.create().texOffs(0, 25).addBox(-2.5f, -2.0f, -6.5f, 5.0f, 3.0f, 6.0f).texOffs(0, 34).addBox(-3.0f, -1.0f, -7.0f, 6.0f, 6.0f, 6.0f), PartPose.offset((float)0.0f, (float)2.0f, (float)-2.0f));
        head.addOrReplaceChild("rightfin", CubeListBuilder.create().texOffs(19, -5).addBox(0.0f, -2.5f, 0.0f, 0.0f, 5.0f, 5.0f), PartPose.offsetAndRotation((float)-3.0f, (float)-1.0f, (float)-4.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        head.addOrReplaceChild("leftfin", CubeListBuilder.create().texOffs(19, -5).addBox(0.0f, -2.5f, 0.0f, 0.0f, 5.0f, 5.0f), PartPose.offsetAndRotation((float)3.0f, (float)-1.0f, (float)-4.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition rightarm = body.addOrReplaceChild("rightarm", CubeListBuilder.create().texOffs(34, 22).addBox(-3.0f, -1.5f, -1.5f, 3.0f, 8.0f, 3.0f), PartPose.offsetAndRotation((float)-5.5f, (float)-6.0f, (float)0.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        rightarm.addOrReplaceChild("rightpauldron_r1", CubeListBuilder.create().texOffs(34, 0).addBox(-5.0f, -2.5f, -3.0f, 7.0f, 7.0f, 7.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        rightarm.addOrReplaceChild("rightarmlower", CubeListBuilder.create().texOffs(34, 33).addBox(-1.501f, 0.0f, -3.0f, 3.0f, 8.0f, 3.0f), PartPose.offset((float)-1.5f, (float)6.5f, (float)1.5f));
        PartDefinition leftarm = body.addOrReplaceChild("leftarm", CubeListBuilder.create().texOffs(34, 22).addBox(0.0f, -1.5f, -1.5f, 3.0f, 8.0f, 3.0f), PartPose.offsetAndRotation((float)5.5f, (float)-6.0f, (float)0.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        leftarm.addOrReplaceChild("leftpauldron_r1", CubeListBuilder.create().texOffs(34, 0).mirror().addBox(-2.0f, -2.5f, -3.0f, 7.0f, 7.0f, 7.0f).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        leftarm.addOrReplaceChild("leftarmlower", CubeListBuilder.create().texOffs(34, 33).addBox(-1.499f, 0.0f, -3.0f, 3.0f, 8.0f, 3.0f), PartPose.offset((float)1.5f, (float)6.5f, (float)1.5f));
        PartDefinition tail1 = naga.addOrReplaceChild("tail1", CubeListBuilder.create().texOffs(68, 10).addBox(-4.0f, 0.0f, 0.0f, 8.0f, 8.0f, 6.0f), PartPose.offset((float)0.0f, (float)-17.0f, (float)-2.5f));
        PartDefinition tail2 = tail1.addOrReplaceChild("tail2", CubeListBuilder.create().texOffs(68, 24).addBox(-3.5f, 0.0f, 0.0f, 7.0f, 7.0f, 6.0f), PartPose.offset((float)0.0f, (float)8.0f, (float)0.0f));
        PartDefinition tail3 = tail2.addOrReplaceChild("tail3", CubeListBuilder.create().texOffs(68, 37).addBox(-3.0f, 0.0f, 0.0f, 6.0f, 6.0f, 6.0f), PartPose.offset((float)0.0f, (float)7.0f, (float)0.0f));
        PartDefinition tail4 = tail3.addOrReplaceChild("tail4", CubeListBuilder.create().texOffs(68, 49).addBox(-2.5f, 0.0f, 0.5f, 5.0f, 5.0f, 5.0f), PartPose.offset((float)0.0f, (float)6.0f, (float)0.0f));
        PartDefinition tail5 = tail4.addOrReplaceChild("tail5", CubeListBuilder.create().texOffs(68, 49).addBox(-2.5f, 0.0f, 0.0f, 5.0f, 5.0f, 5.0f), PartPose.offset((float)0.0f, (float)5.0f, (float)0.5f));
        PartDefinition tail6 = tail5.addOrReplaceChild("tail6", CubeListBuilder.create().texOffs(96, 0).addBox(-2.0f, 0.0f, 0.5f, 4.0f, 4.0f, 4.0f), PartPose.offset((float)0.0f, (float)5.0f, (float)0.0f));
        PartDefinition tail7 = tail6.addOrReplaceChild("tail7", CubeListBuilder.create().texOffs(96, 0).addBox(-2.0f, 0.0f, 0.0f, 4.0f, 4.0f, 4.0f), PartPose.offset((float)0.0f, (float)4.0f, (float)0.5f));
        tail7.addOrReplaceChild("tail8", CubeListBuilder.create().texOffs(96, 8).addBox(-1.5f, 0.0f, 0.5f, 3.0f, 3.0f, 3.0f), PartPose.offset((float)0.0f, (float)4.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void setupAnim(Naga naga, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        float armDefaultAngleX = 0.261799f;
        if (naga.getAnimationState() == 0) {
            this.rightarm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.8f * limbSwingAmount * 0.5f;
            this.leftarm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.8f * limbSwingAmount * 0.5f;
            this.rightarm.zRot = 0.0f;
            this.leftarm.zRot = 0.0f;
            if (this.attackTime > 0.0f) {
                this.holdingMelee();
            }
            this.rightarm.zRot += Mth.cos((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f + 0.0872665f;
            this.rightarm.xRot += Mth.sin((float)(ageInTicks * 0.067f)) * 0.05f;
            this.leftarm.zRot -= Mth.cos((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f + 0.0872665f;
            this.leftarm.xRot -= Mth.sin((float)(ageInTicks * 0.067f)) * 0.05f;
            this.rightarm.xRot = armDefaultAngleX;
            this.leftarm.xRot = armDefaultAngleX;
            this.rightarmlower.xRot = -armDefaultAngleX;
            this.leftarmlower.xRot = -armDefaultAngleX;
        } else {
            this.animationBuff();
        }
        this.tails[0].xRot = -0.1308997f;
        this.tails[1].xRot = 0.3926991f;
        this.tails[2].xRot = 0.3926991f;
        this.tails[3].xRot = 0.785398f;
        this.tails[4].xRot = 0.1309f;
        this.tails[7].xRot = 0.3926991f;
        int cycleIndex = (int)((double)limbSwing * 0.1 % (double)this.undulationCycle.length);
        this.tails[4].zRot = 0.15f * Mth.cos((float)(limbSwing * ((float)Math.PI / 180 * this.undulationCycle[cycleIndex][4])));
        this.tails[5].zRot = 0.15f * Mth.cos((float)(limbSwing * ((float)Math.PI / 180 * this.undulationCycle[cycleIndex][5])));
        this.tails[6].zRot = 0.15f * Mth.cos((float)(limbSwing * ((float)Math.PI / 180 * this.undulationCycle[cycleIndex][6])));
        this.tails[7].zRot = 0.15f * Mth.cos((float)(limbSwing * ((float)Math.PI / 180 * this.undulationCycle[cycleIndex][7])));
    }

    public void holdingMelee() {
        float f6 = 1.0f - this.attackTime;
        f6 *= f6;
        f6 *= f6;
        f6 = 1.0f - f6;
        float f7 = Mth.sin((float)(f6 * (float)Math.PI));
        float f8 = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -(this.head.xRot - 0.7f) * 0.75f;
        this.rightarm.xRot = (float)((double)this.rightarm.xRot - ((double)f7 * 1.2 + (double)f8));
        this.rightarm.xRot += this.body.yRot * 2.0f;
        this.rightarm.zRot = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -0.4f;
    }

    private void animationBuff() {
        float armDefaultAngleX = 0.785398f;
        this.rightarm.xRot = 0.0f;
        this.leftarm.xRot = 0.0f;
        this.rightarm.zRot = armDefaultAngleX;
        this.leftarm.zRot = -armDefaultAngleX;
        this.rightarm.xRot = armDefaultAngleX;
        this.leftarm.xRot = armDefaultAngleX;
        this.rightarmlower.xRot = -armDefaultAngleX;
        this.leftarmlower.xRot = -armDefaultAngleX;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int unused) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay);
    }

    public ModelPart getHead() {
        return this.head;
    }

    private ModelPart getArm(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.leftarm : this.rightarm;
    }

    public void translateToHand(HumanoidArm arm, PoseStack poseStack) {
        poseStack.translate(-0.125, 0.5, 0.0);
        if (arm == HumanoidArm.LEFT) {
            poseStack.translate(0.125, 0.0, 0.0625);
        }
        this.getArm(arm).translateAndRotate(poseStack);
    }
}

