/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gaia.config.GaiaConfig;
import gaia.entity.Siren;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.BowItem;

public class SirenModel
extends EntityModel<Siren>
implements HeadedModel,
ArmedModel {
    private static final double CYCLES_PER_BLOCK = 0.1;
    private final float[][] undulationCycle = new float[][]{{5.0f, 0.0f, -11.25f, -45.0f, -22.5f, 0.0f, 22.5f, 45.0f}, {10.0f, 10.0f, 0.0f, -22.5f, -45.0f, -22.5f, 0.0f, 22.5f}, {5.0f, 20.0f, 11.25f, 0.0f, -22.5f, -45.0f, -22.5f, 0.0f}, {0.0f, 10.0f, 22.5f, 22.5f, 0.0f, -22.5f, -45.0f, -22.5f}, {-5.0f, 0.0f, 11.25f, 45.0f, 22.5f, 0.0f, -22.5f, -45.0f}, {-10.0f, -10.0f, 0.0f, 22.5f, 45.0f, 22.5f, 0.0f, -22.5f}, {-5.0f, -20.0f, -11.25f, 0.0f, 22.5f, 45.0f, 22.5f, 0.0f}, {0.0f, -10.0f, -22.5f, -22.5f, 0.0f, 22.5f, 45.0f, 22.5f}};
    private final ModelPart root;
    private final ModelPart bodytop;
    private final ModelPart head;
    private final ModelPart headeyes;
    private final ModelPart hair1;
    private final ModelPart hair2;
    private final ModelPart chest;
    private final ModelPart leftarm;
    private final ModelPart rightarm;
    private final ModelPart leftarmextra;
    private final ModelPart rightarmextra;
    private final ModelPart leftarmextralower;
    private final ModelPart rightarmextralower;
    private final ModelPart[] tails = new ModelPart[8];

    public SirenModel(ModelPart root) {
        this.root = root.getChild("siren");
        ModelPart bodybottom = this.root.getChild("bodybottom");
        this.bodytop = bodybottom.getChild("bodymiddle").getChild("bodytop");
        ModelPart neck = this.bodytop.getChild("neck");
        this.head = neck.getChild("head");
        this.headeyes = this.head.getChild("headeyes");
        this.hair1 = neck.getChild("hair1");
        this.hair2 = this.hair1.getChild("hair2");
        this.chest = this.bodytop.getChild("chest");
        this.leftarm = this.bodytop.getChild("leftarm");
        this.rightarm = this.bodytop.getChild("rightarm");
        this.leftarmextra = this.bodytop.getChild("leftarmextra");
        this.rightarmextra = this.bodytop.getChild("rightarmextra");
        this.leftarmextralower = this.leftarmextra.getChild("leftarmextralower");
        this.rightarmextralower = this.rightarmextra.getChild("rightarmextralower");
        for (int i = 0; i < this.tails.length; ++i) {
            int index = i + 1;
            this.tails[i] = index == 1 ? this.root.getChild("tail" + index) : this.tails[i - 1].getChild("tail" + index);
        }
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition siren = partdefinition.addOrReplaceChild("siren", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)27.0f, (float)0.0f));
        PartDefinition bodybottom = siren.addOrReplaceChild("bodybottom", CubeListBuilder.create().texOffs(0, 30).addBox(-3.0f, -1.5f, -1.5f, 6.0f, 3.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)-13.5f, (float)0.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition bodymiddle = bodybottom.addOrReplaceChild("bodymiddle", CubeListBuilder.create().texOffs(0, 25).addBox(-2.0f, -2.5f, -1.45f, 4.0f, 3.0f, 2.0f).texOffs(0, 25).addBox(-0.5f, -2.0f, -1.55f, 1.0f, 2.0f, 0.0f), PartPose.offsetAndRotation((float)0.0f, (float)-1.5f, (float)0.45f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition bodytop = bodymiddle.addOrReplaceChild("bodytop", CubeListBuilder.create().texOffs(0, 16).addBox(-2.5f, -6.0f, -2.5f, 5.0f, 6.0f, 3.0f).texOffs(36, 42).addBox(-4.5f, -6.0f, -3.0f, 9.0f, 5.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)0.55f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition neck = bodytop.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(0, 12).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)-6.0f, (float)-1.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -6.0f, -3.0f, 6.0f, 6.0f, 6.0f).texOffs(36, 0).addBox(-3.5f, -6.5f, -3.5f, 7.0f, 7.0f, 7.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition headeyes = head.addOrReplaceChild("headeyes", CubeListBuilder.create().texOffs(24, 0).addBox(-3.0f, -6.0f, -3.1f, 6.0f, 6.0f, 0.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition finright = head.addOrReplaceChild("finright", CubeListBuilder.create().texOffs(36, 32).addBox(0.0f, -3.0f, 0.0f, 0.0f, 5.0f, 5.0f), PartPose.offsetAndRotation((float)-3.0f, (float)-3.0f, (float)-2.5f, (float)0.0f, (float)-0.5236f, (float)0.0f));
        PartDefinition finleft = head.addOrReplaceChild("finleft", CubeListBuilder.create().texOffs(36, 32).addBox(0.0f, -3.0f, 0.0f, 0.0f, 5.0f, 5.0f), PartPose.offsetAndRotation((float)3.0f, (float)-3.0f, (float)-2.5f, (float)0.0f, (float)0.5236f, (float)0.0f));
        PartDefinition hair1 = neck.addOrReplaceChild("hair1", CubeListBuilder.create().texOffs(36, 14).addBox(-4.0f, -6.0f, 1.0f, 8.0f, 8.0f, 3.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition hair2 = hair1.addOrReplaceChild("hair2", CubeListBuilder.create().texOffs(36, 25).addBox(-4.5f, -1.0f, -1.5f, 9.0f, 9.0f, 3.0f), PartPose.offset((float)0.0f, (float)1.0f, (float)3.0f));
        PartDefinition chest = bodytop.addOrReplaceChild("chest", CubeListBuilder.create().texOffs(0, 36).addBox(-2.3f, 0.0f, -2.0f, 2.0f, 2.0f, 2.0f).texOffs(0, 36).mirror().addBox(0.3f, 0.0f, -2.0f, 2.0f, 2.0f, 2.0f).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-5.5f, (float)-2.5f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition rightarm = bodytop.addOrReplaceChild("rightarm", CubeListBuilder.create().texOffs(16, 36).addBox(-2.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f), PartPose.offsetAndRotation((float)-2.5f, (float)-4.5f, (float)-0.5f, (float)0.0873f, (float)0.0f, (float)0.3491f));
        PartDefinition rightarmlower = rightarm.addOrReplaceChild("rightarmlower", CubeListBuilder.create().texOffs(16, 44).addBox(-1.005f, 0.0f, -2.0f, 2.0f, 6.0f, 2.0f), PartPose.offset((float)-1.0f, (float)5.0f, (float)1.0f));
        PartDefinition leftarm = bodytop.addOrReplaceChild("leftarm", CubeListBuilder.create().texOffs(16, 12).addBox(0.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f), PartPose.offsetAndRotation((float)2.5f, (float)-4.5f, (float)-0.5f, (float)0.0873f, (float)0.0f, (float)-0.3491f));
        PartDefinition leftarmlower = leftarm.addOrReplaceChild("leftarmlower", CubeListBuilder.create().texOffs(16, 20).addBox(-1.0f, 0.0f, -2.0f, 2.0f, 6.0f, 2.0f), PartPose.offset((float)1.005f, (float)5.0f, (float)1.0f));
        PartDefinition rightarmextra = bodytop.addOrReplaceChild("rightarmextra", CubeListBuilder.create().texOffs(24, 36).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f), PartPose.offsetAndRotation((float)-2.5f, (float)-3.5f, (float)0.5f, (float)0.2618f, (float)0.0f, (float)0.1745f));
        PartDefinition rightarmextralower = rightarmextra.addOrReplaceChild("rightarmextralower", CubeListBuilder.create().texOffs(24, 44).addBox(-1.005f, 0.0f, -2.0f, 2.0f, 6.0f, 2.0f), PartPose.offset((float)0.0f, (float)5.0f, (float)1.0f));
        PartDefinition leftarmextra = bodytop.addOrReplaceChild("leftarmextra", CubeListBuilder.create().texOffs(24, 12).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f), PartPose.offsetAndRotation((float)2.5f, (float)-3.5f, (float)0.5f, (float)0.2618f, (float)0.0f, (float)-0.1745f));
        PartDefinition leftarmextralower = leftarmextra.addOrReplaceChild("leftarmextralower", CubeListBuilder.create().texOffs(24, 20).addBox(-0.995f, 0.0f, -2.0f, 2.0f, 6.0f, 2.0f), PartPose.offset((float)0.0f, (float)5.0f, (float)1.0f));
        PartDefinition tail1 = siren.addOrReplaceChild("tail1", CubeListBuilder.create().texOffs(64, 0).addBox(-3.5f, -1.0f, -2.5f, 7.0f, 4.0f, 4.0f), PartPose.offset((float)0.0f, (float)-13.0f, (float)0.5f));
        PartDefinition tail2 = tail1.addOrReplaceChild("tail2", CubeListBuilder.create().texOffs(64, 8).addBox(-3.0f, 0.0f, 0.0f, 6.0f, 4.0f, 4.0f), PartPose.offset((float)0.0f, (float)3.0f, (float)-2.5f));
        PartDefinition tail3 = tail2.addOrReplaceChild("tail3", CubeListBuilder.create().texOffs(64, 16).addBox(-2.5f, 0.0f, 0.0f, 5.0f, 4.0f, 4.0f), PartPose.offset((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition tail4 = tail3.addOrReplaceChild("tail4", CubeListBuilder.create().texOffs(64, 16).addBox(-2.5f, 0.0f, 0.0f, 5.0f, 4.0f, 4.0f), PartPose.offset((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition tail5 = tail4.addOrReplaceChild("tail5", CubeListBuilder.create().texOffs(64, 24).addBox(-2.0f, 0.0f, 0.5f, 4.0f, 4.0f, 3.0f), PartPose.offset((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition tail6 = tail5.addOrReplaceChild("tail6", CubeListBuilder.create().texOffs(64, 24).addBox(-2.0f, 0.0f, 0.0f, 4.0f, 4.0f, 3.0f), PartPose.offset((float)0.0f, (float)4.0f, (float)0.5f));
        PartDefinition tail7 = tail6.addOrReplaceChild("tail7", CubeListBuilder.create().texOffs(64, 31).addBox(-1.5f, 0.0f, 0.5f, 3.0f, 3.0f, 2.0f), PartPose.offset((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition tail8 = tail7.addOrReplaceChild("tail8", CubeListBuilder.create().texOffs(64, 36).addBox(-1.0f, 0.0f, 0.0f, 2.0f, 2.0f, 2.0f), PartPose.offset((float)0.0f, (float)3.0f, (float)0.5f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void prepareMobModel(Siren siren, float limbSwing, float limbSwingAmount, float partialTick) {
        super.prepareMobModel((Entity)siren, limbSwing, limbSwingAmount, partialTick);
        this.chest.visible = (Boolean)GaiaConfig.CLIENT.genderNeutral.get() == false && !siren.isBaby();
    }

    public void setupAnim(Siren siren, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.headeyes.visible = ageInTicks % 60.0f == 0.0f && limbSwingAmount <= 0.1f;
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.hair1.yRot = this.head.yRot;
        this.hair1.xRot = this.head.xRot;
        this.hair2.xRot = this.head.xRot * 0.75f;
        float armextraDefaultAngleX = 0.261799f;
        this.rightarm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.8f * limbSwingAmount * 0.5f;
        this.leftarm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.8f * limbSwingAmount * 0.5f;
        this.rightarm.zRot = 0.0f;
        this.leftarm.zRot = 0.0f;
        if (siren.isAggressive() && siren.getMainHandItem().getItem() instanceof BowItem) {
            this.holdingBow(ageInTicks);
        } else if (this.attackTime > 0.0f) {
            this.holdingMelee();
        }
        this.rightarm.zRot += Mth.cos((float)(ageInTicks * 0.09f)) * 0.025f + 0.025f + 0.4363323f;
        this.rightarm.xRot += Mth.sin((float)(ageInTicks * 0.067f)) * 0.025f;
        this.leftarm.zRot -= Mth.cos((float)(ageInTicks * 0.09f)) * 0.025f + 0.025f + 0.4363323f;
        this.leftarm.xRot -= Mth.sin((float)(ageInTicks * 0.067f)) * 0.025f;
        this.rightarmextra.zRot = armextraDefaultAngleX;
        this.leftarmextra.zRot = -armextraDefaultAngleX;
        this.rightarmextra.xRot = armextraDefaultAngleX;
        this.leftarmextra.xRot = armextraDefaultAngleX;
        this.rightarmextralower.xRot = -armextraDefaultAngleX;
        this.leftarmextralower.xRot = -armextraDefaultAngleX;
        this.tails[0].xRot = -0.1308997f;
        this.tails[1].xRot = 0.3926991f;
        this.tails[2].xRot = 0.3926991f;
        this.tails[3].xRot = 0.785398f;
        this.tails[7].xRot = 0.3926991f;
        int cycleIndex = (int)((double)limbSwing * 0.1 % (double)this.undulationCycle.length);
        this.tails[4].zRot = 0.3f * Mth.cos((float)(limbSwing * ((float)Math.PI / 180 * this.undulationCycle[cycleIndex][4])));
        this.tails[5].zRot = 0.3f * Mth.cos((float)(limbSwing * ((float)Math.PI / 180 * this.undulationCycle[cycleIndex][5])));
        this.tails[6].zRot = 0.3f * Mth.cos((float)(limbSwing * ((float)Math.PI / 180 * this.undulationCycle[cycleIndex][6])));
        this.tails[7].zRot = 0.3f * Mth.cos((float)(limbSwing * ((float)Math.PI / 180 * this.undulationCycle[cycleIndex][7])));
    }

    private void holdingBow(float ageInTicks) {
        float f = Mth.sin((float)(this.attackTime * (float)Math.PI));
        float f1 = Mth.sin((float)((1.0f - (1.0f - this.attackTime) * (1.0f - this.attackTime)) * (float)Math.PI));
        this.rightarm.zRot = -0.3f;
        this.leftarm.zRot = 0.3f;
        this.rightarm.yRot = -(0.1f - f * 0.6f);
        this.leftarm.yRot = 0.3f - f * 0.6f;
        this.rightarm.xRot = -1.5707964f;
        this.leftarm.xRot = -1.5707964f;
        this.rightarm.xRot -= f * 1.2f - f1 * 0.4f;
        this.leftarm.xRot -= f * 1.2f - f1 * 0.4f;
        this.rightarm.zRot += Mth.cos((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
        this.leftarm.zRot -= Mth.cos((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
        this.rightarm.xRot += Mth.sin((float)(ageInTicks * 0.067f)) * 0.05f;
        this.leftarm.xRot -= Mth.sin((float)(ageInTicks * 0.067f)) * 0.05f;
    }

    public void holdingMelee() {
        float f6 = 1.0f - this.attackTime;
        f6 *= f6;
        f6 *= f6;
        f6 = 1.0f - f6;
        float f7 = Mth.sin((float)(f6 * (float)Math.PI));
        float f8 = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -(this.head.xRot - 0.7f) * 0.75f;
        this.rightarm.xRot = (float)((double)this.rightarm.xRot - ((double)f7 * 1.2 + (double)f8));
        this.rightarm.xRot += this.bodytop.yRot * 2.0f;
        this.rightarm.zRot = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -0.4f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int unused) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay);
    }

    public ModelPart getHead() {
        return this.head;
    }

    private ModelPart getArm(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.leftarm : this.rightarm;
    }

    public void translateToHand(HumanoidArm arm, PoseStack poseStack) {
        poseStack.translate(-0.125, 0.5, 0.0);
        if (arm == HumanoidArm.LEFT) {
            poseStack.translate(0.125, 0.0, 0.0625);
        }
        this.getArm(arm).translateAndRotate(poseStack);
    }
}

