/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gaia.config.GaiaConfig;
import gaia.entity.Sphinx;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class SphinxModel
extends EntityModel<Sphinx>
implements HeadedModel {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart headeyes;
    private final ModelPart chest;
    private final ModelPart rightarm;
    private final ModelPart leftarm;
    private final ModelPart rightwing;
    private final ModelPart leftwing;
    private final ModelPart rightleg;
    private final ModelPart leftleg;
    private final ModelPart tail;

    public SphinxModel(ModelPart root) {
        this.root = root.getChild("sphinx");
        ModelPart body3 = this.root.getChild("body3");
        this.tail = body3.getChild("tail");
        ModelPart body1 = body3.getChild("body2").getChild("body1");
        ModelPart neck = body1.getChild("neck");
        this.head = neck.getChild("head");
        this.headeyes = this.head.getChild("headeyes");
        this.chest = body1.getChild("chest");
        this.rightarm = body1.getChild("rightarm");
        this.leftarm = body1.getChild("leftarm");
        this.rightwing = body1.getChild("rightwing");
        this.leftwing = body1.getChild("leftwing");
        this.rightleg = body3.getChild("rightleg");
        this.leftleg = body3.getChild("leftleg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition sphinx = partdefinition.addOrReplaceChild("sphinx", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body3 = sphinx.addOrReplaceChild("body3", CubeListBuilder.create().texOffs(66, 15).addBox(-3.0f, 3.0f, -8.0f, 6.0f, 10.0f, 7.0f), PartPose.offsetAndRotation((float)0.0f, (float)-16.0f, (float)-3.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition body2 = body3.addOrReplaceChild("body2", CubeListBuilder.create().texOffs(66, 0).addBox(-3.5f, -7.0f, 0.0f, 7.0f, 7.0f, 8.0f), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)-8.5f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition body1 = body2.addOrReplaceChild("body1", CubeListBuilder.create().texOffs(0, 16).addBox(-2.5f, -6.0f, 0.0f, 5.0f, 6.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)-7.0f, (float)0.0f, (float)-0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition neck = body1.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(0, 12).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)-6.0f, (float)1.5f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -6.5f, -3.0f, 6.0f, 6.0f, 6.0f).texOffs(36, 0).addBox(-3.5f, -7.0f, -3.5f, 7.0f, 7.0f, 7.0f).texOffs(36, 21).addBox(-4.0f, -5.5f, -2.0f, 8.0f, 6.0f, 6.0f).texOffs(36, 33).addBox(-1.0f, -8.0f, -4.6f, 2.0f, 3.0f, 1.0f), PartPose.offset((float)0.0f, (float)0.5f, (float)0.0f));
        PartDefinition headeyes = head.addOrReplaceChild("headeyes", CubeListBuilder.create().texOffs(24, 0).addBox(-3.0f, -6.5f, -3.1f, 6.0f, 6.0f, 0.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftear = head.addOrReplaceChild("leftear", CubeListBuilder.create().texOffs(36, 14).mirror().addBox(1.5f, -10.5f, -1.5f, 3.0f, 4.0f, 3.0f).mirror(false), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightear = head.addOrReplaceChild("rightear", CubeListBuilder.create().texOffs(36, 14).addBox(-4.5f, -10.5f, -1.5f, 3.0f, 4.0f, 3.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition chest = body1.addOrReplaceChild("chest", CubeListBuilder.create().texOffs(0, 25).addBox(-1.0f, 0.0f, -2.0f, 2.0f, 2.0f, 2.0f).texOffs(0, 25).mirror().addBox(1.6f, 0.0f, -2.0f, 2.0f, 2.0f, 2.0f).mirror(false), PartPose.offsetAndRotation((float)-1.3f, (float)-5.5f, (float)0.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition rightarm = body1.addOrReplaceChild("rightarm", CubeListBuilder.create().texOffs(18, 12).addBox(-1.5f, 0.0f, -1.5f, 2.0f, 8.0f, 2.0f), PartPose.offsetAndRotation((float)-3.0f, (float)-5.5f, (float)2.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition rightarmlower = rightarm.addOrReplaceChild("rightarmlower", CubeListBuilder.create().texOffs(18, 22).addBox(-1.005f, 0.0f, -2.0f, 2.0f, 7.0f, 3.0f).texOffs(36, 37).addBox(-2.005f, 4.0f, -2.5f, 4.0f, 2.0f, 4.0f), PartPose.offsetAndRotation((float)-0.5f, (float)8.0f, (float)0.5f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition righthand = rightarmlower.addOrReplaceChild("righthand", CubeListBuilder.create().texOffs(18, 32).addBox(-1.505f, 0.0f, -2.5f, 3.0f, 2.0f, 3.0f), PartPose.offset((float)0.0f, (float)6.0f, (float)-1.5f));
        PartDefinition leftarm = body1.addOrReplaceChild("leftarm", CubeListBuilder.create().texOffs(18, 12).mirror().addBox(0.0f, 0.0f, -1.5f, 2.0f, 8.0f, 2.0f).mirror(false), PartPose.offsetAndRotation((float)2.5f, (float)-5.5f, (float)2.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition leftarmlower = leftarm.addOrReplaceChild("leftarmlower", CubeListBuilder.create().texOffs(18, 22).addBox(-0.995f, 0.0f, -2.0f, 2.0f, 7.0f, 3.0f).texOffs(36, 37).mirror().addBox(-1.995f, 4.0f, -2.5f, 4.0f, 2.0f, 4.0f).mirror(false), PartPose.offsetAndRotation((float)1.0f, (float)8.0f, (float)0.5f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition lefthand = leftarmlower.addOrReplaceChild("lefthand", CubeListBuilder.create().texOffs(18, 32).mirror().addBox(-1.495f, 0.0f, -2.5f, 3.0f, 2.0f, 3.0f).mirror(false), PartPose.offset((float)0.0f, (float)6.0f, (float)-1.5f));
        PartDefinition rightwing = body1.addOrReplaceChild("rightwing", CubeListBuilder.create().texOffs(104, 36).addBox(0.0f, -1.0f, -1.0f, 0.0f, 16.0f, 12.0f), PartPose.offsetAndRotation((float)-3.5f, (float)-5.0f, (float)4.0f, (float)0.8727f, (float)-0.5236f, (float)-0.2618f));
        PartDefinition leftwing = body1.addOrReplaceChild("leftwing", CubeListBuilder.create().texOffs(104, 36).addBox(0.0f, -1.0f, -1.0f, 0.0f, 16.0f, 12.0f), PartPose.offsetAndRotation((float)3.5f, (float)-5.0f, (float)4.0f, (float)0.8727f, (float)0.5236f, (float)0.2618f));
        PartDefinition tail = body3.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(66, 32).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 12.0f, 1.0f), PartPose.offset((float)0.0f, (float)13.0f, (float)-2.0f));
        PartDefinition rightleg = body3.addOrReplaceChild("rightleg", CubeListBuilder.create().texOffs(96, 0).addBox(-1.5f, 0.0f, -3.0f, 3.0f, 8.0f, 6.0f), PartPose.offsetAndRotation((float)-3.0f, (float)11.0f, (float)-1.0f, (float)-2.0944f, (float)0.0f, (float)0.0f));
        PartDefinition rightleglower = rightleg.addOrReplaceChild("rightleglower", CubeListBuilder.create().texOffs(96, 14).addBox(-1.0f, 0.0f, -6.0f, 2.0f, 3.0f, 6.0f), PartPose.offsetAndRotation((float)0.0f, (float)8.0f, (float)-3.0f, (float)2.618f, (float)0.0f, (float)0.0f));
        PartDefinition rightleglower2 = rightleglower.addOrReplaceChild("rightleglower2", CubeListBuilder.create().texOffs(96, 23).addBox(-1.0f, -1.0f, -3.0f, 2.0f, 6.0f, 3.0f).texOffs(36, 37).addBox(-2.0f, 2.0f, -3.5f, 4.0f, 2.0f, 4.0f), PartPose.offsetAndRotation((float)-0.1f, (float)3.0f, (float)-6.0f, (float)-2.0944f, (float)0.0f, (float)0.0f));
        PartDefinition rightfoot = rightleglower2.addOrReplaceChild("rightfoot", CubeListBuilder.create().texOffs(96, 32).addBox(-1.5f, 0.0f, -2.5f, 3.0f, 2.0f, 3.0f), PartPose.offset((float)0.0f, (float)4.0f, (float)-2.5f));
        PartDefinition leftleg = body3.addOrReplaceChild("leftleg", CubeListBuilder.create().texOffs(96, 0).addBox(-1.5f, 0.0f, -3.0f, 3.0f, 8.0f, 6.0f), PartPose.offsetAndRotation((float)3.0f, (float)11.0f, (float)-1.0f, (float)-2.0944f, (float)0.0f, (float)0.0f));
        PartDefinition leftleglower = leftleg.addOrReplaceChild("leftleglower", CubeListBuilder.create().texOffs(96, 14).addBox(-1.0f, 0.0f, -6.0f, 2.0f, 3.0f, 6.0f), PartPose.offsetAndRotation((float)0.0f, (float)8.0f, (float)-3.0f, (float)2.618f, (float)0.0f, (float)0.0f));
        PartDefinition leftleglower2 = leftleglower.addOrReplaceChild("leftleglower2", CubeListBuilder.create().texOffs(96, 23).addBox(-1.0f, -1.0f, -3.0f, 2.0f, 6.0f, 3.0f).texOffs(36, 37).addBox(-2.0f, 2.0f, -3.5f, 4.0f, 2.0f, 4.0f), PartPose.offsetAndRotation((float)0.1f, (float)3.0f, (float)-6.0f, (float)-2.0944f, (float)0.0f, (float)0.0f));
        PartDefinition leftfoot = leftleglower2.addOrReplaceChild("leftfoot", CubeListBuilder.create().texOffs(96, 32).addBox(-1.5f, 0.0f, -2.5f, 3.0f, 2.0f, 3.0f), PartPose.offset((float)0.0f, (float)4.0f, (float)-2.5f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void prepareMobModel(Sphinx sphinx, float limbSwing, float limbSwingAmount, float partialTick) {
        super.prepareMobModel((Entity)sphinx, limbSwing, limbSwingAmount, partialTick);
        this.chest.visible = (Boolean)GaiaConfig.CLIENT.genderNeutral.get() == false && !sphinx.isBaby();
    }

    public void setupAnim(Sphinx sphinx, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.headeyes.visible = ageInTicks % 60.0f == 0.0f && limbSwingAmount <= 0.1f;
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.rightarm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.8f * limbSwingAmount;
        this.leftarm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.8f * limbSwingAmount;
        this.rightwing.yRot = Mth.cos((float)(ageInTicks * 0.6662f + (float)Math.PI)) * 1.0f * limbSwingAmount * 0.5f;
        this.leftwing.yRot = Mth.cos((float)(ageInTicks * 0.6662f)) * 1.0f * limbSwingAmount * 0.5f;
        this.rightwing.yRot -= 0.5235988f;
        this.leftwing.yRot += 0.5235988f;
        this.tail.yRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.5f * limbSwingAmount;
        this.rightleg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.8f * limbSwingAmount;
        this.leftleg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.8f * limbSwingAmount;
        this.rightleg.xRot -= 1.9f;
        this.leftleg.xRot -= 1.9f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int unused) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay);
    }

    public ModelPart getHead() {
        return this.head;
    }
}

