/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gaia.config.GaiaConfig;
import gaia.entity.Toad;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;

public class ToadModel
extends EntityModel<Toad>
implements HeadedModel,
ArmedModel {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart headeyes;
    private final ModelPart necktie;
    private final ModelPart chest;
    private final ModelPart leftarm;
    private final ModelPart rightarm;
    private final ModelPart leftleg;
    private final ModelPart rightleg;

    public ToadModel(ModelPart root) {
        this.root = root.getChild("toad");
        ModelPart bodybottom = this.root.getChild("bodybottom");
        ModelPart bodytop = bodybottom.getChild("bodymiddle").getChild("bodytop");
        ModelPart neck = bodytop.getChild("neck");
        this.head = neck.getChild("head");
        this.headeyes = this.head.getChild("headeyes");
        this.necktie = bodytop.getChild("necktie");
        this.chest = bodytop.getChild("chest");
        this.leftarm = bodytop.getChild("leftarm");
        this.rightarm = bodytop.getChild("rightarm");
        this.leftleg = bodybottom.getChild("leftleg");
        this.rightleg = bodybottom.getChild("rightleg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition toad = partdefinition.addOrReplaceChild("toad", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition bodybottom = toad.addOrReplaceChild("bodybottom", CubeListBuilder.create().texOffs(0, 30).addBox(-3.0f, -1.5f, -1.5f, 6.0f, 3.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)-6.5f, (float)3.5f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition tail_r1 = bodybottom.addOrReplaceChild("tail_r1", CubeListBuilder.create().texOffs(36, 25).addBox(-3.5f, 0.0f, 0.0f, 7.0f, 5.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)1.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition bodymiddle = bodybottom.addOrReplaceChild("bodymiddle", CubeListBuilder.create().texOffs(0, 25).addBox(-2.0f, -2.5f, -2.0f, 4.0f, 3.0f, 2.0f).texOffs(0, 25).addBox(-0.5f, -2.0f, -2.1f, 1.0f, 2.0f, 0.0f), PartPose.offsetAndRotation((float)0.0f, (float)-1.5f, (float)1.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition bodytop = bodymiddle.addOrReplaceChild("bodytop", CubeListBuilder.create().texOffs(0, 16).addBox(-2.5f, -6.0f, -2.5f, 5.0f, 6.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)0.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition neck = bodytop.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(0, 12).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)-6.0f, (float)-1.0f, (float)-1.0472f, (float)0.0f, (float)0.0f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -6.0f, -3.0f, 6.0f, 6.0f, 6.0f).texOffs(36, 0).addBox(-3.5f, -6.5f, -3.5f, 7.0f, 7.0f, 7.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition headeyes = head.addOrReplaceChild("headeyes", CubeListBuilder.create().texOffs(24, 0).addBox(-3.0f, -6.0f, -3.0f, 6.0f, 6.0f, 0.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition headrighteye = head.addOrReplaceChild("headrighteye", CubeListBuilder.create().texOffs(36, 14).addBox(-4.5f, -7.5f, -4.5f, 3.0f, 3.0f, 3.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition headlefteye = head.addOrReplaceChild("headlefteye", CubeListBuilder.create().texOffs(36, 14).addBox(1.5f, -7.5f, -4.5f, 3.0f, 3.0f, 3.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition necktie = bodytop.addOrReplaceChild("necktie", CubeListBuilder.create().texOffs(36, 20).addBox(-1.0f, 0.0f, 0.0f, 2.0f, 2.0f, 0.0f).texOffs(36, 22).addBox(-1.0f, 2.0f, -0.5f, 2.0f, 2.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)-6.0f, (float)-2.5f, (float)-1.0472f, (float)0.0f, (float)0.0f));
        PartDefinition chest = bodytop.addOrReplaceChild("chest", CubeListBuilder.create().texOffs(0, 36).addBox(-2.3f, 0.0f, -2.0f, 2.0f, 2.0f, 2.0f).texOffs(0, 36).mirror().addBox(0.3f, 0.0f, -2.0f, 2.0f, 2.0f, 2.0f).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-5.5f, (float)-2.5f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition rightarm = bodytop.addOrReplaceChild("rightarm", CubeListBuilder.create().texOffs(16, 12).addBox(-2.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f), PartPose.offsetAndRotation((float)-2.5f, (float)-4.5f, (float)-1.0f, (float)-1.0472f, (float)-0.5236f, (float)1.5708f));
        PartDefinition rightarmlower = rightarm.addOrReplaceChild("rightarmlower", CubeListBuilder.create().texOffs(16, 20).addBox(-1.005f, 0.0f, -2.0f, 2.0f, 6.0f, 2.0f), PartPose.offsetAndRotation((float)-1.0f, (float)5.0f, (float)1.0f, (float)-1.0472f, (float)0.0f, (float)0.0f));
        PartDefinition leftarm = bodytop.addOrReplaceChild("leftarm", CubeListBuilder.create().texOffs(16, 12).mirror().addBox(0.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f).mirror(false), PartPose.offsetAndRotation((float)2.5f, (float)-4.5f, (float)-1.0f, (float)-1.0472f, (float)0.5236f, (float)-1.5708f));
        PartDefinition leftarmlower = leftarm.addOrReplaceChild("leftarmlower", CubeListBuilder.create().texOffs(16, 20).mirror().addBox(-0.995f, 0.0f, -2.0f, 2.0f, 6.0f, 2.0f).mirror(false), PartPose.offsetAndRotation((float)1.0f, (float)5.0f, (float)1.0f, (float)-1.0472f, (float)0.0f, (float)0.0f));
        PartDefinition rightleg = bodybottom.addOrReplaceChild("rightleg", CubeListBuilder.create().texOffs(24, 12).addBox(-1.5f, -1.0f, -1.5f, 3.0f, 7.0f, 3.0f), PartPose.offsetAndRotation((float)-2.5f, (float)0.0f, (float)0.5f, (float)-2.7925f, (float)0.0f, (float)-0.6981f));
        PartDefinition rightleglower = rightleg.addOrReplaceChild("rightleglower", CubeListBuilder.create().texOffs(24, 22).addBox(-1.505f, 0.0f, 0.0f, 3.0f, 7.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)6.0f, (float)-1.5f, (float)1.4835f, (float)0.0f, (float)0.0f));
        PartDefinition leftleg = bodybottom.addOrReplaceChild("leftleg", CubeListBuilder.create().texOffs(24, 12).addBox(-1.5f, -1.0f, -1.5f, 3.0f, 7.0f, 3.0f), PartPose.offsetAndRotation((float)2.5f, (float)0.0f, (float)0.5f, (float)-2.7925f, (float)0.0f, (float)0.6981f));
        PartDefinition leftleglower = leftleg.addOrReplaceChild("leftleglower", CubeListBuilder.create().texOffs(24, 22).addBox(-1.495f, 0.0f, 0.0f, 3.0f, 7.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)6.0f, (float)-1.5f, (float)1.4835f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void prepareMobModel(Toad toad, float limbSwing, float limbSwingAmount, float partialTick) {
        super.prepareMobModel((Entity)toad, limbSwing, limbSwingAmount, partialTick);
        this.chest.visible = (Boolean)GaiaConfig.CLIENT.genderNeutral.get() == false && !toad.isBaby();
    }

    public void setupAnim(Toad toad, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean bl = this.headeyes.visible = ageInTicks % 60.0f == 0.0f && limbSwingAmount <= 0.1f;
        if (this.attackTime > 0.0f) {
            this.holdingMelee();
        }
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.rightarm.xRot = -1.0472f + Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.5f * limbSwingAmount * 0.5f;
        this.leftarm.xRot = -1.0472f + Mth.cos((float)(limbSwing * 0.6662f)) * 0.5f * limbSwingAmount * 0.5f;
        for (int k = 1; k < 2; ++k) {
            this.necktie.zRot = Mth.cos((float)(((float)k * 1.5f + ageInTicks) * 0.1f)) / 16.0f;
        }
        this.rightleg.xRot = -2.7925f + Mth.cos((float)(limbSwing * 0.6662f)) * 0.2f * limbSwingAmount;
        this.leftleg.xRot = -2.7925f + Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.2f * limbSwingAmount;
    }

    public void holdingMelee() {
        float f6 = 1.0f - this.attackTime;
        f6 *= f6;
        f6 *= f6;
        f6 = 1.0f - f6;
        float f7 = Mth.sin((float)(f6 * (float)Math.PI));
        float f8 = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -(this.head.xRot - 0.7f) * 0.75f;
        this.head.xRot -= (float)((double)this.head.xRot - ((double)f7 * 1.2 + (double)f8));
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int unused) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay);
    }

    public ModelPart getHead() {
        return this.head;
    }

    private ModelPart getArm(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.leftarm : this.rightarm;
    }

    public void translateToHand(HumanoidArm arm, PoseStack poseStack) {
        poseStack.translate(-0.0625, 0.5, 0.0);
        this.getArm(arm).translateAndRotate(poseStack);
    }
}

