/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gaia.config.GaiaConfig;
import gaia.entity.trader.Trader;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;

public class TraderModel
extends EntityModel<Trader>
implements HeadedModel,
ArmedModel {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart headeyes;
    private final ModelPart leftear;
    private final ModelPart rightear;
    private final ModelPart chest;
    private final ModelPart leftarm;
    private final ModelPart rightarm;
    private final ModelPart leftarmlower;
    private final ModelPart rightarmlower;
    private final ModelPart tail;
    private final ModelPart leftleg;
    private final ModelPart rightleg;

    public TraderModel(ModelPart root) {
        this.root = root.getChild("trader");
        ModelPart bodybottom = this.root.getChild("bodybottom");
        ModelPart bodytop = bodybottom.getChild("bodymiddle").getChild("bodytop");
        ModelPart neck = bodytop.getChild("neck");
        this.head = neck.getChild("head");
        this.headeyes = this.head.getChild("headeyes");
        this.leftear = this.head.getChild("leftear");
        this.rightear = this.head.getChild("rightear");
        this.chest = bodytop.getChild("chest");
        this.leftarm = bodytop.getChild("leftarm");
        this.leftarmlower = this.leftarm.getChild("leftarmlower");
        this.rightarm = bodytop.getChild("rightarm");
        this.rightarmlower = this.rightarm.getChild("rightarmlower");
        this.tail = bodybottom.getChild("tail");
        this.leftleg = this.root.getChild("leftleg");
        this.rightleg = this.root.getChild("rightleg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition trader = partdefinition.addOrReplaceChild("trader", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)25.0f, (float)0.0f));
        PartDefinition bodybottom = trader.addOrReplaceChild("bodybottom", CubeListBuilder.create().texOffs(0, 30).addBox(-3.0f, 8.0f, -2.5f, 6.0f, 3.0f, 3.0f).texOffs(68, 16).addBox(-3.5f, 8.5f, -3.5f, 7.0f, 2.0f, 7.0f), PartPose.offset((float)0.0f, (float)-23.0f, (float)1.0f));
        PartDefinition bodymiddle = bodybottom.addOrReplaceChild("bodymiddle", CubeListBuilder.create().texOffs(0, 25).addBox(-2.0f, -2.5f, -2.0f, 4.0f, 3.0f, 2.0f).texOffs(0, 25).addBox(-0.5f, -2.0f, -2.1f, 1.0f, 2.0f, 0.0f), PartPose.offset((float)0.0f, (float)8.0f, (float)0.0f));
        PartDefinition bodytop = bodymiddle.addOrReplaceChild("bodytop", CubeListBuilder.create().texOffs(0, 16).addBox(-2.5f, -6.0f, -2.5f, 5.0f, 6.0f, 3.0f), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition neck = bodytop.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(0, 12).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.offset((float)0.0f, (float)-6.0f, (float)-1.0f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -6.0f, -3.0f, 6.0f, 6.0f, 6.0f).texOffs(36, 0).addBox(-3.5f, -6.5f, -3.5f, 7.0f, 7.0f, 7.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition headeyes = head.addOrReplaceChild("headeyes", CubeListBuilder.create().texOffs(24, 0).addBox(-3.0f, -6.0f, -3.1f, 6.0f, 6.0f, 0.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightear = head.addOrReplaceChild("rightear", CubeListBuilder.create().texOffs(36, 34).addBox(-1.0f, -0.5f, -4.0f, 2.0f, 1.0f, 4.0f), PartPose.offsetAndRotation((float)-1.5f, (float)-6.0f, (float)0.0f, (float)-1.3963f, (float)0.3491f, (float)0.0f));
        PartDefinition righteartip = rightear.addOrReplaceChild("righteartip", CubeListBuilder.create().texOffs(36, 39).addBox(-1.005f, 0.0f, -2.0f, 2.0f, 1.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)-0.5f, (float)-4.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition leftear = head.addOrReplaceChild("leftear", CubeListBuilder.create().texOffs(36, 34).mirror().addBox(-1.0f, -0.5f, -4.0f, 2.0f, 1.0f, 4.0f).mirror(false), PartPose.offsetAndRotation((float)1.5f, (float)-6.0f, (float)0.0f, (float)-1.3963f, (float)-0.3491f, (float)0.0f));
        PartDefinition lefteartip = leftear.addOrReplaceChild("lefteartip", CubeListBuilder.create().texOffs(36, 39).mirror().addBox(-0.995f, 0.0f, -2.0f, 2.0f, 1.0f, 2.0f).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-0.5f, (float)-4.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition righthairpin = head.addOrReplaceChild("righthairpin", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition righthairpin_r1 = righthairpin.addOrReplaceChild("righthairpin_r1", CubeListBuilder.create().texOffs(52, 26).addBox(-2.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f), PartPose.offsetAndRotation((float)-4.0f, (float)-6.0f, (float)3.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition righthair = righthairpin.addOrReplaceChild("righthair", CubeListBuilder.create(), PartPose.offset((float)-0.5f, (float)0.0f, (float)0.0f));
        PartDefinition righthair_r1 = righthair.addOrReplaceChild("righthair_r1", CubeListBuilder.create().texOffs(36, 14).addBox(-1.5f, -4.5f, -1.5f, 3.0f, 9.0f, 3.0f), PartPose.offsetAndRotation((float)-3.5f, (float)-0.5f, (float)3.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition lefthairpin = head.addOrReplaceChild("lefthairpin", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition lefthairpin_r1 = lefthairpin.addOrReplaceChild("lefthairpin_r1", CubeListBuilder.create().texOffs(36, 26).addBox(-2.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f), PartPose.offsetAndRotation((float)4.0f, (float)-6.0f, (float)3.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition lefthair = lefthairpin.addOrReplaceChild("lefthair", CubeListBuilder.create(), PartPose.offset((float)0.5f, (float)0.0f, (float)0.0f));
        PartDefinition lefthair_r1 = lefthair.addOrReplaceChild("lefthair_r1", CubeListBuilder.create().texOffs(36, 14).addBox(-1.5f, -4.5f, -1.5f, 3.0f, 9.0f, 3.0f), PartPose.offsetAndRotation((float)3.5f, (float)-0.5f, (float)3.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition chest = bodytop.addOrReplaceChild("chest", CubeListBuilder.create().texOffs(0, 36).addBox(-2.3f, 0.0f, -2.0f, 2.0f, 2.0f, 2.0f).texOffs(0, 36).mirror().addBox(0.3f, 0.0f, -2.0f, 2.0f, 2.0f, 2.0f).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-5.5f, (float)-2.5f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition rightarm = bodytop.addOrReplaceChild("rightarm", CubeListBuilder.create().texOffs(16, 12).addBox(-2.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f).texOffs(96, 0).addBox(-2.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.25f)).texOffs(36, 42).addBox(-2.5f, -1.5f, -1.5f, 3.0f, 3.0f, 3.0f), PartPose.offsetAndRotation((float)-2.5f, (float)-4.5f, (float)-1.0f, (float)0.0f, (float)0.1745f, (float)0.1745f));
        PartDefinition rightarmlower = rightarm.addOrReplaceChild("rightarmlower", CubeListBuilder.create().texOffs(16, 20).addBox(-1.005f, 0.0f, -2.0f, 2.0f, 6.0f, 2.0f), PartPose.offsetAndRotation((float)-1.0f, (float)5.0f, (float)1.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition leftarm = bodytop.addOrReplaceChild("leftarm", CubeListBuilder.create().texOffs(16, 12).addBox(0.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f).texOffs(96, 0).addBox(0.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.25f)).texOffs(36, 42).addBox(-0.5f, -1.5f, -1.5f, 3.0f, 3.0f, 3.0f), PartPose.offsetAndRotation((float)2.5f, (float)-4.5f, (float)-1.0f, (float)0.0f, (float)-0.1745f, (float)-0.1745f));
        PartDefinition leftarmlower = leftarm.addOrReplaceChild("leftarmlower", CubeListBuilder.create().texOffs(16, 20).addBox(-0.995f, 0.0f, -2.0f, 2.0f, 6.0f, 2.0f), PartPose.offsetAndRotation((float)1.0f, (float)5.0f, (float)1.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition tail = bodybottom.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(68, 10).addBox(-1.5f, -2.5f, -0.5f, 3.0f, 3.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)8.5f, (float)0.5f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition watch = bodybottom.addOrReplaceChild("watch", CubeListBuilder.create().texOffs(68, 0).addBox(-1.0f, 0.0f, -2.5f, 1.0f, 5.0f, 5.0f), PartPose.offsetAndRotation((float)-3.0f, (float)8.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.2618f));
        PartDefinition rightleg = trader.addOrReplaceChild("rightleg", CubeListBuilder.create().texOffs(24, 12).addBox(-1.5f, -1.0f, -1.5f, 3.0f, 8.0f, 3.0f), PartPose.offsetAndRotation((float)-2.0f, (float)-13.0f, (float)0.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition rightskirt01 = rightleg.addOrReplaceChild("rightskirt01", CubeListBuilder.create().texOffs(68, 25).addBox(-2.0f, 0.5f, -4.0f, 5.0f, 3.0f, 8.0f).texOffs(68, 36).addBox(-2.5f, 3.5f, -4.5f, 6.0f, 5.0f, 9.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)1.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition rightleglower = rightleg.addOrReplaceChild("rightleglower", CubeListBuilder.create().texOffs(68, 50).addBox(-1.505f, -2.5f, -2.0f, 3.0f, 8.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)7.0f, (float)1.5f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition rightfootlower = rightleglower.addOrReplaceChild("rightfootlower", CubeListBuilder.create().texOffs(68, 60).addBox(-1.505f, 0.0f, -1.0f, 3.0f, 1.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)5.5f, (float)-2.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition leftleg = trader.addOrReplaceChild("leftleg", CubeListBuilder.create().texOffs(24, 12).mirror().addBox(-1.5f, -1.0f, -1.5f, 3.0f, 8.0f, 3.0f).mirror(false), PartPose.offsetAndRotation((float)2.0f, (float)-13.0f, (float)0.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition leftskirt01 = leftleg.addOrReplaceChild("leftskirt01", CubeListBuilder.create().texOffs(68, 25).mirror().addBox(-3.0f, 0.495f, -4.0f, 5.0f, 3.0f, 8.0f).mirror(false).texOffs(68, 36).mirror().addBox(-3.5f, 3.495f, -4.5f, 6.0f, 5.0f, 9.0f).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)1.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition leftleglower = leftleg.addOrReplaceChild("leftleglower", CubeListBuilder.create().texOffs(68, 50).mirror().addBox(-1.495f, -2.5f, -2.0f, 3.0f, 8.0f, 2.0f).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)7.0f, (float)1.5f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition leftfootlower = leftleglower.addOrReplaceChild("leftfootlower", CubeListBuilder.create().texOffs(68, 60).mirror().addBox(-1.495f, 0.0f, -1.0f, 3.0f, 1.0f, 3.0f).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)5.5f, (float)-2.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void prepareMobModel(Trader trader, float limbSwing, float limbSwingAmount, float partialTick) {
        super.prepareMobModel((Entity)trader, limbSwing, limbSwingAmount, partialTick);
        this.chest.visible = (Boolean)GaiaConfig.CLIENT.genderNeutral.get() == false && !trader.isBaby();
    }

    public void setupAnim(Trader trader, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.headeyes.visible = ageInTicks % 60.0f == 0.0f && limbSwingAmount <= 0.1f;
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        float earDefaultAngleZ = 0.2617994f;
        this.rightear.yRot = Mth.cos((float)((float)Math.PI / 180 * (ageInTicks * 7.0f))) * 0.06981317f;
        this.rightear.yRot += earDefaultAngleZ;
        this.leftear.yRot = Mth.cos((float)((float)Math.PI / 180 * ageInTicks * 7.0f)) * -0.06981317f;
        this.leftear.yRot -= earDefaultAngleZ;
        this.rightarm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.8f * limbSwingAmount * 0.5f;
        this.leftarm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.8f * limbSwingAmount * 0.5f;
        this.rightarm.zRot = 0.0f;
        this.leftarm.zRot = 0.0f;
        float armDefaultAngleY = 0.349066f;
        float armDefaultAngleZ = 0.174533f;
        this.rightarm.xRot += Mth.sin((float)(ageInTicks * 0.067f)) * 0.05f;
        this.rightarm.yRot = armDefaultAngleY;
        this.rightarm.zRot += Mth.cos((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f + armDefaultAngleZ;
        this.leftarm.xRot -= Mth.sin((float)(ageInTicks * 0.067f)) * 0.05f;
        this.leftarm.yRot = -armDefaultAngleY;
        this.leftarm.zRot -= Mth.cos((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f + armDefaultAngleZ;
        this.rightarmlower.xRot = -armDefaultAngleY;
        this.leftarmlower.xRot = -armDefaultAngleY;
        this.tail.yRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.5f * limbSwingAmount;
        this.rightleg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.5f * limbSwingAmount * 0.5f;
        this.leftleg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.5f * limbSwingAmount * 0.5f;
        this.rightleg.xRot += 0.3490659f;
        this.leftleg.xRot += 0.3490659f;
        this.rightleg.yRot = -0.0872665f;
        this.leftleg.yRot = 0.0872665f;
        this.rightleg.zRot = -0.0349066f;
        this.leftleg.zRot = 0.0349066f;
        if (this.riding) {
            this.rightarm.xRot -= 0.62831855f;
            this.leftarm.xRot -= 0.62831855f;
            this.rightleg.xRot = -1.4137167f;
            this.rightleg.yRot = 0.31415927f;
            this.rightleg.zRot = 0.07853982f;
            this.leftleg.xRot = -1.4137167f;
            this.leftleg.yRot = -0.31415927f;
            this.leftleg.zRot = -0.07853982f;
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int unused) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay);
    }

    public ModelPart getHead() {
        return this.head;
    }

    private ModelPart getArm(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.leftarm : this.rightarm;
    }

    public void translateToHand(HumanoidArm arm, PoseStack poseStack) {
        poseStack.translate(-0.0625, 0.5, 0.0);
        this.getArm(arm).translateAndRotate(poseStack);
    }
}

