/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gaia.config.GaiaConfig;
import gaia.entity.Valkyrie;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;

public class ValkyrieModel
extends EntityModel<Valkyrie>
implements HeadedModel,
ArmedModel {
    private final ModelPart root;
    private final ModelPart bodytop;
    private final ModelPart head;
    private final ModelPart headeyes;
    private final ModelPart hair1;
    private final ModelPart hair2;
    private final ModelPart chest;
    private final ModelPart leftarm;
    private final ModelPart rightarm;
    private final ModelPart leftwing;
    private final ModelPart rightwing;
    private final ModelPart leftleg;
    private final ModelPart rightleg;

    public ValkyrieModel(ModelPart root) {
        this.root = root.getChild("valkyrie");
        ModelPart bodybottom = this.root.getChild("bodybottom");
        this.bodytop = bodybottom.getChild("bodymiddle").getChild("bodytop");
        ModelPart neck = this.bodytop.getChild("neck");
        this.head = neck.getChild("head");
        this.headeyes = this.head.getChild("headeyes");
        this.hair1 = neck.getChild("hair1");
        this.hair2 = this.hair1.getChild("hair2");
        this.chest = this.bodytop.getChild("chest");
        this.leftarm = this.bodytop.getChild("leftarm");
        this.rightarm = this.bodytop.getChild("rightarm");
        this.leftwing = this.bodytop.getChild("leftwing");
        this.rightwing = this.bodytop.getChild("rightwing");
        this.leftleg = this.root.getChild("leftleg");
        this.rightleg = this.root.getChild("rightleg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition valkyrie = partdefinition.addOrReplaceChild("valkyrie", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition bodybottom = valkyrie.addOrReplaceChild("bodybottom", CubeListBuilder.create().texOffs(0, 30).addBox(-3.0f, -1.5f, -1.5f, 6.0f, 3.0f, 3.0f).texOffs(96, 0).addBox(-3.5f, -1.0f, -2.0f, 7.0f, 4.0f, 4.0f), PartPose.offsetAndRotation((float)0.0f, (float)-13.5f, (float)-0.5f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition bodymiddle = bodybottom.addOrReplaceChild("bodymiddle", CubeListBuilder.create().texOffs(0, 25).addBox(-2.0f, -2.5f, -2.0f, 4.0f, 3.0f, 2.0f).texOffs(0, 25).addBox(-0.5f, -2.0f, -2.1f, 1.0f, 2.0f, 0.0f), PartPose.offsetAndRotation((float)0.0f, (float)-1.5f, (float)1.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition bodytop = bodymiddle.addOrReplaceChild("bodytop", CubeListBuilder.create().texOffs(0, 16).addBox(-2.5f, -6.0f, -2.5f, 5.0f, 6.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition neck = bodytop.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(0, 12).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)-6.0f, (float)-1.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -6.0f, -3.0f, 6.0f, 6.0f, 6.0f).texOffs(36, 0).addBox(-3.5f, -6.5f, -3.5f, 7.0f, 7.0f, 7.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition headeyes = head.addOrReplaceChild("headeyes", CubeListBuilder.create().texOffs(24, 0).addBox(-3.0f, -6.0f, -3.1f, 6.0f, 6.0f, 0.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightfeather = head.addOrReplaceChild("rightfeather", CubeListBuilder.create().texOffs(36, 37).addBox(-4.5f, -7.0f, 0.0f, 1.0f, 6.0f, 8.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3491f, (float)-0.2618f, (float)0.0f));
        PartDefinition leftfeather = head.addOrReplaceChild("leftfeather", CubeListBuilder.create().texOffs(36, 37).addBox(3.5f, -7.0f, 0.0f, 1.0f, 6.0f, 8.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3491f, (float)0.2618f, (float)0.0f));
        PartDefinition headhelmet = head.addOrReplaceChild("headhelmet", CubeListBuilder.create().texOffs(36, 51).addBox(-3.0f, -1.5f, -3.0f, 6.0f, 3.0f, 4.0f), PartPose.offset((float)0.0f, (float)-5.5f, (float)-1.0f));
        PartDefinition hair1 = neck.addOrReplaceChild("hair1", CubeListBuilder.create().texOffs(36, 14).addBox(-4.0f, -4.0f, 1.5f, 8.0f, 8.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition hair2 = hair1.addOrReplaceChild("hair2", CubeListBuilder.create().texOffs(36, 25).addBox(-4.5f, -0.5f, -2.5f, 9.0f, 9.0f, 3.0f), PartPose.offset((float)0.0f, (float)1.5f, (float)4.5f));
        PartDefinition chest = bodytop.addOrReplaceChild("chest", CubeListBuilder.create().texOffs(0, 36).addBox(-2.3f, 0.0f, -2.0f, 2.0f, 2.0f, 2.0f).texOffs(0, 36).mirror().addBox(0.3f, 0.0f, -2.0f, 2.0f, 2.0f, 2.0f).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-5.5f, (float)-2.5f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition rightarm = bodytop.addOrReplaceChild("rightarm", CubeListBuilder.create().texOffs(16, 12).addBox(-2.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f).texOffs(64, 23).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 3.0f, 4.0f), PartPose.offsetAndRotation((float)-2.5f, (float)-4.0f, (float)-1.0f, (float)0.0873f, (float)0.0f, (float)0.1745f));
        PartDefinition rightarmlower = rightarm.addOrReplaceChild("rightarmlower", CubeListBuilder.create().texOffs(16, 20).addBox(-2.005f, 0.0f, -2.0f, 2.0f, 6.0f, 2.0f).texOffs(64, 30).addBox(-2.5f, 0.5f, -2.5f, 2.0f, 6.0f, 3.0f), PartPose.offset((float)0.0f, (float)5.0f, (float)1.0f));
        PartDefinition leftarm = bodytop.addOrReplaceChild("leftarm", CubeListBuilder.create().texOffs(16, 12).mirror().addBox(0.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f).mirror(false).texOffs(64, 23).mirror().addBox(-1.0f, -2.0f, -2.0f, 4.0f, 3.0f, 4.0f).mirror(false), PartPose.offsetAndRotation((float)2.5f, (float)-4.0f, (float)-1.0f, (float)0.0873f, (float)0.0f, (float)-0.1745f));
        PartDefinition leftarmlower = leftarm.addOrReplaceChild("leftarmlower", CubeListBuilder.create().texOffs(16, 20).mirror().addBox(-0.995f, 0.0f, -2.0f, 2.0f, 6.0f, 2.0f).mirror(false), PartPose.offset((float)1.0f, (float)5.0f, (float)1.0f));
        PartDefinition cape1 = bodytop.addOrReplaceChild("cape1", CubeListBuilder.create().texOffs(64, 0).addBox(-3.5f, 0.0f, -1.5f, 7.0f, 4.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)-6.5f, (float)1.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition cape2 = cape1.addOrReplaceChild("cape2", CubeListBuilder.create().texOffs(64, 6).addBox(-4.0f, 0.0f, -2.5f, 8.0f, 5.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)3.5f, (float)0.5f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition cape3 = cape2.addOrReplaceChild("cape3", CubeListBuilder.create().texOffs(64, 14).addBox(-4.5f, 0.0f, -2.5f, 9.0f, 6.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)4.5f, (float)0.5f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition rightwing = bodytop.addOrReplaceChild("rightwing", CubeListBuilder.create().texOffs(92, 34).addBox(1.0f, 0.0f, 0.5f, 0.0f, 12.0f, 18.0f), PartPose.offsetAndRotation((float)-2.0f, (float)-5.0f, (float)0.5f, (float)0.6981f, (float)-0.5236f, (float)0.0f));
        PartDefinition leftwing = bodytop.addOrReplaceChild("leftwing", CubeListBuilder.create().texOffs(92, 34).mirror().addBox(0.0f, 0.0f, 0.5f, 0.0f, 12.0f, 18.0f).mirror(false), PartPose.offsetAndRotation((float)2.0f, (float)-5.0f, (float)0.5f, (float)0.6981f, (float)0.5236f, (float)0.0f));
        PartDefinition skirt1 = bodybottom.addOrReplaceChild("skirt1", CubeListBuilder.create().texOffs(96, 8).addBox(-4.0f, 0.0f, -3.5f, 8.0f, 4.0f, 4.0f), PartPose.offsetAndRotation((float)0.0f, (float)-0.5f, (float)2.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition skirt2 = skirt1.addOrReplaceChild("skirt2", CubeListBuilder.create().texOffs(96, 16).addBox(-4.5f, 0.0f, -3.0f, 9.0f, 5.0f, 4.0f), PartPose.offset((float)0.0f, (float)3.0f, (float)0.0f));
        PartDefinition skirt3 = skirt2.addOrReplaceChild("skirt3", CubeListBuilder.create().texOffs(96, 25).addBox(-5.0f, 0.0f, -3.0f, 10.0f, 5.0f, 4.0f), PartPose.offset((float)0.0f, (float)4.0f, (float)0.5f));
        PartDefinition rightleg = valkyrie.addOrReplaceChild("rightleg", CubeListBuilder.create().texOffs(24, 12).addBox(-1.5f, -1.0f, -1.5f, 3.0f, 7.0f, 3.0f), PartPose.offset((float)-2.0f, (float)-13.0f, (float)0.0f));
        PartDefinition rightleglower = rightleg.addOrReplaceChild("rightleglower", CubeListBuilder.create().texOffs(24, 22).addBox(-1.505f, 0.0f, 0.0f, 3.0f, 7.0f, 3.0f).texOffs(96, 34).addBox(-2.005f, -1.0f, -0.5f, 4.0f, 8.0f, 4.0f, new CubeDeformation(-0.25f)), PartPose.offset((float)0.0f, (float)6.0f, (float)-1.5f));
        PartDefinition leftleg = valkyrie.addOrReplaceChild("leftleg", CubeListBuilder.create().texOffs(24, 12).mirror().addBox(-1.5f, -1.0f, -1.5f, 3.0f, 7.0f, 3.0f).mirror(false), PartPose.offset((float)2.0f, (float)-13.0f, (float)0.0f));
        PartDefinition leftleglower = leftleg.addOrReplaceChild("leftleglower", CubeListBuilder.create().texOffs(24, 22).mirror().addBox(-1.495f, 0.0f, 0.0f, 3.0f, 7.0f, 3.0f).mirror(false).texOffs(96, 34).mirror().addBox(-1.995f, -1.0f, -0.5f, 4.0f, 8.0f, 4.0f, new CubeDeformation(-0.25f)).mirror(false), PartPose.offset((float)0.0f, (float)6.0f, (float)-1.5f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void prepareMobModel(Valkyrie valkyrie, float limbSwing, float limbSwingAmount, float partialTick) {
        super.prepareMobModel((Entity)valkyrie, limbSwing, limbSwingAmount, partialTick);
        this.chest.visible = (Boolean)GaiaConfig.CLIENT.genderNeutral.get() == false && !valkyrie.isBaby();
    }

    public void setupAnim(Valkyrie valkyrie, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.headeyes.visible = ageInTicks % 60.0f == 0.0f && limbSwingAmount <= 0.1f;
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.hair1.yRot = this.head.yRot;
        this.hair1.xRot = this.head.xRot;
        this.hair2.xRot = this.head.xRot * 0.75f;
        if (valkyrie.getAnimationState() == 0) {
            this.rightarm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.8f * limbSwingAmount * 0.5f;
            this.leftarm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.8f * limbSwingAmount * 0.5f;
            this.rightarm.zRot = 0.0f;
            this.leftarm.zRot = 0.0f;
            if (this.attackTime > 0.0f) {
                this.holdingMelee();
            }
            float armDefaultAngleZ = 0.1745329f;
            this.rightarm.zRot += Mth.cos((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f + armDefaultAngleZ;
            this.rightarm.xRot += Mth.sin((float)(ageInTicks * 0.067f)) * 0.05f;
            this.leftarm.zRot -= Mth.cos((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f + armDefaultAngleZ;
            this.leftarm.xRot -= Mth.sin((float)(ageInTicks * 0.067f)) * 0.05f;
        } else if (valkyrie.getAnimationState() == 1) {
            this.animationBuff();
        }
        float wingDefaultAngleY = 0.5235988f;
        this.rightwing.yRot = Mth.cos((float)(ageInTicks * 0.6662f + (float)Math.PI)) * 1.0f * limbSwingAmount * 0.5f;
        this.leftwing.yRot = Mth.cos((float)(ageInTicks * 0.6662f)) * 1.0f * limbSwingAmount * 0.5f;
        this.rightwing.yRot -= wingDefaultAngleY;
        this.leftwing.yRot += wingDefaultAngleY;
        this.rightleg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.35f * limbSwingAmount;
        this.leftleg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.35f * limbSwingAmount;
        this.rightleg.yRot = 0.0f;
        this.leftleg.yRot = 0.0f;
        this.rightleg.zRot = 0.0f;
        this.leftleg.zRot = 0.0f;
        if (this.riding) {
            this.rightarm.xRot -= 0.62831855f;
            this.leftarm.xRot -= 0.62831855f;
            this.rightleg.xRot = -1.4137167f;
            this.rightleg.yRot = 0.31415927f;
            this.rightleg.zRot = 0.07853982f;
            this.leftleg.xRot = -1.4137167f;
            this.leftleg.yRot = -0.31415927f;
            this.leftleg.zRot = -0.07853982f;
        }
    }

    public void holdingMelee() {
        float f6 = 1.0f - this.attackTime;
        f6 *= f6;
        f6 *= f6;
        f6 = 1.0f - f6;
        float f7 = Mth.sin((float)(f6 * (float)Math.PI));
        float f8 = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -(this.head.xRot - 0.7f) * 0.75f;
        this.rightarm.xRot = (float)((double)this.rightarm.xRot - ((double)f7 * 1.2 + (double)f8));
        this.rightarm.xRot += this.bodytop.yRot * 2.0f;
        this.rightarm.zRot = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -0.4f;
    }

    private void animationBuff() {
        this.rightarm.xRot = 0.0f;
        this.leftarm.xRot = 0.0f;
        this.rightarm.zRot = 0.785398f;
        this.leftarm.zRot = -0.785398f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int unused) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay);
    }

    public ModelPart getHead() {
        return this.head;
    }

    private ModelPart getArm(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.leftarm : this.rightarm;
    }

    public void translateToHand(HumanoidArm arm, PoseStack poseStack) {
        poseStack.translate(-0.0625, 0.5, 0.0);
        this.getArm(arm).translateAndRotate(poseStack);
    }
}

