/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import gaia.entity.WitherCow;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class WitherCowModel
extends EntityModel<WitherCow>
implements HeadedModel {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart ribs;
    private final ModelPart leg1;
    private final ModelPart leg2;
    private final ModelPart leg3;
    private final ModelPart leg4;

    public WitherCowModel(ModelPart root) {
        this.root = root.getChild("wither_cow");
        this.head = this.root.getChild("body1").getChild("head");
        this.ribs = this.root.getChild("ribs");
        this.leg1 = this.root.getChild("leg1");
        this.leg2 = this.root.getChild("leg2");
        this.leg3 = this.root.getChild("leg3");
        this.leg4 = this.root.getChild("leg4");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition wither_cow = partdefinition.addOrReplaceChild("wither_cow", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body1 = wither_cow.addOrReplaceChild("body1", CubeListBuilder.create().texOffs(28, 0).addBox(-6.0f, -1.0f, 0.0f, 12.0f, 9.0f, 10.0f).texOffs(72, 10).addBox(-5.5f, -0.5f, -5.0f, 11.0f, 8.0f, 5.0f), PartPose.offsetAndRotation((float)0.0f, (float)-12.0f, (float)-8.0f, (float)1.309f, (float)0.0f, (float)-0.1745f));
        PartDefinition head = body1.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -6.0f, 8.0f, 8.0f, 6.0f), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)8.0f, (float)-1.5708f, (float)0.1745f, (float)0.1745f));
        PartDefinition horn2_r1 = head.addOrReplaceChild("horn2_r1", CubeListBuilder.create().texOffs(22, 0).addBox(-1.0f, -3.0f, -0.5f, 1.0f, 3.0f, 1.0f), PartPose.offsetAndRotation((float)-4.0f, (float)-3.0f, (float)-3.5f, (float)0.0f, (float)0.0f, (float)0.2618f));
        PartDefinition horn1_r1 = head.addOrReplaceChild("horn1_r1", CubeListBuilder.create().texOffs(22, 0).addBox(0.0f, -3.0f, -0.5f, 1.0f, 3.0f, 1.0f), PartPose.offsetAndRotation((float)4.0f, (float)-3.0f, (float)-3.5f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        PartDefinition body2 = wither_cow.addOrReplaceChild("body2", CubeListBuilder.create().texOffs(28, 44).addBox(-6.0f, -9.0f, 0.0f, 12.0f, 9.0f, 10.0f).texOffs(72, 23).addBox(-5.5f, -9.5f, -5.0f, 11.0f, 9.0f, 5.0f).texOffs(72, 0).addBox(-2.0f, -6.0f, -4.0f, 4.0f, 6.0f, 4.0f), PartPose.offsetAndRotation((float)0.0f, (float)-12.0f, (float)10.0f, (float)1.8326f, (float)0.0f, (float)-0.1745f));
        PartDefinition ribs = wither_cow.addOrReplaceChild("ribs", CubeListBuilder.create().texOffs(28, 19).addBox(-5.5f, -8.0f, -4.5f, 11.0f, 16.0f, 9.0f), PartPose.offsetAndRotation((float)-0.6f, (float)-15.5f, (float)0.0f, (float)1.5708f, (float)0.0f, (float)-0.1745f));
        PartDefinition leg1 = wither_cow.addOrReplaceChild("leg1", CubeListBuilder.create().texOffs(0, 14).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offsetAndRotation((float)4.0f, (float)-12.0f, (float)7.0f, (float)0.1745f, (float)0.0f, (float)0.1745f));
        PartDefinition leg2 = wither_cow.addOrReplaceChild("leg2", CubeListBuilder.create().texOffs(0, 14).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offset((float)-4.0f, (float)-12.0f, (float)7.0f));
        PartDefinition leg3 = wither_cow.addOrReplaceChild("leg3", CubeListBuilder.create().texOffs(0, 14).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offsetAndRotation((float)4.0f, (float)-12.0f, (float)-6.0f, (float)0.0873f, (float)0.0f, (float)0.0873f));
        PartDefinition leg4 = wither_cow.addOrReplaceChild("leg4", CubeListBuilder.create().texOffs(0, 14).addBox(-2.0f, -1.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offset((float)-4.0f, (float)-11.0f, (float)-6.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void setupAnim(WitherCow witherCow, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = -90.0f + headPitch / 57.295776f;
        this.head.yRot -= 0.1745329f;
        if (this.attackTime > 0.0f) {
            this.holdingMelee();
        }
        this.ribs.zRot = Mth.cos((float)(ageInTicks * 24.0f * ((float)Math.PI / 180))) * ((float)Math.PI / 90);
        this.ribs.zRot -= 0.1745329f;
        this.leg1.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.8f * limbSwingAmount;
        this.leg2.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.8f * limbSwingAmount;
        this.leg3.xRot = this.leg2.xRot - 0.0872665f;
        this.leg4.xRot = this.leg1.xRot;
        this.leg1.xRot += 0.1745329f;
    }

    public void holdingMelee() {
        float f6 = 1.0f - this.attackTime;
        f6 *= f6;
        f6 *= f6;
        f6 = 1.0f - f6;
        float f7 = Mth.sin((float)(f6 * (float)Math.PI));
        float f8 = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -(this.head.xRot - 0.7f) * 0.75f;
        this.head.xRot -= (float)((double)this.head.xRot - ((double)f7 * 1.2 + (double)f8));
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int unused) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay);
    }

    public ModelPart getHead() {
        return this.head;
    }
}

