/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import gaia.client.ClientHandler;
import gaia.client.model.CreepModel;
import gaia.client.renderer.layer.CreepPowerLayer;
import gaia.entity.Creep;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class CreepRenderer
extends MobRenderer<Creep, CreepModel> {
    public static final ResourceLocation[] CREEP_LOCATIONS = new ResourceLocation[]{ResourceLocation.fromNamespaceAndPath((String)"grimoireofgaia", (String)"textures/entity/creep/creep.png")};

    public CreepRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new CreepModel(context.bakeLayer(ClientHandler.CREEP)), 0.4f);
        this.addLayer((RenderLayer)new CreepPowerLayer((RenderLayerParent<Creep, CreepModel>)this, context.getModelSet()));
    }

    protected void scale(Creep creep, PoseStack poseStack, float partialTicks) {
        float f = creep.getSwelling(partialTicks);
        float f1 = 1.0f + Mth.sin((float)(f * 100.0f)) * f * 0.01f;
        f = Mth.clamp((float)f, (float)0.0f, (float)1.0f);
        f *= f;
        f *= f;
        float f2 = (1.0f + f * 0.4f) * f1;
        float f3 = (1.0f + f * 0.1f) / f1;
        poseStack.scale(f2, f3, f2);
    }

    protected float getWhiteOverlayProgress(Creep creep, float partialTicks) {
        float f = creep.getSwelling(partialTicks);
        return (int)(f * 10.0f) % 2 == 0 ? 0.0f : Mth.clamp((float)f, (float)0.5f, (float)1.0f);
    }

    public ResourceLocation getTextureLocation(Creep creep) {
        return CREEP_LOCATIONS[creep.getVariant()];
    }
}

