/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.renderer;

import gaia.client.ClientHandler;
import gaia.client.model.EnderEyeModel;
import gaia.client.renderer.layer.EnderEyeEyesLayer;
import gaia.entity.EnderEye;
import java.util.Random;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class EnderEyeRenderer
extends MobRenderer<EnderEye, EnderEyeModel> {
    private final Random random = new Random();
    public static final ResourceLocation[] ENDER_EYE_LOCATIONS = new ResourceLocation[]{ResourceLocation.fromNamespaceAndPath((String)"grimoireofgaia", (String)"textures/entity/ender_eye/ender_eye.png")};

    public EnderEyeRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new EnderEyeModel(context.bakeLayer(ClientHandler.ENDER_EYE)), 0.4f);
        this.addLayer((RenderLayer)new EnderEyeEyesLayer((RenderLayerParent<EnderEye, EnderEyeModel>)this));
    }

    public Vec3 getRenderOffset(EnderEye enderEye, float partialTick) {
        if (enderEye.isScreaming()) {
            double d0 = 0.02;
            return new Vec3(this.random.nextGaussian() * d0, 0.0, this.random.nextGaussian() * d0);
        }
        return super.getRenderOffset((Entity)enderEye, partialTick);
    }

    public ResourceLocation getTextureLocation(EnderEye enderEye) {
        return ENDER_EYE_LOCATIONS[enderEye.getVariant()];
    }
}

