/*
 * Decompiled with CFR 0.152.
 */
package gaia.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import gaia.client.ClientHandler;
import gaia.client.model.GoblinModel;
import gaia.entity.GoblinFeral;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class GoblinFeralRenderer
extends MobRenderer<GoblinFeral, GoblinModel<GoblinFeral>> {
    public static final ResourceLocation[] GOBLIN_FERAL_LOCATIONS = new ResourceLocation[]{ResourceLocation.fromNamespaceAndPath((String)"grimoireofgaia", (String)"textures/entity/goblin/goblin_feral01.png"), ResourceLocation.fromNamespaceAndPath((String)"grimoireofgaia", (String)"textures/entity/goblin/goblin_feral02.png"), ResourceLocation.fromNamespaceAndPath((String)"grimoireofgaia", (String)"textures/entity/goblin/goblin_feral03.png")};

    public GoblinFeralRenderer(EntityRendererProvider.Context context) {
        super(context, new GoblinModel(context.bakeLayer(ClientHandler.GOBLIN_FERAL)), 0.4f);
        this.addLayer((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, context.getModelSet(), context.getItemInHandRenderer()));
        this.addLayer((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, context.getItemInHandRenderer()));
    }

    protected void scale(GoblinFeral creep, PoseStack poseStack, float partialTicks) {
        float f = creep.getSwelling(partialTicks);
        float f1 = 1.0f + Mth.sin((float)(f * 100.0f)) * f * 0.01f;
        f = Mth.clamp((float)f, (float)0.0f, (float)1.0f);
        f *= f;
        f *= f;
        float f2 = (1.0f + f * 0.4f) * f1;
        float f3 = (1.0f + f * 0.1f) / f1;
        poseStack.scale(f2, f3, f2);
    }

    protected float getWhiteOverlayProgress(GoblinFeral creep, float partialTicks) {
        float f = creep.getSwelling(partialTicks);
        return (int)(f * 10.0f) % 2 == 0 ? 0.0f : Mth.clamp((float)f, (float)0.5f, (float)1.0f);
    }

    public ResourceLocation getTextureLocation(GoblinFeral goblin) {
        return GOBLIN_FERAL_LOCATIONS[goblin.getVariant()];
    }
}

