/*
 * Decompiled with CFR 0.152.
 */
package gaia.config;

import gaia.GrimoireOfGaia;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class GaiaConfig {
    public static final ModConfigSpec clientSpec;
    public static final Client CLIENT;
    public static final ModConfigSpec commonSpec;
    public static final Common COMMON;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        GrimoireOfGaia.LOGGER.debug("Loaded Grimoire of Gaia's config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        GrimoireOfGaia.LOGGER.warn("Grimoire of Gaia's config just got changed on the file system!");
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Client::new);
        clientSpec = (ModConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
        specPair = new ModConfigSpec.Builder().configure(Common::new);
        commonSpec = (ModConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Client {
        public final ModConfigSpec.BooleanValue genderNeutral;
        public final ModConfigSpec.BooleanValue hideFoodEffectTooltips;
        public final ModConfigSpec.BooleanValue hideFoodXpTooltips;

        Client(ModConfigSpec.Builder builder) {
            builder.comment("Client settings").push("client");
            this.genderNeutral = builder.comment("When enabled makes the mobs look more gender neutral (default: false)").define("genderNeutral", false);
            this.hideFoodEffectTooltips = builder.comment("When enabled effect tooltips on edible items will be hidden (default: false)").define("hideFoodEffectTooltips", false);
            this.hideFoodXpTooltips = builder.comment("When enabled effect tooltips on edible items will be hidden (default: false)").define("hideFoodEffectTooltips", false);
            builder.pop();
        }
    }

    public static class Common {
        public final ModConfigSpec.BooleanValue disableInvisibility;
        public final ModConfigSpec.BooleanValue allPassiveMobsHostile;
        public final ModConfigSpec.BooleanValue passiveHostileMobs;
        public final ModConfigSpec.BooleanValue friendlyPersistence;
        public final ModConfigSpec.IntValue tier1maxHealth;
        public final ModConfigSpec.IntValue tier1attackDamage;
        public final ModConfigSpec.IntValue tier1baseDefense;
        public final ModConfigSpec.IntValue tier2maxHealth;
        public final ModConfigSpec.IntValue tier2attackDamage;
        public final ModConfigSpec.IntValue tier2baseDefense;
        public final ModConfigSpec.IntValue tier3maxHealth;
        public final ModConfigSpec.IntValue tier3attackDamage;
        public final ModConfigSpec.IntValue tier3baseDefense;
        public final ModConfigSpec.BooleanValue baseDamage;
        public final ModConfigSpec.BooleanValue shieldsBlockPiercing;
        public final ModConfigSpec.BooleanValue baseDamageArchers;
        public final ModConfigSpec.BooleanValue spawnDaysPassed;
        public final ModConfigSpec.IntValue spawnDaysSet;
        public final ModConfigSpec.BooleanValue spawnLevel3Rain;
        public final ModConfigSpec.BooleanValue disableYRestriction;
        public final ModConfigSpec.BooleanValue spawnWeather;

        Common(ModConfigSpec.Builder builder) {
            builder.comment("General Settings").push("General");
            this.disableInvisibility = builder.comment("Disable mobs that use the Invisibility status effect when far from a player [Default: false]").define("disableInvisibility", false);
            this.allPassiveMobsHostile = builder.comment("All mobs are now hostile [Default: false]").define("allPassiveMobsHostile", false);
            this.passiveHostileMobs = builder.comment("Hostile day mobs will no longer attack players on sight [default: false]").define("passiveHostileMobs", false);
            this.friendlyPersistence = builder.comment("Stop befriended mobs from despawning [Default: false]").define("friendlyPersistence", false);
            builder.pop();
            builder.comment("Attribute settings").push("Attributes");
            builder.comment("Tier 1").push("Tier1");
            this.tier1maxHealth = builder.comment("Defines the health of Tier 1 Gaia mobs [40 = 20 Hearts]").defineInRange("tier1maxHealth", 40, 1, Integer.MAX_VALUE);
            this.tier1attackDamage = builder.comment("Defines the attack damage of Tier 1 Gaia mobs [4 = 2 Hearts]").defineInRange("tier1attackDamage", 4, 1, Integer.MAX_VALUE);
            this.tier1baseDefense = builder.comment("Defines the maximum amount of hits required to defeat Tier 1 Gaia mobs (0 = disable)").defineInRange("tier1baseDefense", 2, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("Tier 2").push("Tier2");
            this.tier2maxHealth = builder.comment("Defines the health of Tier 2 Gaia mobs [80 = 40 Hearts]").defineInRange("tier2maxHealth", 80, 1, Integer.MAX_VALUE);
            this.tier2attackDamage = builder.comment("Defines the attack damage of Tier 2 Gaia mobs [8 = 4 Hearts]").defineInRange("tier2attackDamage", 8, 1, Integer.MAX_VALUE);
            this.tier2baseDefense = builder.comment("Defines the maximum amount of hits required to defeat Tier 2 Gaia mobs (0 = disable)").defineInRange("tier2baseDefense", 4, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("Tier 3").push("Tier3");
            this.tier3maxHealth = builder.comment("Defines the health of Tier 3 Gaia mobs [160 = 80 Hearts]").defineInRange("tier3maxHealth", 160, 1, Integer.MAX_VALUE);
            this.tier3attackDamage = builder.comment("Defines the attack damage of Tier 3 Gaia mobs [12 = 6 Hearts]").defineInRange("tier3attackDamage", 12, 1, Integer.MAX_VALUE);
            this.tier3baseDefense = builder.comment("Defines the maximum amount of hits required to defeat Tier 3 Gaia mobs (0 = disable)").defineInRange("tier3baseDefense", 8, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.pop();
            builder.comment("Damage settings").push("Damage");
            this.baseDamage = builder.comment("Melee attacks deal an additional 2.0 (1 heart) of damage [Default: true]").define("baseDamage", true);
            this.shieldsBlockPiercing = builder.comment("Archers arrows deal an additional 1 (0.5 heart) of damage. [Default: true]").define("baseDamage", true);
            this.baseDamageArchers = builder.comment("Base Damage (melee) won't penetrate Shields. [Default: true]").define("shieldsBlockPiercing", true);
            builder.pop();
            builder.comment("Spawn settings").push("Spawn");
            this.spawnDaysPassed = builder.comment("Mobs only spawn after a certain amount of days have passed [Default: false]").define("spawnDaysPassed", false);
            this.spawnDaysSet = builder.comment("Amount of days required to have passed before they can start spawning [Default: 3]").defineInRange("spawnDaysSet", 3, 1, Integer.MAX_VALUE);
            this.spawnLevel3Rain = builder.comment("Level 3 mobs only spawn when it is raining/snowing [Default: false]").define("spawnLevel3Rain", false);
            this.disableYRestriction = builder.comment("Remove spawn conditions related to height (Y-axis) [Default: false]").define("disableYRestriction", false);
            this.spawnWeather = builder.comment("Remove spawn conditions related to weather [Default: false]").define("spawnWeather", false);
            builder.pop();
        }
    }
}

