/*
 * Decompiled with CFR 0.152.
 */
package gaia.datagen;

import gaia.datagen.client.GaiaBlockModels;
import gaia.datagen.client.GaiaBlockstates;
import gaia.datagen.client.GaiaItemModels;
import gaia.datagen.client.GaiaLanguage;
import gaia.datagen.client.GaiaSoundProvider;
import gaia.datagen.client.compat.GaiaPatchouliProvider;
import gaia.datagen.server.GaiaAdvancementProvider;
import gaia.datagen.server.GaiaBiomeModifiers;
import gaia.datagen.server.GaiaBlockTags;
import gaia.datagen.server.GaiaEntityTags;
import gaia.datagen.server.GaiaItemTags;
import gaia.datagen.server.GaiaLoot;
import gaia.datagen.server.GaiaRecipes;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Cloner;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.registries.VanillaRegistries;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.DataPackRegistriesHooks;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class GaiaDatagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture<HolderLookup.Provider> lookupProvider = CompletableFuture.supplyAsync(() -> GaiaDatagen.getProvider().full());
        ExistingFileHelper helper = event.getExistingFileHelper();
        if (event.includeServer()) {
            generator.addProvider(true, (DataProvider)new GaiaAdvancementProvider(packOutput, lookupProvider, helper));
            generator.addProvider(true, (DataProvider)new GaiaRecipes(packOutput, lookupProvider));
            generator.addProvider(true, (DataProvider)new GaiaLoot(packOutput, lookupProvider));
            GaiaBlockTags blockTagsProvider = new GaiaBlockTags(packOutput, lookupProvider, helper);
            generator.addProvider(true, (DataProvider)blockTagsProvider);
            generator.addProvider(true, (DataProvider)new GaiaItemTags(packOutput, lookupProvider, blockTagsProvider, helper));
            generator.addProvider(true, (DataProvider)new GaiaEntityTags(packOutput, lookupProvider, helper));
            generator.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(packOutput, CompletableFuture.supplyAsync(GaiaDatagen::getProvider), Set.of("grimoireofgaia")));
        }
        if (event.includeClient()) {
            generator.addProvider(true, (DataProvider)new GaiaLanguage(packOutput));
            generator.addProvider(true, (DataProvider)new GaiaSoundProvider(packOutput, helper));
            generator.addProvider(true, (DataProvider)new GaiaBlockModels(packOutput, helper));
            generator.addProvider(true, (DataProvider)new GaiaItemModels(packOutput, helper));
            generator.addProvider(true, (DataProvider)new GaiaBlockstates(packOutput, helper));
            if (ModList.get().isLoaded("patchouli")) {
                generator.addProvider(true, (DataProvider)new GaiaPatchouliProvider(packOutput, lookupProvider));
            }
        }
    }

    private static RegistrySetBuilder.PatchedRegistries getProvider() {
        RegistrySetBuilder registryBuilder = new RegistrySetBuilder();
        registryBuilder.add(Registries.CONFIGURED_FEATURE, context -> {});
        registryBuilder.add(Registries.PLACED_FEATURE, context -> {});
        registryBuilder.add(NeoForgeRegistries.Keys.BIOME_MODIFIERS, GaiaBiomeModifiers::bootstrap);
        RegistryAccess.Frozen regAccess = RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY);
        Cloner.Factory cloner$factory = new Cloner.Factory();
        DataPackRegistriesHooks.getDataPackRegistriesWithDimensions().forEach(data -> data.runWithArguments((arg_0, arg_1) -> ((Cloner.Factory)cloner$factory).addCodec(arg_0, arg_1)));
        return registryBuilder.buildPatch((RegistryAccess)regAccess, VanillaRegistries.createLookup(), cloner$factory);
    }
}

