/*
 * Decompiled with CFR 0.152.
 */
package gaia.datagen.client;

import gaia.item.MerchantSpawnItem;
import gaia.registry.GaiaRegistry;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.common.DeferredSpawnEggItem;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;

public class GaiaItemModels
extends ItemModelProvider {
    public GaiaItemModels(PackOutput packOutput, ExistingFileHelper existingFileHelper) {
        super(packOutput, "grimoireofgaia", existingFileHelper);
    }

    protected void registerModels() {
        for (DeferredHolder item : GaiaRegistry.ITEMS.getEntries()) {
            if (item.get() instanceof MerchantSpawnItem) {
                this.spawnItem((DeferredHolder<Item, ? extends Item>)item);
                continue;
            }
            if (!(item.get() instanceof DeferredSpawnEggItem)) continue;
            this.withExistingParent(item.getId().getPath(), ResourceLocation.parse((String)"item/template_spawn_egg"));
        }
        this.withBlockParent((DeferredHolder<Block, ? extends Block>)GaiaRegistry.BUST_GORGON);
        this.withBlockParent((DeferredHolder<Block, ? extends Block>)GaiaRegistry.BUST_MINOTAUR);
        this.withBlockParent((DeferredHolder<Block, ? extends Block>)GaiaRegistry.BUST_SPHINX);
        this.withBlockParent((DeferredHolder<Block, ? extends Block>)GaiaRegistry.BUST_VALKYRIE);
        this.withBlockParent((DeferredHolder<Block, ? extends Block>)GaiaRegistry.BUST_VAMPIRE);
        this.withBlockParent((DeferredHolder<Block, ? extends Block>)GaiaRegistry.DECO_GARDEN_GNOME);
        this.withBlockParent((DeferredHolder<Block, ? extends Block>)GaiaRegistry.DECO_MANDRAGORA_POT);
        this.withBlockParent((DeferredHolder<Block, ? extends Block>)GaiaRegistry.DECO_NEST_HARPY);
        this.withBlockParent((DeferredHolder<Block, ? extends Block>)GaiaRegistry.DOLL_CREEPER_GIRL);
        this.withBlockParent((DeferredHolder<Block, ? extends Block>)GaiaRegistry.DOLL_DRYAD);
        this.withBlockParent((DeferredHolder<Block, ? extends Block>)GaiaRegistry.DOLL_DULLAHAN);
        this.withBlockParent((DeferredHolder<Block, ? extends Block>)GaiaRegistry.DOLL_ENDER_GIRL);
        this.withBlockParent((DeferredHolder<Block, ? extends Block>)GaiaRegistry.DOLL_MAID);
        this.withBlockParent((DeferredHolder<Block, ? extends Block>)GaiaRegistry.DOLL_MERMAID);
        this.withBlockParent((DeferredHolder<Block, ? extends Block>)GaiaRegistry.DOLL_NINE_TAILS);
        this.withBlockParent((DeferredHolder<Block, ? extends Block>)GaiaRegistry.DOLL_SLIME_GIRL);
        this.withBlockParent((DeferredHolder<Block, ? extends Block>)GaiaRegistry.PEARL_BLOCK);
        this.generatedItem((DeferredHolder<Item, ? extends Item>)GaiaRegistry.BOOK_OF_MEMORY);
        this.generatedBook((DeferredHolder<Item, ? extends Item>)GaiaRegistry.WEAPON_BOOK_FREEZING);
        this.generatedBook((DeferredHolder<Item, ? extends Item>)GaiaRegistry.WEAPON_BOOK_NIGHTMARE);
        this.generatedBook((DeferredHolder<Item, ? extends Item>)GaiaRegistry.WEAPON_BOOK_METAL);
        this.generatedBook((DeferredHolder<Item, ? extends Item>)GaiaRegistry.WEAPON_BOOK_ENDER);
        this.generatedBook((DeferredHolder<Item, ? extends Item>)GaiaRegistry.WEAPON_BOOK_HUNGER);
        this.generatedBook((DeferredHolder<Item, ? extends Item>)GaiaRegistry.WEAPON_BOOK_BATTLE);
        this.generatedBook((DeferredHolder<Item, ? extends Item>)GaiaRegistry.WEAPON_BOOK_NATURE);
        this.generatedBook((DeferredHolder<Item, ? extends Item>)GaiaRegistry.WEAPON_BOOK_WITHER);
        this.generatedBook((DeferredHolder<Item, ? extends Item>)GaiaRegistry.WEAPON_BOOK_BUFF);
        this.handheldItem((DeferredHolder<Item, ? extends Item>)GaiaRegistry.CURSED_METAL_SWORD, "weapon");
        this.handheldItem((DeferredHolder<Item, ? extends Item>)GaiaRegistry.METAL_CLUB, "weapon");
        this.generatedItem((DeferredHolder<Item, ? extends Item>)GaiaRegistry.EXPERIENCE_IRON);
        this.generatedItem((DeferredHolder<Item, ? extends Item>)GaiaRegistry.EXPERIENCE_GOLD);
        this.generatedItem((DeferredHolder<Item, ? extends Item>)GaiaRegistry.EXPERIENCE_DIAMOND);
        this.generatedItem((DeferredHolder<Item, ? extends Item>)GaiaRegistry.ELYTRA_FRAGMENT);
        this.generatedItem((DeferredHolder<Item, ? extends Item>)GaiaRegistry.TOTEM_FRAGMENT);
        this.generatedItem((DeferredHolder<Item, ? extends Item>)GaiaRegistry.DIAMOND_SHARD);
        this.generatedItem((DeferredHolder<Item, ? extends Item>)GaiaRegistry.EMERALD_SHARD);
        this.generatedItem((DeferredHolder<Item, ? extends Item>)GaiaRegistry.SHINY_PEARL);
        this.generatedItem((DeferredHolder<Item, ? extends Item>)GaiaRegistry.FIRESHARD);
        this.generatedItem((DeferredHolder<Item, ? extends Item>)GaiaRegistry.FUR);
        this.generatedItem((DeferredHolder<Item, ? extends Item>)GaiaRegistry.GIGA_GEAR);
        this.generatedItem((DeferredHolder<Item, ? extends Item>)GaiaRegistry.GOLDEN_APPLE_PIE);
        this.generatedItem((DeferredHolder<Item, ? extends Item>)GaiaRegistry.GOLDEN_APPLE_PIE_SLICE);
        this.generatedItem((DeferredHolder<Item, ? extends Item>)GaiaRegistry.MANDRAKE);
        this.generatedItem((DeferredHolder<Item, ? extends Item>)GaiaRegistry.HONEYDEW);
        this.generatedItem((DeferredHolder<Item, ? extends Item>)GaiaRegistry.KNUCKLES, "accessory");
        this.generatedItem((DeferredHolder<Item, ? extends Item>)GaiaRegistry.RING_OF_SPEED, "accessory");
        this.generatedItem((DeferredHolder<Item, ? extends Item>)GaiaRegistry.RING_OF_HASTE, "accessory");
        this.generatedItem((DeferredHolder<Item, ? extends Item>)GaiaRegistry.RING_OF_JUMP, "accessory");
        this.generatedItem((DeferredHolder<Item, ? extends Item>)GaiaRegistry.RING_OF_NIGHT, "accessory");
        this.generatedItem((DeferredHolder<Item, ? extends Item>)GaiaRegistry.HEAVY_BARBELL, "accessory");
        this.generatedItem((DeferredHolder<Item, ? extends Item>)GaiaRegistry.MEAT);
        this.generatedItem((DeferredHolder<Item, ? extends Item>)GaiaRegistry.MONSTER_FEED);
        this.generatedItem((DeferredHolder<Item, ? extends Item>)GaiaRegistry.PREMIUM_MONSTER_FEED);
        this.handheldItem((DeferredHolder<Item, ? extends Item>)GaiaRegistry.METAL_DAGGER, "weapon");
        this.generatedItem((DeferredHolder<Item, ? extends Item>)GaiaRegistry.QUILL);
        this.generatedItem((DeferredHolder<Item, ? extends Item>)GaiaRegistry.ROTTEN_HEART);
        this.generatedItem((DeferredHolder<Item, ? extends Item>)GaiaRegistry.SOULFIRE);
        this.generatedItem((DeferredHolder<Item, ? extends Item>)GaiaRegistry.STONE_COAL);
        this.generatedItem((DeferredHolder<Item, ? extends Item>)GaiaRegistry.TAPROOT);
        this.handheldItem((DeferredHolder<Item, ? extends Item>)GaiaRegistry.ZOMBIE_STAFF, "weapon", "summoning_staff");
        this.handheldItem((DeferredHolder<Item, ? extends Item>)GaiaRegistry.SKELETON_STAFF, "weapon", "summoning_staff");
        this.handheldItem((DeferredHolder<Item, ? extends Item>)GaiaRegistry.CAVE_SPIDER_STAFF, "weapon", "summoning_staff");
        this.handheldItem((DeferredHolder<Item, ? extends Item>)GaiaRegistry.MAGIC_STAFF, "weapon", "summoning_staff");
        this.parentItem((DeferredHolder<Item, ? extends Item>)GaiaRegistry.FAN_FIRE, this.modLoc("item/fan"), "weapon/fan");
        this.parentItem((DeferredHolder<Item, ? extends Item>)GaiaRegistry.FAN_ICE, this.modLoc("item/fan"), "weapon/fan");
        this.generatedItem((DeferredHolder<Item, ? extends Item>)GaiaRegistry.NETHER_WART_JAM);
        this.generatedItem((DeferredHolder<Item, ? extends Item>)GaiaRegistry.WITHERED_BRAIN);
        this.generatedBox((DeferredHolder<Item, ? extends Item>)GaiaRegistry.BOX_DIAMOND);
        this.generatedBox((DeferredHolder<Item, ? extends Item>)GaiaRegistry.BOX_END);
        this.generatedBox((DeferredHolder<Item, ? extends Item>)GaiaRegistry.BOX_GOLD);
        this.generatedBox((DeferredHolder<Item, ? extends Item>)GaiaRegistry.BOX_IRON);
        this.generatedBox((DeferredHolder<Item, ? extends Item>)GaiaRegistry.BOX_NETHER);
        this.generatedBox((DeferredHolder<Item, ? extends Item>)GaiaRegistry.BOX_OVERWORLD);
        this.generatedBox((DeferredHolder<Item, ? extends Item>)GaiaRegistry.CHEST_DESERT);
        this.generatedBox((DeferredHolder<Item, ? extends Item>)GaiaRegistry.CHEST_DUNGEON);
        this.generatedBox((DeferredHolder<Item, ? extends Item>)GaiaRegistry.CHEST_JUNGLE);
        this.generatedItem((DeferredHolder<Item, ? extends Item>)GaiaRegistry.BAG_ARROWS, "bag");
        this.generatedItem((DeferredHolder<Item, ? extends Item>)GaiaRegistry.BAG_BOOK, "bag");
        this.generatedItem((DeferredHolder<Item, ? extends Item>)GaiaRegistry.BAG_RECORD, "bag");
        this.generatedItem((DeferredHolder<Item, ? extends Item>)GaiaRegistry.BOX_HAT, "box");
        this.generatedItem((DeferredHolder<Item, ? extends Item>)GaiaRegistry.BOX_OLD, "box");
        this.generatedItem((DeferredHolder<Item, ? extends Item>)GaiaRegistry.BOX_EGG, "spawn");
        this.generatedItem((DeferredHolder<Item, ? extends Item>)GaiaRegistry.TRADER_TOKEN);
        this.generatedItem((DeferredHolder<Item, ? extends Item>)GaiaRegistry.HOLSTAURUS_TOKEN);
        this.generatedItem((DeferredHolder<Item, ? extends Item>)GaiaRegistry.WERESHEEP_TOKEN);
    }

    private void withBlockParent(DeferredHolder<Block, ? extends Block> registryObject) {
        ResourceLocation location = registryObject.getId();
        this.withExistingParent(location.getPath(), this.modLoc("block/" + location.getPath()));
    }

    private void generatedItem(DeferredHolder<Item, ? extends Item> registryObject) {
        ResourceLocation location = registryObject.getId();
        this.singleTexture(location.getPath(), ResourceLocation.parse((String)"item/generated"), "layer0", ResourceLocation.fromNamespaceAndPath((String)"grimoireofgaia", (String)("item/" + location.getPath())));
    }

    private void spawnItem(DeferredHolder<Item, ? extends Item> registryObject) {
        ResourceLocation location = registryObject.getId();
        this.singleTexture(location.getPath(), ResourceLocation.parse((String)"item/generated"), "layer0", ResourceLocation.fromNamespaceAndPath((String)"grimoireofgaia", (String)("item/spawn/" + location.getPath())));
    }

    private void handheldItem(DeferredHolder<Item, ? extends Item> registryObject, String subFolder) {
        ResourceLocation location = registryObject.getId();
        this.singleTexture(location.getPath(), ResourceLocation.parse((String)"item/handheld"), "layer0", ResourceLocation.fromNamespaceAndPath((String)"grimoireofgaia", (String)("item/" + subFolder + "/" + location.getPath())));
    }

    private void handheldItem(DeferredHolder<Item, ? extends Item> registryObject, String subFolder, String textureName) {
        ResourceLocation location = registryObject.getId();
        this.singleTexture(location.getPath(), ResourceLocation.parse((String)"item/handheld"), "layer0", ResourceLocation.fromNamespaceAndPath((String)"grimoireofgaia", (String)("item/" + subFolder + "/" + textureName)));
    }

    private void generatedItem(DeferredHolder<Item, ? extends Item> registryObject, String subFolder) {
        ResourceLocation location = registryObject.getId();
        this.singleTexture(location.getPath(), ResourceLocation.parse((String)"item/generated"), "layer0", ResourceLocation.fromNamespaceAndPath((String)"grimoireofgaia", (String)("item/" + subFolder + "/" + location.getPath())));
    }

    private void parentItem(DeferredHolder<Item, ? extends Item> registryObject, ResourceLocation parent, String subFolder) {
        ResourceLocation location = registryObject.getId();
        this.singleTexture(location.getPath(), parent, "0", ResourceLocation.fromNamespaceAndPath((String)"grimoireofgaia", (String)("item/" + subFolder + "/" + location.getPath())));
    }

    private void generatedBox(DeferredHolder<Item, ? extends Item> registryObject) {
        ResourceLocation location = registryObject.getId();
        this.singleTexture(location.getPath(), ResourceLocation.fromNamespaceAndPath((String)"grimoireofgaia", (String)"item/chest"), "0", ResourceLocation.fromNamespaceAndPath((String)"grimoireofgaia", (String)("item/box/" + location.getPath())));
    }

    private void generatedBook(DeferredHolder<Item, ? extends Item> registryObject) {
        ResourceLocation location = registryObject.getId();
        this.singleTexture(location.getPath(), ResourceLocation.fromNamespaceAndPath((String)"grimoireofgaia", (String)"item/weapon_book"), "0", ResourceLocation.fromNamespaceAndPath((String)"grimoireofgaia", (String)("item/weapon/book/" + location.getPath())));
    }
}

