/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity;

import gaia.attachment.AttachmentHandler;
import gaia.attachment.friended.Friended;
import gaia.attachment.friended.IFriended;
import gaia.config.GaiaConfig;
import gaia.entity.AbstractAssistGaiaEntity;
import gaia.entity.GaiaHorse;
import gaia.entity.type.IDayMob;
import gaia.registry.GaiaRegistry;
import gaia.util.SharedEntityData;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.ItemAbilities;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractGaiaEntity
extends Monster {
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.defineId(AbstractGaiaEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected Goal targetPlayerGoal;
    protected final Goal targetMobGoal = new NearestAttackableTargetGoal((Mob)this, Mob.class, 5, false, false, livingEntity -> {
        AbstractAssistGaiaEntity assistMob;
        return livingEntity instanceof Enemy && !(livingEntity instanceof Creeper) && livingEntity instanceof AbstractAssistGaiaEntity && (assistMob = (AbstractAssistGaiaEntity)((Object)livingEntity)).isAngryAt((LivingEntity)this);
    });

    public AbstractGaiaEntity(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.xpReward = 10;
    }

    public void finalizeAttributes() {
        switch (this.getGaiaLevel()) {
            default: {
                this.getAttribute(Attributes.MAX_HEALTH).setBaseValue((double)SharedEntityData.getMaxHealth1());
                this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue((double)SharedEntityData.getAttackDamage1());
                break;
            }
            case 2: {
                this.getAttribute(Attributes.MAX_HEALTH).setBaseValue((double)SharedEntityData.getMaxHealth2());
                this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue((double)SharedEntityData.getAttackDamage2());
                break;
            }
            case 3: {
                this.getAttribute(Attributes.MAX_HEALTH).setBaseValue((double)SharedEntityData.getMaxHealth3());
                this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue((double)SharedEntityData.getAttackDamage3());
            }
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT, (Object)0);
    }

    public int getGaiaLevel() {
        return 1;
    }

    public int getVariant() {
        return (Integer)this.entityData.get(VARIANT);
    }

    public void setVariant(int index) {
        this.entityData.set(VARIANT, (Object)Mth.clamp((int)index, (int)0, (int)this.maxVariants()));
    }

    public int maxVariants() {
        return 0;
    }

    public abstract float getBaseDefense();

    protected float getBaseDamage(DamageSource source, float damage) {
        if (this.getBaseDefense() > 0.0f) {
            return source.is(DamageTypes.FELL_OUT_OF_WORLD) ? damage : Math.min(damage, this.getBaseDefense());
        }
        return damage;
    }

    protected void spawnLingeringCloud(List<MobEffectInstance> effectInstances) {
        if (!effectInstances.isEmpty()) {
            AreaEffectCloud areaeffectcloud = new AreaEffectCloud(this.level(), this.getX(), this.getY(), this.getZ());
            areaeffectcloud.setRadius(2.5f);
            areaeffectcloud.setRadiusOnUse(-0.5f);
            areaeffectcloud.setWaitTime(10);
            areaeffectcloud.setDuration(areaeffectcloud.getDuration() / 2);
            areaeffectcloud.setRadiusPerTick(-areaeffectcloud.getRadius() / (float)areaeffectcloud.getDuration());
            for (MobEffectInstance mobeffectinstance : effectInstances) {
                areaeffectcloud.addEffect(new MobEffectInstance(mobeffectinstance));
            }
            this.level().addFreshEntity((Entity)areaeffectcloud);
        }
    }

    protected GaiaHorse createHorse(DifficultyInstance difficulty) {
        Entity entity = GaiaRegistry.HORSE.getEntityType().create(this.level());
        if (entity instanceof GaiaHorse) {
            GaiaHorse horse = (GaiaHorse)entity;
            horse.finalizeSpawn((ServerLevelAccessor)((ServerLevel)this.level()), difficulty, MobSpawnType.JOCKEY, null);
            horse.setPos(this.getX(), this.getY(), this.getZ());
            horse.setTamed(true);
            horse.setAge(0);
            this.level().addFreshEntity((Entity)horse);
            return horse;
        }
        return null;
    }

    protected static boolean isHalloween() {
        LocalDate localdate = LocalDate.now();
        int i = localdate.get(ChronoField.DAY_OF_MONTH);
        int j = localdate.get(ChronoField.MONTH_OF_YEAR);
        return j == 10 && i >= 20 || j == 11 && i <= 3;
    }

    protected boolean playerDetection(int range, TargetingConditions conditions) {
        AABB box = new AABB(this.getX(), this.getY(), this.getZ(), this.getX() + 1.0, this.getY() + 1.0, this.getZ() + 1.0).inflate((double)range);
        List list = this.level().getNearbyPlayers(conditions, (LivingEntity)this, box);
        return !list.isEmpty();
    }

    protected void beaconMonster(int range, Consumer<LivingEntity> action) {
        if (!this.level().isClientSide) {
            AABB aabb = new AABB(this.getX(), this.getY(), this.getZ(), this.getX() + 1.0, this.getY() + 1.0, this.getZ() + 1.0).inflate((double)range);
            List entities = this.level().getEntitiesOfClass(LivingEntity.class, aabb);
            for (LivingEntity livingEntity : entities) {
                action.accept(livingEntity);
            }
        }
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData data) {
        data = super.finalizeSpawn(levelAccessor, difficultyInstance, spawnType, data);
        this.finalizeAttributes();
        switch (this.getGaiaLevel()) {
            default: {
                AttributeInstance damageAttribute;
                AttributeInstance healthAttribute = this.getAttribute(Attributes.MAX_HEALTH);
                if (healthAttribute != null) {
                    healthAttribute.setBaseValue((double)SharedEntityData.getMaxHealth1());
                }
                if ((damageAttribute = this.getAttribute(Attributes.ATTACK_DAMAGE)) == null) break;
                damageAttribute.setBaseValue((double)SharedEntityData.getAttackDamage1());
                break;
            }
            case 2: {
                AttributeInstance damageAttribute;
                AttributeInstance healthAttribute = this.getAttribute(Attributes.MAX_HEALTH);
                if (healthAttribute != null) {
                    healthAttribute.setBaseValue((double)SharedEntityData.getMaxHealth2());
                }
                if ((damageAttribute = this.getAttribute(Attributes.ATTACK_DAMAGE)) == null) break;
                damageAttribute.setBaseValue((double)SharedEntityData.getAttackDamage2());
                break;
            }
            case 3: {
                AttributeInstance damageAttribute;
                AttributeInstance healthAttribute = this.getAttribute(Attributes.MAX_HEALTH);
                if (healthAttribute != null) {
                    healthAttribute.setBaseValue((double)SharedEntityData.getMaxHealth3());
                }
                if ((damageAttribute = this.getAttribute(Attributes.ATTACK_DAMAGE)) == null) break;
                damageAttribute.setBaseValue((double)SharedEntityData.getAttackDamage3());
            }
        }
        this.setHealth(this.getMaxHealth());
        if (((Boolean)GaiaConfig.COMMON.passiveHostileMobs.get()).booleanValue()) {
            this.goalSelector.removeGoal(this.targetPlayerGoal);
        }
        return data;
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("Variant", this.getVariant());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("Variant")) {
            int variant = tag.getInt("Variant");
            this.setVariant(variant);
        }
        this.setupFriendGoals(this.isFriendly());
    }

    public boolean isFriendly() {
        return AttachmentHandler.getFriended((LivingEntity)this).isFriendly();
    }

    public void setFriendly(boolean value, UUID friendedBy) {
        Friended friended = AttachmentHandler.getFriended((LivingEntity)this);
        this.setTarget(null);
        friended.setFriendly(value);
        friended.setFriendedBy(friendedBy);
        this.setupFriendGoals(value);
        if (((Boolean)GaiaConfig.COMMON.friendlyPersistence.get()).booleanValue()) {
            this.setPersistenceRequired();
        }
    }

    protected void setupFriendGoals(boolean friendly) {
        if (this.targetPlayerGoal == null) {
            this.targetPlayerGoal = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
        }
        switch (this.getGaiaLevel()) {
            case 1: {
                if (friendly) {
                    this.targetSelector.removeGoal(this.targetPlayerGoal);
                    this.targetSelector.addGoal(2, this.targetMobGoal);
                    break;
                }
                this.targetSelector.removeGoal(this.targetMobGoal);
                if (this instanceof AbstractAssistGaiaEntity) {
                    if (!((Boolean)GaiaConfig.COMMON.allPassiveMobsHostile.get()).booleanValue()) break;
                    this.targetSelector.addGoal(2, this.targetPlayerGoal);
                    break;
                }
                if (((Boolean)GaiaConfig.COMMON.passiveHostileMobs.get()).booleanValue()) break;
                this.targetSelector.addGoal(2, this.targetPlayerGoal);
                break;
            }
            case 2: {
                if (friendly) {
                    this.targetSelector.removeGoal(this.targetPlayerGoal);
                    break;
                }
                if (this instanceof AbstractAssistGaiaEntity) {
                    if (!((Boolean)GaiaConfig.COMMON.allPassiveMobsHostile.get()).booleanValue()) break;
                    this.targetSelector.addGoal(2, this.targetPlayerGoal);
                    break;
                }
                if (((Boolean)GaiaConfig.COMMON.passiveHostileMobs.get()).booleanValue()) break;
                this.targetSelector.addGoal(2, this.targetPlayerGoal);
            }
        }
    }

    public void aiStep() {
        Friended friended = AttachmentHandler.getFriended((LivingEntity)this);
        if (friended.isChanged()) {
            this.onFriendlyChange(friended);
            friended.setChanged(false);
        }
        super.aiStep();
    }

    public void onFriendlyChange(IFriended cap) {
    }

    public double getMyRidingOffset() {
        return this.isBaby() ? 0.0 : -0.6;
    }

    public void rideTick() {
        super.rideTick();
        Entity entity = this.getVehicle();
        if (entity instanceof PathfinderMob) {
            PathfinderMob pathfindermob = (PathfinderMob)entity;
            this.yBodyRot = pathfindermob.yBodyRot;
        }
    }

    public boolean canAttackType(EntityType<?> type) {
        if (this instanceof AbstractAssistGaiaEntity) {
            return type != this.getType() && type != EntityType.CREEPER && super.canAttackType(type);
        }
        return super.canAttackType(type);
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader levelReader) {
        return this instanceof IDayMob ? 0.0f : super.getWalkTargetValue(pos, levelReader);
    }

    public static boolean checkGaiaDaySpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return AbstractGaiaEntity.checkDaylight(levelAccessor, pos) && AbstractGaiaEntity.checkAnyLightMonsterSpawnRules(entityType, (LevelAccessor)levelAccessor, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    protected static boolean checkDaylight(ServerLevelAccessor levelAccessor, BlockPos pos) {
        return levelAccessor.canSeeSky(pos) && levelAccessor.getBrightness(LightLayer.BLOCK, pos) == 0;
    }

    protected static boolean checkUnderwaterDaylight(ServerLevelAccessor levelAccessor, BlockPos pos) {
        return levelAccessor.canSeeSkyFromBelowWater(pos) && levelAccessor.getBrightness(LightLayer.BLOCK, pos) == 0;
    }

    protected static boolean checkAboveSeaLevel(ServerLevelAccessor levelAccessor, BlockPos pos) {
        return AbstractGaiaEntity.checkAboveY(pos, levelAccessor.getSeaLevel());
    }

    protected static boolean checkAboveY(BlockPos pos, int yLevel) {
        return (Boolean)GaiaConfig.COMMON.disableYRestriction.get() != false || pos.getY() > yLevel;
    }

    protected static boolean checkBelowSeaLevel(ServerLevelAccessor levelAccessor, BlockPos pos) {
        return AbstractGaiaEntity.checkBelowY(pos, levelAccessor.getSeaLevel());
    }

    public static boolean checkInWater(LevelAccessor levelAccessor, BlockPos pos, int yOffset) {
        int seaLevel = levelAccessor.getSeaLevel();
        int belowSeaLevel = seaLevel - yOffset;
        boolean below = pos.getY() <= belowSeaLevel;
        boolean inWater = levelAccessor.getFluidState(pos.below()).is(FluidTags.WATER) && levelAccessor.getBlockState(pos.above()).is(Blocks.WATER);
        return below && inWater;
    }

    public static boolean checkNotPeaceful(LevelAccessor levelAccessor) {
        return levelAccessor.getDifficulty() != Difficulty.PEACEFUL;
    }

    public static boolean checkSpawner(LevelAccessor levelAccessor) {
        return levelAccessor.getDifficulty() != Difficulty.PEACEFUL;
    }

    protected static boolean checkBelowY(BlockPos pos, int yLevel) {
        return (Boolean)GaiaConfig.COMMON.disableYRestriction.get() != false || pos.getY() < yLevel;
    }

    protected static boolean checkTagBlocks(ServerLevelAccessor levelAccessor, BlockPos pos, TagKey<Block> blockTag) {
        return levelAccessor.getBlockState(pos.below()).is(blockTag);
    }

    protected static boolean checkDaytime(ServerLevelAccessor levelAccessor) {
        return !levelAccessor.dimensionType().hasFixedTime() && levelAccessor.getSkyDarken() < 4;
    }

    protected static boolean checkRaining(ServerLevelAccessor levelAccessor) {
        return (Boolean)GaiaConfig.COMMON.spawnWeather.get() != false || levelAccessor.getLevelData().isRaining();
    }

    protected static boolean checkDaysPassed(ServerLevelAccessor levelAccessor) {
        if (((Boolean)GaiaConfig.COMMON.spawnDaysPassed.get()).booleanValue()) {
            return (int)(levelAccessor.dayTime() / 24000L) >= (Integer)GaiaConfig.COMMON.spawnDaysSet.get();
        }
        return true;
    }

    protected boolean hasShield() {
        ItemStack offStack = this.getItemBySlot(EquipmentSlot.OFFHAND);
        return offStack.canPerformAction(ItemAbilities.SHIELD_BLOCK);
    }
}

