/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity;

import gaia.entity.AbstractGaiaEntity;
import gaia.entity.goal.MobAttackGoal;
import gaia.registry.GaiaRegistry;
import gaia.util.RangedUtil;
import gaia.util.SharedEntityData;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class Anubis
extends AbstractGaiaEntity
implements RangedAttackMob {
    private static final EntityDataAccessor<Boolean> MALE = SynchedEntityData.defineId(Anubis.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> ANIMATION_STATE = SynchedEntityData.defineId(Anubis.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private final RangedAttackGoal rangedAttackGoal = new RangedAttackGoal((RangedAttackMob)this, 1.275, 20, 60, 15.0f);
    private final MobAttackGoal mobAttackGoal = new MobAttackGoal((PathfinderMob)this, 1.275, true);
    private int switchHealth;
    private int spawn;
    private int spawnTimer;
    private boolean animationPlay;
    private int animationTimer;

    public Anubis(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.xpReward = 20;
        this.switchHealth = 0;
        this.spawn = 0;
        this.spawnTimer = 0;
        this.animationPlay = false;
        this.animationTimer = 0;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetPlayerGoal = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
        this.targetSelector.addGoal(2, this.targetPlayerGoal);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 80.0).add(Attributes.FOLLOW_RANGE, 26.0).add(Attributes.MOVEMENT_SPEED, 0.275).add(Attributes.ATTACK_DAMAGE, 8.0).add(Attributes.ARMOR, 8.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.25).add(Attributes.STEP_HEIGHT, 1.0);
    }

    @Override
    public int getGaiaLevel() {
        return 2;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(MALE, (Object)false);
        builder.define(ANIMATION_STATE, (Object)0);
    }

    public boolean isMale() {
        return (Boolean)this.entityData.get(MALE);
    }

    public void setMale(boolean flag) {
        this.entityData.set(MALE, (Object)flag);
    }

    public int getAnimationState() {
        return (Integer)this.entityData.get(ANIMATION_STATE);
    }

    public void setAnimationState(int state) {
        this.entityData.set(ANIMATION_STATE, (Object)state);
    }

    @Override
    public float getBaseDefense() {
        return SharedEntityData.getBaseDefense2();
    }

    public boolean hurt(DamageSource source, float damage) {
        float input = this.getBaseDamage(source, damage);
        return super.hurt(source, input);
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        if (target.isAlive()) {
            RangedUtil.magic(target, (LivingEntity)this, distanceFactor);
            this.setAnimationState(1);
            this.animationPlay = true;
            this.animationTimer = 0;
        }
    }

    public boolean doHurtTarget(Entity entityIn) {
        if (super.doHurtTarget(entityIn)) {
            if (entityIn instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entityIn;
                int effectTime = 0;
                if (this.level().getDifficulty() == Difficulty.NORMAL) {
                    effectTime = 5;
                } else if (this.level().getDifficulty() == Difficulty.HARD) {
                    effectTime = 10;
                }
                if (effectTime > 0) {
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, effectTime * 20, 0));
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, effectTime * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void aiStep() {
        this.beaconMonster(6, entity -> {
            if (entity instanceof Zombie || entity instanceof Skeleton) {
                entity.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 300, 1, true, true));
            }
        });
        if (this.getHealth() < this.getMaxHealth() * 0.75f && this.switchHealth == 0) {
            this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)GaiaRegistry.METAL_DAGGER.get()));
            this.setGoals(1);
            this.switchHealth = 1;
        }
        if (this.getHealth() > this.getMaxHealth() * 0.75f && this.switchHealth == 1) {
            this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)GaiaRegistry.SKELETON_STAFF.get()));
            this.setGoals(0);
            this.switchHealth = 0;
        }
        if (this.getHealth() < this.getMaxHealth() * 0.75f && this.getHealth() > 0.0f && this.spawn == 0) {
            this.setAnimationState(2);
            if (this.spawnTimer != 30) {
                ++this.spawnTimer;
            }
            if (this.spawnTimer == 30) {
                this.level().broadcastEntityEvent((Entity)this, (byte)9);
                this.setAnimationState(0);
                this.setSpawn(0);
                this.spawnTimer = 0;
                this.spawn = 1;
            }
        }
        if (this.getHealth() < this.getMaxHealth() * 0.25f && this.getHealth() > 0.0f && this.spawn == 1) {
            this.setAnimationState(2);
            if (this.spawnTimer != 30) {
                ++this.spawnTimer;
            }
            if (this.spawnTimer == 30) {
                this.level().broadcastEntityEvent((Entity)this, (byte)9);
                this.setAnimationState(0);
                this.setSpawn(0);
                this.spawnTimer = 0;
                this.spawn = 2;
            }
        }
        if (this.animationPlay) {
            if (this.animationTimer != 20) {
                ++this.animationTimer;
            } else {
                this.setAnimationState(0);
                this.animationPlay = false;
            }
        }
        super.aiStep();
    }

    private void setGoals(int id) {
        if (id == 1) {
            this.goalSelector.removeGoal((Goal)this.rangedAttackGoal);
            this.goalSelector.addGoal(1, (Goal)this.mobAttackGoal);
        } else {
            this.goalSelector.removeGoal((Goal)this.mobAttackGoal);
            this.goalSelector.addGoal(1, (Goal)this.rangedAttackGoal);
            this.setAnimationState(0);
            this.animationPlay = false;
            this.animationTimer = 0;
        }
    }

    private void setSpawn(int id) {
        if (!this.level().isClientSide) {
            Skeleton summon;
            BlockPos blockpos = this.blockPosition().offset(-1 + this.random.nextInt(3), 1, -1 + this.random.nextInt(3));
            if (id == 0 && (summon = (Skeleton)EntityType.SKELETON.create(this.level())) != null) {
                summon.moveTo(blockpos, 0.0f, 0.0f);
                summon.finalizeSpawn((ServerLevelAccessor)((ServerLevel)this.level()), this.level().getCurrentDifficultyAt(blockpos), MobSpawnType.MOB_SUMMONED, (SpawnGroupData)null);
                summon.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)GaiaRegistry.HEADGEAR_MOB.get()));
                summon.setDropChance(EquipmentSlot.MAINHAND, 0.0f);
                summon.setDropChance(EquipmentSlot.OFFHAND, 0.0f);
                summon.setDropChance(EquipmentSlot.FEET, 0.0f);
                summon.setDropChance(EquipmentSlot.LEGS, 0.0f);
                summon.setDropChance(EquipmentSlot.CHEST, 0.0f);
                summon.setDropChance(EquipmentSlot.HEAD, 0.0f);
                this.level().addFreshEntity((Entity)summon);
            }
        }
    }

    private void setCombatTask() {
        if (this.getMainHandItem().is((Item)GaiaRegistry.SKELETON_STAFF.get())) {
            this.setGoals(0);
        } else {
            this.setGoals(1);
        }
    }

    @Override
    public boolean canAttackType(EntityType<?> type) {
        return super.canAttackType(type) && type != GaiaRegistry.ANUBIS.getEntityType();
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance instance) {
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)GaiaRegistry.SKELETON_STAFF.get()));
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData data) {
        data = super.finalizeSpawn(levelAccessor, difficultyInstance, spawnType, data);
        if (this.random.nextInt(4) == 0) {
            this.setMale(true);
        }
        this.populateDefaultEquipmentSlots(this.random, difficultyInstance);
        this.setCombatTask();
        return data;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("Male", this.isMale());
        tag.putInt("AnimationState", this.getAnimationState());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("Male")) {
            boolean male = tag.getBoolean("Male");
            this.setMale(male);
        }
        if (tag.contains("AnimationState")) {
            int state = tag.getInt("AnimationState");
            this.setAnimationState(state);
        }
    }

    protected SoundEvent getAmbientSound() {
        return !this.isMale() ? GaiaRegistry.ANUBIS.getSay() : GaiaRegistry.ANUBIS.getMaleSay();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return !this.isMale() ? GaiaRegistry.ANUBIS.getHurt() : GaiaRegistry.ANUBIS.getMaleHurt();
    }

    protected SoundEvent getDeathSound() {
        return !this.isMale() ? GaiaRegistry.ANUBIS.getDeath() : GaiaRegistry.ANUBIS.getMaleDeath();
    }

    protected int getFireImmuneTicks() {
        return 10;
    }

    public int getMaxSpawnClusterSize() {
        return 1;
    }

    public static boolean checkAnubisSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return Anubis.checkDaysPassed(levelAccessor) && Anubis.checkAboveSeaLevel(levelAccessor, pos) && Anubis.checkMonsterSpawnRules(entityType, (ServerLevelAccessor)levelAccessor, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }
}

