/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity;

import gaia.attachment.AttachmentHandler;
import gaia.attachment.friended.Friended;
import gaia.attachment.friended.IFriended;
import gaia.config.GaiaConfig;
import gaia.entity.AbstractAssistGaiaEntity;
import gaia.entity.goal.MobAttackGoal;
import gaia.entity.type.IDayMob;
import gaia.registry.GaiaRegistry;
import gaia.registry.GaiaTags;
import gaia.util.RangedUtil;
import gaia.util.SharedEntityData;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;

public class Bee
extends AbstractAssistGaiaEntity
implements IDayMob,
FlyingAnimal,
RangedAttackMob {
    private static final EntityDataAccessor<Boolean> MOVING = SynchedEntityData.defineId(Bee.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> ANIMATION_STATE = SynchedEntityData.defineId(Bee.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private final RangedAttackGoal rangedAttackGoal = new RangedAttackGoal((RangedAttackMob)this, 1.275, 20, 60, 15.0f);
    private final MobAttackGoal mobAttackGoal = new MobAttackGoal((PathfinderMob)this, 1.275, true);
    private int timer;
    private int switchDetect;
    private int switchEquip;
    private boolean animationPlay;
    private int animationTimer;

    public Bee(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.moveControl = new FlyingMoveControl((Mob)this, 20, true);
        this.setPathfindingMalus(PathType.DANGER_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.setPathfindingMalus(PathType.WATER_BORDER, 16.0f);
        this.setPathfindingMalus(PathType.COCOA, -1.0f);
        this.setPathfindingMalus(PathType.FENCE, -1.0f);
        this.timer = 0;
        this.switchDetect = 0;
        this.switchEquip = 0;
        this.animationPlay = false;
        this.animationTimer = 0;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(3, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new TemptGoal((PathfinderMob)this, 1.25, (Predicate)Ingredient.of((TagKey)ItemTags.FLOWERS), false));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(6, (Goal)new FloatGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetPlayerGoal = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
        if (((Boolean)GaiaConfig.COMMON.allPassiveMobsHostile.get()).booleanValue()) {
            this.targetSelector.addGoal(2, this.targetPlayerGoal);
        }
    }

    @Override
    public float getWalkTargetValue(BlockPos pos, LevelReader reader) {
        return reader.getBlockState(pos).isAir() ? 10.0f : 0.0f;
    }

    protected PathNavigation createNavigation(Level level) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, level){

            public boolean isStableDestination(BlockPos pos) {
                return !Bee.this.level().getBlockState(pos.below()).isAir();
            }

            public void tick() {
                super.tick();
            }
        };
        flyingpathnavigation.setCanOpenDoors(false);
        flyingpathnavigation.setCanFloat(false);
        flyingpathnavigation.setCanPassDoors(true);
        return flyingpathnavigation;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 40.0).add(Attributes.FOLLOW_RANGE, 20.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.FLYING_SPEED, 0.5).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.ARMOR, 4.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.3).add(Attributes.STEP_HEIGHT, 1.0);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(MOVING, (Object)false);
        builder.define(ANIMATION_STATE, (Object)0);
    }

    public boolean isFlying() {
        return !this.onGround();
    }

    public boolean isMoving() {
        return (Boolean)this.entityData.get(MOVING);
    }

    public void setMoving(boolean flag) {
        this.entityData.set(MOVING, (Object)flag);
    }

    public int getAnimationState() {
        return (Integer)this.entityData.get(ANIMATION_STATE);
    }

    public void setAnimationState(int state) {
        this.entityData.set(ANIMATION_STATE, (Object)state);
    }

    @Override
    public float getBaseDefense() {
        return SharedEntityData.getBaseDefense1();
    }

    public boolean hurt(DamageSource source, float damage) {
        float input = this.getBaseDamage(source, damage);
        return super.hurt(source, input);
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        if (target.isAlive()) {
            RangedUtil.poison(target, (LivingEntity)this, distanceFactor);
            this.setAnimationState(1);
            this.animationPlay = true;
            this.animationTimer = 0;
        }
    }

    public boolean doHurtTarget(Entity entityIn) {
        if (super.doHurtTarget(entityIn)) {
            if (entityIn instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entityIn;
                int effectTime = 0;
                if (this.level().getDifficulty() == Difficulty.NORMAL) {
                    effectTime = 10;
                } else if (this.level().getDifficulty() == Difficulty.HARD) {
                    effectTime = 20;
                }
                if (effectTime > 0) {
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.POISON, effectTime * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void aiStep() {
        if (!this.level().isClientSide && this.getHealth() >= this.getMaxHealth()) {
            if (this.detectMovement() && !this.isMoving()) {
                this.setMoving(true);
            }
            if (!this.detectMovement() && this.isMoving()) {
                this.setMoving(false);
            }
        }
        if (this.playerDetection(3, TargetingConditions.forCombat())) {
            if (this.switchDetect == 0) {
                this.switchDetect = 1;
            }
        } else if (this.switchDetect == 1) {
            this.switchDetect = 0;
        }
        if (this.switchDetect == 1 && this.switchEquip == 0) {
            if (this.timer <= 20) {
                ++this.timer;
            } else {
                this.setGoals(1);
                this.timer = 0;
                this.switchEquip = 1;
            }
        }
        if (this.switchDetect == 0 && this.switchEquip == 1) {
            if (this.timer <= 20) {
                ++this.timer;
            } else {
                this.setGoals(0);
                this.timer = 0;
                this.switchEquip = 0;
            }
        }
        if (this.animationPlay) {
            if (this.animationTimer != 20) {
                ++this.animationTimer;
            } else {
                this.setAnimationState(0);
                this.animationPlay = false;
            }
        }
        super.aiStep();
    }

    @Override
    public void onFriendlyChange(IFriended cap) {
        if (cap.isFriendly()) {
            this.setGoals(1);
            this.timer = 0;
            this.switchEquip = 1;
        }
    }

    private boolean detectMovement() {
        if (this.getDeltaMovement().horizontalDistanceSqr() > 2.500000277905201E-7) {
            BlockState blockstate = this.level().getBlockState(this.blockPosition().below());
            return !blockstate.isAir();
        }
        return false;
    }

    private void setGoals(int id) {
        if (id == 1) {
            this.goalSelector.removeGoal((Goal)this.rangedAttackGoal);
            this.goalSelector.addGoal(0, (Goal)this.mobAttackGoal);
        } else {
            Friended friended = AttachmentHandler.getFriended((LivingEntity)this);
            if (!friended.isFriendly()) {
                this.goalSelector.removeGoal((Goal)this.mobAttackGoal);
                this.goalSelector.addGoal(0, (Goal)this.rangedAttackGoal);
                this.setAnimationState(0);
                this.animationPlay = false;
                this.animationTimer = 0;
            }
        }
    }

    private void setCombatTask() {
        this.setGoals(0);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setCombatTask();
    }

    protected SoundEvent getAmbientSound() {
        return GaiaRegistry.BEE.getSay();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return GaiaRegistry.BEE.getHurt();
    }

    protected SoundEvent getDeathSound() {
        return GaiaRegistry.BEE.getDeath();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
    }

    public boolean canBeAffected(MobEffectInstance effectInstance) {
        return effectInstance.getEffect() != MobEffects.POISON && super.canBeAffected(effectInstance);
    }

    public boolean causeFallDamage(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    protected void checkFallDamage(double p_27754_, boolean p_27755_, BlockState state, BlockPos pos) {
    }

    public int getMaxSpawnClusterSize() {
        return 2;
    }

    public static boolean checkBeeSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return Bee.checkDaysPassed(levelAccessor) && Bee.checkDaytime(levelAccessor) && Bee.checkTagBlocks(levelAccessor, pos, GaiaTags.GAIA_SPAWABLE_ON) && Bee.checkAboveSeaLevel(levelAccessor, pos) && Bee.checkGaiaDaySpawnRules(entityType, levelAccessor, spawnType, pos, random);
    }
}

