/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity;

import gaia.config.GaiaConfig;
import gaia.entity.AbstractAssistGaiaEntity;
import gaia.entity.goal.MobAttackGoal;
import gaia.entity.type.IDayMob;
import gaia.registry.GaiaRegistry;
import gaia.registry.GaiaTags;
import gaia.util.SharedEntityData;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class Cyclops
extends AbstractAssistGaiaEntity
implements IDayMob {
    private static final EntityDataAccessor<Boolean> FLEEING = SynchedEntityData.defineId(Cyclops.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final MobAttackGoal mobAttackGoal = new MobAttackGoal((PathfinderMob)this, 1.25, true);
    private int buffEffect = 0;
    private boolean animationPlay = false;
    private int animationTimer = 0;

    public Cyclops(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetPlayerGoal = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
        if (((Boolean)GaiaConfig.COMMON.allPassiveMobsHostile.get()).booleanValue()) {
            this.targetSelector.addGoal(2, this.targetPlayerGoal);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 40.0).add(Attributes.FOLLOW_RANGE, 40.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.ARMOR, 4.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.3).add(Attributes.STEP_HEIGHT, 1.0);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(FLEEING, (Object)false);
    }

    public boolean isFleeing() {
        return (Boolean)this.entityData.get(FLEEING);
    }

    public void setFleeing(boolean flag) {
        this.entityData.set(FLEEING, (Object)flag);
    }

    @Override
    public float getBaseDefense() {
        return SharedEntityData.getBaseDefense1();
    }

    public boolean hurt(DamageSource source, float damage) {
        float input = this.getBaseDamage(source, damage);
        return super.hurt(source, input);
    }

    public boolean doHurtTarget(Entity entityIn) {
        if (super.doHurtTarget(entityIn)) {
            if (entityIn instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entityIn;
                int effectTime = 0;
                if (this.level().getDifficulty() == Difficulty.NORMAL) {
                    effectTime = 10;
                } else if (this.level().getDifficulty() == Difficulty.HARD) {
                    effectTime = 20;
                }
                if (effectTime > 0) {
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, effectTime * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void aiStep() {
        if (this.getHealth() <= this.getMaxHealth() * 0.25f && this.getHealth() > 0.0f && this.buffEffect == 0) {
            this.setGoals(1);
            this.setFleeing(true);
            this.buffEffect = 1;
            this.animationPlay = true;
        }
        if (this.getHealth() > this.getMaxHealth() * 0.25f && this.buffEffect == 1) {
            this.buffEffect = 0;
            this.animationPlay = false;
            this.animationTimer = 0;
        }
        if (this.animationPlay) {
            if (this.animationTimer != 15) {
                ++this.animationTimer;
            } else {
                this.setBuff();
                this.setGoals(0);
                this.setFleeing(false);
                this.animationPlay = false;
            }
        }
        super.aiStep();
    }

    private void setGoals(int id) {
        if (id == 1) {
            this.goalSelector.removeGoal((Goal)this.mobAttackGoal);
        } else {
            this.goalSelector.addGoal(1, (Goal)this.mobAttackGoal);
        }
    }

    private void setBuff() {
        this.level().broadcastEntityEvent((Entity)this, (byte)7);
        this.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 1200, 0));
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance instance) {
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.WOODEN_SWORD));
        this.setItemSlot(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.WOODEN_SWORD));
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData data) {
        data = super.finalizeSpawn(levelAccessor, difficultyInstance, spawnType, data);
        this.populateDefaultEquipmentSlots(this.random, difficultyInstance);
        this.populateDefaultEquipmentSlots(this.random, difficultyInstance);
        this.setGoals(0);
        return data;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setGoals(0);
    }

    protected SoundEvent getAmbientSound() {
        return GaiaRegistry.CYCLOPS.getSay();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return GaiaRegistry.CYCLOPS.getHurt();
    }

    protected SoundEvent getDeathSound() {
        return GaiaRegistry.CYCLOPS.getDeath();
    }

    public int getMaxSpawnClusterSize() {
        return 2;
    }

    public static boolean checkCyclopsSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return Cyclops.checkDaytime(levelAccessor) && Cyclops.checkTagBlocks(levelAccessor, pos, GaiaTags.GAIA_SPAWABLE_ON) && Cyclops.checkAboveSeaLevel(levelAccessor, pos) && Cyclops.checkGaiaDaySpawnRules(entityType, levelAccessor, spawnType, pos, random);
    }
}

