/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity;

import gaia.config.GaiaConfig;
import gaia.entity.AbstractAssistGaiaEntity;
import gaia.entity.Orc;
import gaia.entity.goal.MobAttackGoal;
import gaia.entity.type.IDayMob;
import gaia.registry.GaiaLootTables;
import gaia.registry.GaiaRegistry;
import gaia.registry.GaiaTags;
import gaia.util.EnchantUtil;
import gaia.util.RangedUtil;
import gaia.util.SharedEntityData;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreakDoorGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.loot.LootTable;
import net.neoforged.neoforge.common.ItemAbilities;
import org.jetbrains.annotations.Nullable;

public class Dwarf
extends AbstractAssistGaiaEntity
implements RangedAttackMob,
IDayMob {
    private static final EntityDataAccessor<Boolean> RANDOM_CLASS = SynchedEntityData.defineId(Dwarf.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final RangedBowAttackGoal<Dwarf> rangedBowAttackGoal = new RangedBowAttackGoal((Monster)this, 1.275, 20, 15.0f);
    private final MobAttackGoal collideAttackGoal = new MobAttackGoal((PathfinderMob)this, 1.275, true);
    private static final Predicate<Difficulty> DOOR_BREAKING_PREDICATE = difficulty -> difficulty == Difficulty.HARD;
    private final BreakDoorGoal breakDoorGoal = new BreakDoorGoal((Mob)this, DOOR_BREAKING_PREDICATE);
    private boolean canBreakDoors;

    public Dwarf(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.xpReward = 20;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetPlayerGoal = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
        if (((Boolean)GaiaConfig.COMMON.allPassiveMobsHostile.get()).booleanValue()) {
            this.targetSelector.addGoal(2, this.targetPlayerGoal);
        }
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Orc.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 80.0).add(Attributes.FOLLOW_RANGE, 26.0).add(Attributes.MOVEMENT_SPEED, 0.275).add(Attributes.ATTACK_DAMAGE, 8.0).add(Attributes.ARMOR, 8.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.25).add(Attributes.STEP_HEIGHT, 1.0);
    }

    @Override
    public int getGaiaLevel() {
        return 2;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(RANDOM_CLASS, (Object)true);
    }

    public boolean applyRandomClass() {
        return (Boolean)this.entityData.get(RANDOM_CLASS);
    }

    public void setRandomClass(boolean value) {
        this.entityData.set(RANDOM_CLASS, (Object)value);
    }

    @Override
    public int maxVariants() {
        return 2;
    }

    @Override
    public float getBaseDefense() {
        return SharedEntityData.getBaseDefense2();
    }

    public boolean hurt(DamageSource source, float damage) {
        float input = this.getBaseDamage(source, damage);
        if (!this.getOffhandItem().isEmpty() && this.getOffhandItem().canPerformAction(ItemAbilities.SHIELD_BLOCK)) {
            return !(source.getDirectEntity() instanceof AbstractArrow) && super.hurt(source, input);
        }
        return super.hurt(source, input);
    }

    public boolean doHurtTarget(Entity entityIn) {
        if (super.doHurtTarget(entityIn)) {
            if (entityIn instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entityIn;
                int effectTime = 0;
                if (this.level().getDifficulty() == Difficulty.NORMAL) {
                    effectTime = 10;
                } else if (this.level().getDifficulty() == Difficulty.HARD) {
                    effectTime = 20;
                }
                if (effectTime > 0) {
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, effectTime * 20, 0));
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.DIG_SLOWDOWN, effectTime * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        if (target.isAlive()) {
            RangedUtil.rangedAttack(target, (LivingEntity)this, distanceFactor);
        }
    }

    @Override
    public void aiStep() {
        super.aiStep();
    }

    public void setItemSlot(EquipmentSlot equipmentSlot, ItemStack stack) {
        super.setItemSlot(equipmentSlot, stack);
        if (equipmentSlot == EquipmentSlot.MAINHAND) {
            this.setCombatTask();
        }
    }

    private void setCombatTask() {
        this.goalSelector.removeGoal((Goal)this.collideAttackGoal);
        this.goalSelector.removeGoal(this.rangedBowAttackGoal);
        if (this.getMainHandItem().getItem() instanceof BowItem) {
            this.goalSelector.addGoal(1, this.rangedBowAttackGoal);
        } else {
            this.goalSelector.addGoal(1, (Goal)this.collideAttackGoal);
        }
    }

    protected ResourceKey<LootTable> getDefaultLootTable() {
        return switch (this.getVariant()) {
            default -> super.getDefaultLootTable();
            case 1 -> GaiaLootTables.DWARF_RANGED;
            case 2 -> GaiaLootTables.DWARF_MINER;
        };
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance instance) {
        if (this.applyRandomClass()) {
            if (random.nextInt(4) == 0) {
                ItemStack bowStack = new ItemStack((ItemLike)Items.BOW);
                bowStack.enchant(EnchantUtil.getEnchantmentHolder((Entity)this, (ResourceKey<Enchantment>)Enchantments.PUNCH), 1);
                this.setItemSlot(EquipmentSlot.MAINHAND, bowStack);
                if (random.nextBoolean() && random.nextBoolean()) {
                    ItemStack tippedArrow = new ItemStack((ItemLike)Items.TIPPED_ARROW);
                    if (random.nextInt(2) == 0) {
                        tippedArrow.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Potions.SLOWNESS));
                        this.setItemSlot(EquipmentSlot.OFFHAND, tippedArrow);
                    } else {
                        tippedArrow.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Potions.WEAKNESS));
                        this.setItemSlot(EquipmentSlot.OFFHAND, tippedArrow);
                    }
                }
                this.setVariant(1);
            } else if (random.nextInt(4) == 0) {
                this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.STONE_PICKAXE));
                this.setVariant(2);
            } else {
                this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.STONE_AXE));
                if (random.nextBoolean()) {
                    this.setItemSlot(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)GaiaRegistry.IRON_SHIELD.get()));
                    this.getAttribute(Attributes.KNOCKBACK_RESISTANCE).setBaseValue(0.25);
                }
                this.setVariant(0);
            }
        } else {
            this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.STONE_PICKAXE));
            this.setVariant(0);
        }
    }

    public boolean canBreakDoors() {
        return this.canBreakDoors;
    }

    public void setCanBreakDoors(boolean p_34337_) {
        if (GoalUtils.hasGroundPathNavigation((Mob)this)) {
            if (this.canBreakDoors != p_34337_) {
                this.canBreakDoors = p_34337_;
                ((GroundPathNavigation)this.getNavigation()).setCanOpenDoors(p_34337_);
                if (p_34337_) {
                    this.goalSelector.addGoal(1, (Goal)this.breakDoorGoal);
                } else {
                    this.goalSelector.removeGoal((Goal)this.breakDoorGoal);
                }
            }
        } else if (this.canBreakDoors) {
            this.goalSelector.removeGoal((Goal)this.breakDoorGoal);
            this.canBreakDoors = false;
        }
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData data) {
        data = super.finalizeSpawn(levelAccessor, difficultyInstance, spawnType, data);
        this.populateDefaultEquipmentSlots(this.random, difficultyInstance);
        this.populateDefaultEquipmentSlots(this.random, difficultyInstance);
        this.setCombatTask();
        return data;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("RandomClass", this.applyRandomClass());
        tag.putBoolean("CanBreakDoors", this.canBreakDoors());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("RandomClass")) {
            this.setRandomClass(tag.getBoolean("RandomClass"));
        }
        this.setCanBreakDoors(tag.getBoolean("CanBreakDoors"));
        this.setCombatTask();
    }

    @Override
    public boolean canAttackType(EntityType<?> type) {
        return super.canAttackType(type) && type != GaiaRegistry.DWARF.getEntityType();
    }

    protected SoundEvent getAmbientSound() {
        return GaiaRegistry.DWARF.getSay();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return GaiaRegistry.DWARF.getHurt();
    }

    protected SoundEvent getDeathSound() {
        return GaiaRegistry.DWARF.getDeath();
    }

    public int getMaxSpawnClusterSize() {
        return 1;
    }

    public static boolean checkDwarfSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return Dwarf.checkDaysPassed(levelAccessor) && Dwarf.checkDaytime(levelAccessor) && Dwarf.checkTagBlocks(levelAccessor, pos, GaiaTags.GAIA_SPAWABLE_ON) && Dwarf.checkAboveSeaLevel(levelAccessor, pos) && Dwarf.checkGaiaDaySpawnRules(entityType, levelAccessor, spawnType, pos, random);
    }
}

