/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class GaiaHorse
extends AbstractHorse {
    private int lifetime;

    public GaiaHorse(EntityType<? extends AbstractHorse> entityType, Level level) {
        super(entityType, level);
    }

    protected void randomizeAttributes(RandomSource randomSource) {
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(15.0);
        this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.3);
        this.getAttribute(Attributes.JUMP_STRENGTH).setBaseValue(GaiaHorse.generateJumpStrength(() -> ((RandomSource)randomSource).nextDouble()));
    }

    public boolean removeWhenFarAway(double distance) {
        return true;
    }

    public boolean isSaddleable() {
        return false;
    }

    public boolean canBeLeashed() {
        return false;
    }

    public boolean isPersistenceRequired() {
        return super.isPersistenceRequired();
    }

    public void aiStep() {
        if (!this.isVehicle() && !this.level().isClientSide) {
            if (!this.isPersistenceRequired()) {
                ++this.lifetime;
            }
            if (this.lifetime >= 1200) {
                this.discard();
            }
        }
        super.aiStep();
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        super.getAmbientSound();
        return SoundEvents.ZOMBIE_HORSE_AMBIENT;
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        super.getDeathSound();
        return SoundEvents.ZOMBIE_HORSE_DEATH;
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        super.getHurtSound(source);
        return SoundEvents.ZOMBIE_HORSE_HURT;
    }
}

