/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity;

import gaia.entity.AbstractGaiaEntity;
import gaia.entity.goal.MobAttackGoal;
import gaia.registry.GaiaRegistry;
import gaia.util.SharedEntityData;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.loot.LootTable;
import org.jetbrains.annotations.Nullable;

public class GelatinousSlime
extends AbstractGaiaEntity {
    private boolean animationPlay;
    private int animationTimer;
    public float targetSquish;
    public float squish;
    public float oSquish;

    public GelatinousSlime(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.xpReward = 20;
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.animationPlay = false;
        this.animationTimer = 0;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new MobAttackGoal((PathfinderMob)this, 1.15, true));
        this.goalSelector.addGoal(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetPlayerGoal = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
        this.targetSelector.addGoal(2, this.targetPlayerGoal);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 80.0).add(Attributes.FOLLOW_RANGE, 40.0).add(Attributes.MOVEMENT_SPEED, 0.125).add(Attributes.ATTACK_DAMAGE, 8.0).add(Attributes.ARMOR, 8.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.STEP_HEIGHT, 1.0);
    }

    @Override
    public int getGaiaLevel() {
        return 2;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
    }

    @Override
    public float getBaseDefense() {
        return SharedEntityData.getBaseDefense2();
    }

    public boolean hurt(DamageSource source, float damage) {
        float input = this.getBaseDamage(source, damage);
        if (source.getDirectEntity() instanceof AbstractArrow) {
            this.level().broadcastEntityEvent((Entity)this, (byte)8);
            this.heal(this.getMaxHealth() * 0.1f);
        }
        return super.hurt(source, input);
    }

    public boolean doHurtTarget(Entity entityIn) {
        if (super.doHurtTarget(entityIn)) {
            if (entityIn instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entityIn;
                int effectTime = 0;
                if (this.level().getDifficulty() == Difficulty.NORMAL) {
                    effectTime = 5;
                } else if (this.level().getDifficulty() == Difficulty.HARD) {
                    effectTime = 10;
                }
                if (effectTime > 0) {
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.POISON, effectTime * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    public void tick() {
        this.squish += (this.targetSquish - this.squish) * 0.5f;
        this.oSquish = this.squish;
        super.tick();
        if (this.tickCount % 60 == 0) {
            this.animationPlay = true;
            this.animationTimer = 0;
        }
        if (this.animationPlay) {
            this.targetSquish = -0.1f;
            if (this.animationTimer != 10) {
                ++this.animationTimer;
            } else {
                this.targetSquish = 1.0f;
                this.animationPlay = false;
            }
        }
        this.decreaseSquish();
    }

    protected void decreaseSquish() {
        this.targetSquish *= 0.6f;
    }

    @Override
    public void aiStep() {
        if (!this.level().isClientSide && this.isPassenger()) {
            this.stopRiding();
        }
        this.beaconMonster(4, entity -> {
            if (!(entity instanceof Player)) {
                entity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 100, 1, true, true));
            }
        });
        if (this.getHealth() < this.getMaxHealth() && !this.getOffhandItem().isEmpty()) {
            this.setItemSlot(EquipmentSlot.OFFHAND, ItemStack.EMPTY);
            this.level().broadcastEntityEvent((Entity)this, (byte)8);
            this.heal(this.getMaxHealth() * 0.2f);
        }
        super.aiStep();
    }

    protected void tickDeath() {
        if (!this.level().isClientSide) {
            this.spawnLingeringCloud(List.of(new MobEffectInstance(MobEffects.POISON, 40, 0)));
        }
        super.tickDeath();
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance instance) {
        ItemStack spawnItem = switch (random.nextInt(3)) {
            case 0 -> new ItemStack((ItemLike)Items.BOW);
            case 1 -> new ItemStack((ItemLike)Items.ARROW);
            case 2 -> new ItemStack((ItemLike)Items.STONE_SWORD);
            default -> ItemStack.EMPTY;
        };
        this.setItemSlot(EquipmentSlot.OFFHAND, spawnItem);
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData data) {
        data = super.finalizeSpawn(levelAccessor, difficultyInstance, spawnType, data);
        this.populateDefaultEquipmentSlots(this.random, difficultyInstance);
        this.setCanPickUpLoot(true);
        return data;
    }

    protected ResourceKey<LootTable> getDefaultLootTable() {
        if (this.random.nextBoolean()) {
            return EntityType.SKELETON.getDefaultLootTable();
        }
        return super.getDefaultLootTable();
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
    }

    protected SoundEvent getAmbientSound() {
        return GaiaRegistry.GELATINOUS_SLIME.getSay();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return GaiaRegistry.GELATINOUS_SLIME.getHurt();
    }

    protected SoundEvent getDeathSound() {
        return GaiaRegistry.GELATINOUS_SLIME.getDeath();
    }

    public boolean fireImmune() {
        return false;
    }

    public boolean canBeAffected(MobEffectInstance effectInstance) {
        return effectInstance.getEffect() != MobEffects.POISON && super.canBeAffected(effectInstance);
    }

    public int getMaxSpawnClusterSize() {
        return 1;
    }

    public static boolean checkGelatinousSlimeSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return GelatinousSlime.checkDaysPassed(levelAccessor) && GelatinousSlime.checkAboveSeaLevel(levelAccessor, pos) && GelatinousSlime.checkMonsterSpawnRules(entityType, (ServerLevelAccessor)levelAccessor, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }
}

