/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity;

import gaia.config.GaiaConfig;
import gaia.entity.AbstractAssistGaiaEntity;
import gaia.entity.type.IDayMob;
import gaia.registry.GaiaRegistry;
import gaia.registry.GaiaTags;
import gaia.util.EnchantUtil;
import gaia.util.SharedEntityData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Valkyrie
extends AbstractAssistGaiaEntity
implements IDayMob,
PowerableMob {
    private static final EntityDataAccessor<Boolean> IS_BUFFED = SynchedEntityData.defineId(Valkyrie.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> ANNOYED = SynchedEntityData.defineId(Valkyrie.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> ANIMATION_STATE = SynchedEntityData.defineId(Valkyrie.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private final MeleeAttackGoal meleeAttackGoal = new MeleeAttackGoal((PathfinderMob)this, 1.3, true);
    private int aggression;
    private int aggressive;
    private int buffEffect;
    private boolean animationPlay;
    private int animationTimer;

    public Valkyrie(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.xpReward = 40;
        this.aggression = 0;
        this.aggressive = 0;
        this.buffEffect = 0;
        this.animationPlay = false;
        this.animationTimer = 0;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetPlayerGoal = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
        if (((Boolean)GaiaConfig.COMMON.allPassiveMobsHostile.get()).booleanValue()) {
            this.targetSelector.addGoal(2, this.targetPlayerGoal);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 160.0).add(Attributes.FOLLOW_RANGE, 40.0).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.ATTACK_DAMAGE, 12.0).add(Attributes.ARMOR, 12.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.2).add(Attributes.STEP_HEIGHT, 1.0);
    }

    @Override
    public int getGaiaLevel() {
        return 3;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(IS_BUFFED, (Object)false);
        builder.define(ANNOYED, (Object)false);
        builder.define(ANIMATION_STATE, (Object)0);
    }

    public boolean isBuffed() {
        return (Boolean)this.entityData.get(IS_BUFFED);
    }

    public void setBuffed(boolean isBuffed) {
        this.entityData.set(IS_BUFFED, (Object)isBuffed);
    }

    public boolean isAnnoyed() {
        return (Boolean)this.entityData.get(ANNOYED);
    }

    public void setAnnoyed(boolean value) {
        this.entityData.set(ANNOYED, (Object)value);
    }

    public int getAnimationState() {
        return (Integer)this.entityData.get(ANIMATION_STATE);
    }

    public void setAnimationState(int state) {
        this.entityData.set(ANIMATION_STATE, (Object)state);
    }

    @Override
    public float getBaseDefense() {
        return SharedEntityData.getBaseDefense3();
    }

    public boolean hurt(DamageSource source, float damage) {
        float input = this.getBaseDamage(source, damage);
        if (this.isPowered()) {
            return source.isDirect() && super.hurt(source, input);
        }
        return super.hurt(source, input);
    }

    public boolean isPowered() {
        return this.getHealth() < this.getMaxHealth() / 2.0f;
    }

    public boolean doHurtTarget(Entity entityIn) {
        if (super.doHurtTarget(entityIn)) {
            if (entityIn instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entityIn;
                int effectTime = 0;
                int effectTime2 = 0;
                if (this.level().getDifficulty() == Difficulty.NORMAL) {
                    effectTime = 20;
                    effectTime2 = 10;
                } else if (this.level().getDifficulty() == Difficulty.HARD) {
                    effectTime = 30;
                    effectTime2 = 20;
                }
                if (effectTime > 0) {
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, effectTime * 20, 0));
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.DIG_SLOWDOWN, effectTime2 * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void aiStep() {
        Vec3 motion = this.getDeltaMovement();
        if (!this.onGround() && motion.y < 0.0) {
            this.setDeltaMovement(motion.multiply(1.0, 0.6, 1.0));
        }
        if (!this.level().isClientSide && this.isPassenger()) {
            this.stopRiding();
        }
        if (!this.isAnnoyed()) {
            if (this.aggressive <= 4) {
                if (this.playerDetection(6, TargetingConditions.forCombat())) {
                    if (this.aggression <= 60) {
                        ++this.aggression;
                    } else {
                        this.aggression = 0;
                        ++this.aggressive;
                    }
                    if (this.aggression >= 50) {
                        this.level().broadcastEntityEvent((Entity)this, (byte)11);
                    }
                }
            } else {
                this.setAnnoyed(true);
                this.setGoals(0);
                this.setGoals(1);
                this.giveShield();
            }
        }
        if (this.getHealth() < this.getMaxHealth() && !this.isAnnoyed()) {
            this.setAnnoyed(true);
            this.setGoals(0);
            this.setGoals(1);
            this.giveShield();
        }
        if (this.getHealth() <= this.getMaxHealth() * 0.25f && this.getHealth() > 0.0f && this.buffEffect == 0) {
            this.setGoals(2);
            this.setAnimationState(1);
            this.setBuffed(true);
            this.buffEffect = 1;
            this.animationPlay = true;
        }
        if (this.getHealth() > this.getMaxHealth() * 0.25f && this.buffEffect == 1) {
            this.buffEffect = 0;
            this.animationPlay = false;
            this.animationTimer = 0;
        }
        if (this.animationPlay) {
            if (this.animationTimer != 15) {
                ++this.animationTimer;
            } else {
                this.setBuff();
                this.setBuffed(false);
                this.setGoals(1);
                this.setAnimationState(0);
                this.animationPlay = false;
            }
        }
        if (this.isDeadOrDying()) {
            for (int i = 0; i < 2; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.EXPLOSION, this.getX() + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth(), this.getY() + this.random.nextDouble() * (double)this.getBbHeight(), this.getZ() + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth(), 0.0, 0.0, 0.0);
            }
        } else {
            super.aiStep();
        }
    }

    private void setGoals(int id) {
        if (this.level().isClientSide) {
            return;
        }
        if (id == 2) {
            this.goalSelector.removeGoal((Goal)this.meleeAttackGoal);
        } else if (id == 1) {
            this.goalSelector.addGoal(1, (Goal)this.meleeAttackGoal);
        } else {
            this.targetSelector.addGoal(2, this.targetPlayerGoal);
        }
    }

    private void giveShield() {
        ItemStack shield = new ItemStack((ItemLike)GaiaRegistry.IRON_SHIELD.get());
        this.setItemSlot(EquipmentSlot.OFFHAND, shield);
    }

    private void setBuff() {
        this.level().broadcastEntityEvent((Entity)this, (byte)7);
        this.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 1200, 0));
        this.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 1200, 0));
    }

    private void setCombatTask() {
        this.goalSelector.removeGoal((Goal)this.meleeAttackGoal);
        this.targetSelector.removeGoal(this.targetPlayerGoal);
        if (this.isAnnoyed()) {
            this.setGoals(0);
            this.setGoals(1);
        }
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance instance) {
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.IRON_SWORD));
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData data) {
        data = super.finalizeSpawn(levelAccessor, difficultyInstance, spawnType, data);
        this.setGoals(1);
        if (this.random.nextInt(4) == 0) {
            this.setVariant(1);
        }
        if (this.random.nextInt(10) == 0) {
            this.setBaby(true);
        }
        this.populateDefaultEquipmentSlots(this.random, difficultyInstance);
        this.populateDefaultEquipmentEnchantments(levelAccessor, this.random, difficultyInstance);
        ItemStack swimmingBoots = new ItemStack((ItemLike)Items.LEATHER_BOOTS);
        this.setItemSlot(EquipmentSlot.FEET, swimmingBoots);
        swimmingBoots.enchant(EnchantUtil.getEnchantmentHolder((Entity)this, (ResourceKey<Enchantment>)Enchantments.DEPTH_STRIDER), 3);
        this.setCombatTask();
        return data;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("annoyed", this.isAnnoyed());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("annoyed")) {
            this.setAnnoyed(tag.getBoolean("annoyed"));
        }
        this.setCombatTask();
    }

    protected SoundEvent getAmbientSound() {
        return GaiaRegistry.VALKYRIE.getSay();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return GaiaRegistry.VALKYRIE.getHurt();
    }

    protected SoundEvent getDeathSound() {
        return GaiaRegistry.VALKYRIE.getDeath();
    }

    public int getMaxSpawnClusterSize() {
        return 1;
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    public boolean causeFallDamage(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    protected void checkFallDamage(double p_27754_, boolean p_27755_, BlockState state, BlockPos pos) {
    }

    public boolean fireImmune() {
        return true;
    }

    public static boolean checkValkyrieSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return Valkyrie.checkDaysPassed(levelAccessor) && Valkyrie.checkDaytime(levelAccessor) && Valkyrie.checkTagBlocks(levelAccessor, pos, GaiaTags.GAIA_SPAWABLE_ON) && Valkyrie.checkAboveSeaLevel(levelAccessor, pos) && Valkyrie.checkGaiaDaySpawnRules(entityType, levelAccessor, spawnType, pos, random);
    }
}

