/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity;

import gaia.entity.AbstractGaiaEntity;
import gaia.entity.goal.MobAttackGoal;
import gaia.registry.GaiaRegistry;
import gaia.util.SharedEntityData;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class WitherCow
extends AbstractGaiaEntity {
    public WitherCow(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.xpReward = 0;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new MobAttackGoal((PathfinderMob)this, 1.15, true));
        this.goalSelector.addGoal(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetPlayerGoal = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
        this.targetSelector.addGoal(2, this.targetPlayerGoal);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 40.0).add(Attributes.FOLLOW_RANGE, 30.0).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.ARMOR, 4.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.3).add(Attributes.STEP_HEIGHT, 1.0);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
    }

    @Override
    public float getBaseDefense() {
        return SharedEntityData.getBaseDefense1();
    }

    public boolean hurt(DamageSource source, float damage) {
        float input = this.getBaseDamage(source, damage);
        return super.hurt(source, input);
    }

    public boolean doHurtTarget(Entity entityIn) {
        if (super.doHurtTarget(entityIn)) {
            if (entityIn instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entityIn;
                int effectTime = 0;
                if (this.level().getDifficulty() == Difficulty.NORMAL) {
                    effectTime = 5;
                } else if (this.level().getDifficulty() == Difficulty.HARD) {
                    effectTime = 10;
                }
                if (effectTime > 0) {
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.WITHER, effectTime * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void aiStep() {
        this.beaconMonster(2, entity -> entity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 100, 0, true, true)));
        for (int i = 0; i < 2; ++i) {
            this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getX() + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth(), this.getY() + this.random.nextDouble() * (double)this.getBbHeight(), this.getZ() + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth(), 0.0, 0.0, 0.0);
        }
        super.aiStep();
    }

    protected void tickDeath() {
        if (!this.level().isClientSide) {
            this.spawnLingeringCloud(List.of(new MobEffectInstance(MobEffects.WITHER, 200, 0)));
        }
        super.tickDeath();
    }

    public boolean canBeAffected(MobEffectInstance effectInstance) {
        return effectInstance.getEffect() != MobEffects.WITHER && super.canBeAffected(effectInstance);
    }

    protected SoundEvent getAmbientSound() {
        return GaiaRegistry.WITHER_COW.getSay();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return GaiaRegistry.WITHER_COW.getHurt();
    }

    protected SoundEvent getDeathSound() {
        return GaiaRegistry.WITHER_COW.getDeath();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound(GaiaRegistry.WITHER_COW.getStep(), 0.15f, 1.0f);
    }

    public int getMaxSpawnClusterSize() {
        return 1;
    }

    public static boolean checkWitherCowSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return WitherCow.checkDaysPassed(levelAccessor) && WitherCow.checkAboveSeaLevel(levelAccessor, pos) && WitherCow.checkMonsterSpawnRules(entityType, (ServerLevelAccessor)levelAccessor, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }
}

