/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity;

import gaia.config.GaiaConfig;
import gaia.entity.AbstractAssistGaiaEntity;
import gaia.item.weapon.book.WeaponBookItem;
import gaia.registry.GaiaRegistry;
import gaia.util.RangedUtil;
import gaia.util.SharedEntityData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class WizardHarpy
extends AbstractAssistGaiaEntity
implements RangedAttackMob {
    private static final EntityDataAccessor<Integer> ANIMATION_STATE = SynchedEntityData.defineId(WizardHarpy.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<ItemStack> STORED_STACK = SynchedEntityData.defineId(WizardHarpy.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private final RangedAttackGoal rangedAttackGoal = new RangedAttackGoal((RangedAttackMob)this, 1.275, 20, 60, 15.0f);
    private final AvoidEntityGoal<Player> avoidPlayerGoal = new AvoidEntityGoal((PathfinderMob)this, Player.class, 20.0f, 1.25, 1.3);
    private boolean animationPlay = false;
    private int animationTimer = 0;
    private int switchHealth = 0;

    public WizardHarpy(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetPlayerGoal = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
        if (((Boolean)GaiaConfig.COMMON.allPassiveMobsHostile.get()).booleanValue()) {
            this.targetSelector.addGoal(2, this.targetPlayerGoal);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 40.0).add(Attributes.FOLLOW_RANGE, 40.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.ARMOR, 4.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.3).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.STEP_HEIGHT, 1.0);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ANIMATION_STATE, (Object)0);
        builder.define(STORED_STACK, (Object)ItemStack.EMPTY);
    }

    public int getAnimationState() {
        return (Integer)this.entityData.get(ANIMATION_STATE);
    }

    public void setAnimationState(int state) {
        this.entityData.set(ANIMATION_STATE, (Object)state);
    }

    public ItemStack getStoredStack() {
        return (ItemStack)this.entityData.get(STORED_STACK);
    }

    public void setStoredStack(ItemStack stack) {
        this.entityData.set(STORED_STACK, (Object)stack);
    }

    @Override
    public float getBaseDefense() {
        return SharedEntityData.getBaseDefense1();
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        if (target.isAlive()) {
            ItemStack offhandItem = this.getOffhandItem();
            if (offhandItem.is((Item)GaiaRegistry.WEAPON_BOOK_FREEZING.get())) {
                RangedUtil.magicRandom(target, (LivingEntity)this, distanceFactor, 0.0, (Holder<MobEffect>)MobEffects.MOVEMENT_SLOWDOWN);
            }
            if (offhandItem.is((Item)GaiaRegistry.WEAPON_BOOK_NIGHTMARE.get())) {
                RangedUtil.magicRandom(target, (LivingEntity)this, distanceFactor, 0.0, (Holder<MobEffect>)MobEffects.DIG_SLOWDOWN);
            }
            if (offhandItem.is((Item)GaiaRegistry.WEAPON_BOOK_METAL.get())) {
                RangedUtil.magicRandom(target, (LivingEntity)this, distanceFactor, 0.0, (Holder<MobEffect>)MobEffects.CONFUSION);
            }
            if (offhandItem.is((Item)GaiaRegistry.WEAPON_BOOK_ENDER.get())) {
                RangedUtil.magicRandom(target, (LivingEntity)this, distanceFactor, 0.0, (Holder<MobEffect>)MobEffects.BLINDNESS);
            }
            if (offhandItem.is((Item)GaiaRegistry.WEAPON_BOOK_HUNGER.get())) {
                RangedUtil.magicRandom(target, (LivingEntity)this, distanceFactor, 0.0, (Holder<MobEffect>)MobEffects.HUNGER);
            }
            if (offhandItem.is((Item)GaiaRegistry.WEAPON_BOOK_BATTLE.get())) {
                RangedUtil.magicRandom(target, (LivingEntity)this, distanceFactor, 0.0, (Holder<MobEffect>)MobEffects.WEAKNESS);
            }
            if (offhandItem.is((Item)GaiaRegistry.WEAPON_BOOK_NATURE.get())) {
                RangedUtil.magicRandom(target, (LivingEntity)this, distanceFactor, 0.0, (Holder<MobEffect>)MobEffects.POISON);
            }
            if (offhandItem.is((Item)GaiaRegistry.WEAPON_BOOK_WITHER.get())) {
                RangedUtil.magicRandom(target, (LivingEntity)this, distanceFactor, 0.0, (Holder<MobEffect>)MobEffects.WITHER);
            }
            if (offhandItem.is((Item)GaiaRegistry.WEAPON_BOOK.get())) {
                RangedUtil.magic(target, (LivingEntity)this, distanceFactor);
            }
            this.setAnimationState(1);
            this.animationPlay = true;
            this.animationTimer = 0;
        }
    }

    public boolean hurt(DamageSource source, float damage) {
        float input = this.getBaseDamage(source, damage);
        return super.hurt(source, input);
    }

    @Override
    public void aiStep() {
        Vec3 motion = this.getDeltaMovement();
        if (!this.onGround() && motion.y < 0.0) {
            this.setDeltaMovement(motion.multiply(1.0, 0.6, 1.0));
        }
        if (this.getHealth() < this.getMaxHealth() * 0.25f && this.switchHealth == 0) {
            switch (this.random.nextInt(2)) {
                case 0: {
                    this.setGoals(1);
                    this.setStoredStack(this.getOffhandItem());
                    this.setItemSlot(EquipmentSlot.OFFHAND, ItemStack.EMPTY);
                    this.setAnimationState(2);
                    this.switchHealth = 1;
                    break;
                }
                case 1: {
                    this.switchHealth = 2;
                }
            }
        }
        if (this.getHealth() > this.getMaxHealth() * 0.25f && this.switchHealth == 1) {
            this.setGoals(0);
            this.setItemSlot(EquipmentSlot.OFFHAND, this.getStoredStack());
            this.setStoredStack(ItemStack.EMPTY);
            this.setAnimationState(0);
            this.switchHealth = 0;
        }
        if (this.animationPlay) {
            if (this.animationTimer != 20) {
                ++this.animationTimer;
            } else {
                this.setAnimationState(0);
                this.animationPlay = false;
            }
        }
        super.aiStep();
    }

    private void setGoals(int id) {
        if (id == 1) {
            this.goalSelector.removeGoal((Goal)this.rangedAttackGoal);
            this.goalSelector.addGoal(3, this.avoidPlayerGoal);
        } else {
            this.goalSelector.removeGoal(this.avoidPlayerGoal);
            this.goalSelector.addGoal(1, (Goal)this.rangedAttackGoal);
            this.setAnimationState(0);
            this.animationPlay = false;
            this.animationTimer = 0;
        }
    }

    public boolean causeFallDamage(float distance, float multiplier, DamageSource source) {
        return false;
    }

    private void setCombatTask() {
        this.goalSelector.removeGoal(this.avoidPlayerGoal);
        this.goalSelector.removeGoal((Goal)this.rangedAttackGoal);
        ItemStack itemstack = this.getOffhandItem();
        if (itemstack.getItem() instanceof WeaponBookItem) {
            this.setGoals(0);
        } else {
            this.setGoals(1);
        }
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance instance) {
        switch (random.nextInt(3)) {
            case 0: {
                this.setItemSlot(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)GaiaRegistry.WEAPON_BOOK_FREEZING.get()));
                break;
            }
            case 1: {
                this.setItemSlot(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)GaiaRegistry.WEAPON_BOOK_NIGHTMARE.get()));
                break;
            }
            case 2: {
                this.setItemSlot(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)GaiaRegistry.WEAPON_BOOK_METAL.get()));
                break;
            }
            case 3: {
                this.setItemSlot(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)GaiaRegistry.WEAPON_BOOK_ENDER.get()));
                break;
            }
            case 4: {
                this.setItemSlot(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)GaiaRegistry.WEAPON_BOOK_HUNGER.get()));
                break;
            }
            case 5: {
                this.setItemSlot(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)GaiaRegistry.WEAPON_BOOK_BATTLE.get()));
                break;
            }
            case 6: {
                this.setItemSlot(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)GaiaRegistry.WEAPON_BOOK_NATURE.get()));
                break;
            }
            case 7: {
                this.setItemSlot(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)GaiaRegistry.WEAPON_BOOK_WITHER.get()));
                break;
            }
            default: {
                this.setItemSlot(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)GaiaRegistry.WEAPON_BOOK.get()));
            }
        }
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData data) {
        data = super.finalizeSpawn(levelAccessor, difficultyInstance, spawnType, data);
        this.populateDefaultEquipmentSlots(this.random, difficultyInstance);
        this.populateDefaultEquipmentSlots(this.random, difficultyInstance);
        this.setCombatTask();
        return data;
    }

    protected SoundEvent getAmbientSound() {
        return GaiaRegistry.WIZARD_HARPY.getSay();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return GaiaRegistry.WIZARD_HARPY.getHurt();
    }

    protected SoundEvent getDeathSound() {
        return GaiaRegistry.WIZARD_HARPY.getDeath();
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setCombatTask();
    }

    public boolean fireImmune() {
        return true;
    }

    public int getMaxSpawnClusterSize() {
        return 2;
    }

    public static boolean checkWizardHarpySpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return WizardHarpy.checkDaysPassed(levelAccessor) && WizardHarpy.checkAboveSeaLevel(levelAccessor, pos) && WizardHarpy.checkGaiaDaySpawnRules(entityType, levelAccessor, spawnType, pos, random);
    }
}

