/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity.projectile;

import gaia.registry.GaiaRegistry;
import gaia.util.SharedEntityData;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class PoisonProjectile
extends SmallFireball {
    public PoisonProjectile(EntityType<? extends SmallFireball> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public PoisonProjectile(Level p_37375_, LivingEntity p_37376_, Vec3 p_347501_) {
        super(p_37375_, p_37376_, p_347501_);
    }

    public PoisonProjectile(Level p_37367_, double p_37368_, double p_37369_, double p_37370_, Vec3 p_347543_) {
        super(p_37367_, p_37368_, p_37369_, p_37370_, p_347543_);
    }

    public ItemStack getItem() {
        ItemStack itemstack = super.getItem();
        return itemstack.isEmpty() ? new ItemStack((ItemLike)GaiaRegistry.PROJECTILE_POISON.get()) : itemstack;
    }

    public EntityType<?> getType() {
        return GaiaRegistry.POISON.get();
    }

    protected ParticleOptions getTrailParticle() {
        return ParticleTypes.END_ROD;
    }

    public void tick() {
        super.tick();
        if (this.tickCount > 60) {
            this.discard();
        }
    }

    protected float getInertia() {
        return this.isInvulnerable() ? 0.73f : super.getInertia();
    }

    public boolean isOnFire() {
        return false;
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
    }

    protected void onHitBlock(BlockHitResult hitResult) {
    }

    protected void onHitEntity(EntityHitResult entityResult) {
        Entity owner;
        if (!this.level().isClientSide && (owner = this.getOwner()) instanceof LivingEntity) {
            LivingEntity ownerEntity = (LivingEntity)owner;
            Entity entity = entityResult.getEntity();
            entity.hurt(this.damageSources().indirectMagic((Entity)this, (Entity)ownerEntity), (float)SharedEntityData.getAttackDamage2() / 2.0f);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                int effectTime = 0;
                if (this.level().getDifficulty() == Difficulty.NORMAL) {
                    effectTime = 10;
                } else if (this.level().getDifficulty() == Difficulty.HARD) {
                    effectTime = 20;
                }
                if (effectTime > 0) {
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.POISON, effectTime * 20, 1));
                }
            }
        }
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    public boolean hurt(DamageSource source, float amount) {
        return false;
    }
}

