/*
 * Decompiled with CFR 0.152.
 */
package gaia.entity.projectile;

import gaia.registry.GaiaRegistry;
import gaia.util.SharedEntityData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public class WebProjectile
extends SmallFireball {
    public WebProjectile(EntityType<? extends SmallFireball> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public WebProjectile(Level p_37375_, LivingEntity p_37376_, Vec3 p_347501_) {
        super(p_37375_, p_37376_, p_347501_);
    }

    public WebProjectile(Level p_37367_, double p_37368_, double p_37369_, double p_37370_, Vec3 p_347543_) {
        super(p_37367_, p_37368_, p_37369_, p_37370_, p_347543_);
    }

    public ItemStack getItem() {
        ItemStack itemstack = super.getItem();
        return itemstack.isEmpty() ? new ItemStack((ItemLike)GaiaRegistry.PROJECTILE_WEB.get()) : itemstack;
    }

    public EntityType<?> getType() {
        return GaiaRegistry.WEB.get();
    }

    protected ParticleOptions getTrailParticle() {
        return ParticleTypes.SPIT;
    }

    public void tick() {
        super.tick();
        if (this.tickCount > 60) {
            this.discard();
        }
    }

    protected float getInertia() {
        return this.isInvulnerable() ? 0.73f : super.getInertia();
    }

    public boolean isOnFire() {
        return false;
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
    }

    protected void onHitEntity(EntityHitResult entityResult) {
        Entity owner;
        if (!this.level().isClientSide && (owner = this.getOwner()) instanceof LivingEntity) {
            LivingEntity ownerEntity = (LivingEntity)owner;
            entityResult.getEntity().hurt(this.damageSources().indirectMagic((Entity)this, (Entity)ownerEntity), (float)SharedEntityData.getAttackDamage2() / 2.0f);
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        Entity entity;
        BlockState blockstate = this.level().getBlockState(result.getBlockPos());
        blockstate.onProjectileHit(this.level(), blockstate, result, (Projectile)this);
        if (!(this.level().isClientSide || (entity = this.getOwner()) instanceof Mob && !EventHooks.canEntityGrief((Level)this.level(), (Entity)this))) {
            BlockPos blockpos = result.getBlockPos().relative(result.getDirection());
            if (this.level().isEmptyBlock(blockpos)) {
                this.level().setBlockAndUpdate(blockpos, Blocks.COBWEB.defaultBlockState());
            }
        }
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    public boolean hurt(DamageSource source, float amount) {
        return false;
    }
}

